/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.plus;

import com.bxm.adscounter.rtb.common.control.plus.PlusControl;
import com.bxm.adscounter.rtb.common.control.plus.PlusControlConfig;
import com.bxm.adscounter.rtb.common.control.plus.PlusQueueService;
import com.bxm.adscounter.rtb.common.control.plus.RedisPlusControlScheduler;
import com.bxm.adscounter.rtb.common.mapper.SrcAdUserAccessLogMapper;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.zk.ZkClientHolder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisPlusControlImpl
implements PlusControl {
    private static final Logger log = LoggerFactory.getLogger(RedisPlusControlImpl.class);
    private static final String SPLIT = "|";
    private static final int COUNT_EXPIRE_TIME = Math.toIntExact(Duration.ofDays(30L).getSeconds());
    private final PlusControlConfig config;
    private final ScheduledThreadPoolExecutor control = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("control"));
    private final JedisPool jedisPool;
    private final MeterRegistry registry;
    private final EventPark eventPark;
    private final RedisPlusControlScheduler scheduler;
    private final LeaderLatch leaderLatch;
    private final PlusQueueService plusQueueService;

    public RedisPlusControlImpl(PlusControlConfig config, JedisPool jedisPool, MeterRegistry registry, EventPark eventPark, ZkClientHolder zkClientHolder, SrcAdUserAccessLogMapper srcAdUserAccessLogMapper, PlusQueueService plusQueueService) {
        this.eventPark = eventPark;
        this.plusQueueService = plusQueueService;
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)config.getDimension()), (Object)"dimension cannot be null");
        Preconditions.checkNotNull(config.getConsumer(), (Object)"consumer cannot be null");
        long limit = config.getLimit();
        Preconditions.checkArgument((limit > 0L && limit < 10000L ? 1 : 0) != 0, (Object)"count must > 0 and < 10000");
        this.config = config;
        this.jedisPool = jedisPool;
        this.registry = registry;
        this.scheduler = new RedisPlusControlScheduler(this, jedisPool, eventPark, srcAdUserAccessLogMapper, registry, this.plusQueueService);
        this.leaderLatch = new LeaderLatch(zkClientHolder.get(), "/adscounter/rtb/control/plus/" + config.getDimension());
    }

    @Override
    public void start() {
        this.leaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                Integer delay = Optional.ofNullable(RedisPlusControlImpl.this.config.getN()).orElse(1);
                if (log.isInfoEnabled()) {
                    log.info("[{}] plus Control Start, Delay time is {} minute", (Object)RedisPlusControlImpl.this.config.getDimension(), (Object)delay);
                }
                RedisPlusControlImpl.this.control.scheduleWithFixedDelay(RedisPlusControlImpl.this.scheduler, 0L, delay.intValue(), TimeUnit.MINUTES);
            }

            public void notLeader() {
            }
        });
        try {
            this.leaderLatch.start();
        }
        catch (Exception e) {
            log.error("start: ", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.leaderLatch.close();
        }
        catch (Exception e) {
            log.error("shutdown: ", (Throwable)e);
        }
        this.control.shutdownNow();
    }

    @Override
    public void count() {
        this.addCount();
        this.registry.counter("plus.control.count", this.tags()).increment();
    }

    @Override
    public void countAdGroup(String adGroupId) {
        if (this.config.isEveryGroupDimension()) {
            this.addAdGroupCount(adGroupId);
            this.registry.counter("plus.control.count.adgroup", this.tags()).increment();
        }
    }

    @Override
    public int getCount() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            int n = NumberUtils.toInt((String)jedis.get(RedisPlusControlImpl.string(this.config.getDimension()).generateKey()));
            return n;
        }
    }

    @Override
    public void push(String id) {
        this.lpush(id);
        this.registry.counter("plus.control.list", this.tags()).increment();
    }

    @Override
    public void refresh() {
        this.control.remove(this.scheduler);
        this.start();
    }

    @Override
    public void delete() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String dimension = this.config.getDimension();
            String list = RedisPlusControlImpl.list(dimension).generateKey();
            jedis.del(list);
        }
    }

    @Override
    public PlusControlConfig getConfig() {
        return this.config;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    private void addCount() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisPlusControlImpl.string(this.config.getDimension()).generateKey();
            Long rs = jedis.incr(key);
            jedis.expire(key, COUNT_EXPIRE_TIME);
            if (log.isDebugEnabled()) {
                log.debug("{} after decrBy {}", (Object)key, (Object)rs);
            }
        }
    }

    private void addAdGroupCount(String adGroupId) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisPlusControlImpl.strAdGroupCount(this.config.getDimension(), adGroupId).generateKey();
            Long rs = jedis.incr(key);
            if (log.isDebugEnabled()) {
                log.debug("{} after decrBy {}", (Object)key, (Object)rs);
            }
        }
    }

    private void lpush(String id) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.lpush(RedisPlusControlImpl.list(this.config.getDimension()).generateKey(), new String[]{RedisPlusControlImpl.createLargeId(id)});
        }
    }

    private List<Tag> tags() {
        return Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"dim", (String)this.config.getDimension())});
    }

    static String createLargeId(String id) {
        return System.currentTimeMillis() + SPLIT + id;
    }

    static KeyGenerator string(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "plus", "count", dimension});
    }

    static KeyGenerator list(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "plus", "list", dimension});
    }

    private static KeyGenerator strAdGroupCount(String dimension, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "plus", "count", dimension, adGroupId});
    }
}

