/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.plus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.rtb.common.control.AbstractStandaloneControlScheduler;
import com.bxm.adscounter.rtb.common.control.plus.PlusControl;
import com.bxm.adscounter.rtb.common.control.plus.PlusControlConfig;
import com.bxm.adscounter.rtb.common.control.plus.PlusQueueService;
import com.bxm.adscounter.rtb.common.control.plus.event.PlusNotEnoughEvent;
import com.bxm.adscounter.rtb.common.data.QueryParam;
import com.bxm.adscounter.rtb.common.data.SrcAdUserAccessLog;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.adscounter.rtb.common.mapper.SrcAdUserAccessLogMapper;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Deprecated
public class RedisPlusControlScheduler
extends AbstractStandaloneControlScheduler {
    private static final Logger log = LoggerFactory.getLogger(RedisPlusControlScheduler.class);
    private final PlusControl control;
    private final SrcAdUserAccessLogMapper srcAdUserAccessLogMapper;
    private final MeterRegistry registry;
    private final PlusQueueService plusQueueService;

    public RedisPlusControlScheduler(PlusControl control, JedisPool jedisPool, EventPark eventPark, SrcAdUserAccessLogMapper srcAdUserAccessLogMapper, MeterRegistry registry, PlusQueueService plusQueueService) {
        super(null, jedisPool, eventPark);
        this.control = control;
        this.srcAdUserAccessLogMapper = srcAdUserAccessLogMapper;
        this.registry = registry;
        this.plusQueueService = plusQueueService;
    }

    @Override
    protected void doRun() {
        List<FeedbackRequest> conversions = this.getConversionsByDimension();
        if (CollectionUtils.isNotEmpty(conversions)) {
            this.doConversion(conversions);
        }
    }

    private List<FeedbackRequest> getConversionsByDimension() {
        boolean isPlusNotEnough;
        PlusControlConfig config = this.control.getConfig();
        String adGroupId = config.getAdGroupId();
        int current = this.control.getCount();
        int total = config.getLimit();
        if (config.isEveryGroupDimension()) {
            return this.getConversionForEveryGroup();
        }
        int remain = this.getRemain(total, current, config.getY());
        if (remain <= 0) {
            return Lists.newArrayList();
        }
        List<Object> adGroupIds = config.isTotalDimension() ? this.srcAdUserAccessLogMapper.getAllAdGroupId(config.getPositionId(), config.getStartTime(), config.getEndTime()) : Lists.newArrayList((Object[])new String[]{adGroupId});
        if (CollectionUtils.isEmpty((Collection)adGroupIds)) {
            log.info("find adGroupIds is empty. {}", (Object)config.getDimension());
            return Lists.newArrayList();
        }
        List<FeedbackRequest> conversions = this.getConversions(remain, adGroupIds);
        boolean bl = isPlusNotEnough = remain > conversions.size() && config.notInTime(System.currentTimeMillis());
        if (isPlusNotEnough) {
            this.getEventPark().post((EventObject)new PlusNotEnoughEvent(this, config, this.control));
        }
        return conversions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion(List<FeedbackRequest> conversions) {
        if (log.isInfoEnabled()) {
            log.info("Plus control wait conversion num: {} | dimension:{}", (Object)conversions.size(), (Object)this.control.getConfig().getDimension());
        }
        PlusControlConfig config = this.control.getConfig();
        for (FeedbackRequest conversion : conversions) {
            if (!Objects.nonNull(conversion)) continue;
            try {
                conversion.setSmartConvType(SmartConvType.CONV_QUEUE);
                config.getConsumer().accept(conversion);
                this.control.count();
                this.control.countAdGroup(conversion.getAdGroupId());
            }
            catch (Exception e) {
                try {
                    log.error("occur exception | accept: ", (Throwable)e);
                    this.control.count();
                    this.control.countAdGroup(conversion.getAdGroupId());
                }
                catch (Throwable throwable) {
                    this.control.count();
                    this.control.countAdGroup(conversion.getAdGroupId());
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] progress: {}/{}", new Object[]{config.getDimension(), this.control.getCount(), config.getLimit()});
                    }
                    throw throwable;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("[{}] progress: {}/{}", new Object[]{config.getDimension(), this.control.getCount(), config.getLimit()});
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("[{}] progress: {}/{}", new Object[]{config.getDimension(), this.control.getCount(), config.getLimit()});
        }
    }

    private List<FeedbackRequest> getConversions(Integer remain, List<String> adGroupId) {
        PlusControlConfig config = this.control.getConfig();
        PositionRtb positionRtbConfig = config.getPositionRtb();
        String positionId = positionRtbConfig.getPositionId();
        ArrayList result = Lists.newArrayList();
        List<FeedbackRequest> resultFromPlus = this.plusQueueService.getOnConversionQueue(positionId, adGroupId, remain, config.getStartTime(), config.getEndTime());
        log.info("[{}]Plus Queue Need size {} , actual {} adGroupId:{}", new Object[]{config.getDimension(), remain, resultFromPlus.size(), JSON.toJSONString(adGroupId)});
        result.addAll(resultFromPlus);
        remain = remain - resultFromPlus.size();
        if (remain > 0) {
            config.setActionType(ActionType.TICKET_CLICK);
            List<FeedbackRequest> resultFromClick = this.getConversionsFromDB(positionRtbConfig, config, remain, adGroupId);
            log.info("[{}]DB Click Need size {} , actual {}  adGroupId:{}", new Object[]{config.getDimension(), remain, resultFromClick.size(), JSON.toJSONString(adGroupId)});
            result.addAll(resultFromClick);
            remain = remain - resultFromClick.size();
            if (remain > 0) {
                config.setActionType(ActionType.ACTIVITY_ATTEND);
                List<FeedbackRequest> resultFromActivityAttend = this.getConversionsFromDB(positionRtbConfig, config, remain, adGroupId);
                result.addAll(resultFromActivityAttend);
                log.info("[{}] DB Activity Need size {} , actual {}  adGroupId:{}", new Object[]{config.getDimension(), remain, resultFromActivityAttend.size(), JSON.toJSONString(adGroupId)});
            }
        }
        return result;
    }

    private int getRemain(int total, int current, Integer y) {
        int remain = total - current;
        y = Optional.ofNullable(y).orElse(remain);
        return Math.min(remain, y);
    }

    private List<FeedbackRequest> getConversionForEveryGroup() {
        PlusControlConfig config = this.control.getConfig();
        List<String> allAdGroupId = this.srcAdUserAccessLogMapper.getAllAdGroupId(config.getPositionId(), config.getStartTime(), config.getEndTime());
        ArrayList result = Lists.newArrayList();
        int totalCount = 0;
        for (String adGroupId : allAdGroupId) {
            int count = this.getEveryAdGroupIdCount(config.getDimension(), adGroupId);
            totalCount += count;
            int remain = this.getRemain(config.getLimit(), count, config.getY());
            if (remain <= 0) continue;
            List<FeedbackRequest> conversions = this.getConversions(remain, Lists.newArrayList((Object[])new String[]{adGroupId}));
            result.addAll(conversions);
        }
        int totalLimit = config.getLimit() * allAdGroupId.size();
        int count = totalCount + result.size();
        if (config.notInTime(System.currentTimeMillis()) && (totalLimit == 0 || totalLimit > count)) {
            this.getEventPark().post((EventObject)new PlusNotEnoughEvent(this, config, this.control));
        }
        return result;
    }

    private int getEveryAdGroupIdCount(String dimension, String adGroupId) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            int n = NumberUtils.toInt((String)jedis.get(RedisPlusControlScheduler.strAdGroupCount(dimension, adGroupId).generateKey()));
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<FeedbackRequest> getConversionsFromDB(PositionRtb positionRtbConfig, PlusControlConfig config, Integer remain, List<String> adGroupId) {
        ArrayList result = Lists.newArrayList();
        int currentPage = 1;
        Integer pageSize = remain;
        String positionId = config.getPositionId();
        try {
            do {
                QueryParam queryParam = QueryParam.builder().positionId(positionId).startTime(config.getStartTime()).endTime(config.getEndTime()).action(this.getAction(config.getActionType())).adGroupId(adGroupId).build();
                PageHelper.startPage((int)currentPage, (int)pageSize);
                List<SrcAdUserAccessLog> list = this.srcAdUserAccessLogMapper.list(queryParam);
                log.info("DB data [current {} size {}] {}", new Object[]{currentPage, pageSize, JSON.toJSONString(list)});
                if (CollectionUtils.isEmpty(list)) return result;
                for (SrcAdUserAccessLog srcAdUserAccessLog : list) {
                    FeedbackRequest of = this.of(srcAdUserAccessLog, positionRtbConfig, config);
                    if (!Objects.nonNull(of) || this.existClickId(positionId, of.getClickId()) || remain <= result.size() || !adGroupId.contains(of.getAdGroupId())) continue;
                    result.add(of);
                }
                ++currentPage;
                Integer n = pageSize;
                Integer n2 = pageSize = Integer.valueOf(pageSize + 1);
            } while (remain > result.size());
            return result;
        }
        catch (Exception e) {
            log.error("getConversionsFromDB occur error", (Throwable)e);
        }
        return result;
    }

    public FeedbackRequest of(SrcAdUserAccessLog log, PositionRtb positionRtbConfig, PlusControlConfig plusControlConfig) {
        String rtbExt = log.getRtbExt();
        String clickId = null;
        if (StringUtils.isNotBlank((String)rtbExt)) {
            JSONObject rtbExtJsonObject = (JSONObject)JsonHelper.convert((String)rtbExt, JSONObject.class);
            clickId = rtbExtJsonObject.getString("click_id");
        }
        KeyValueMap keyValueMap = new KeyValueMap();
        keyValueMap.put("oaid", log.getOaid());
        keyValueMap.put("oaid_md5", log.getOaidMd5());
        keyValueMap.put("imei", log.getImei());
        keyValueMap.put("imei_md5", log.getImeiMd5());
        keyValueMap.put("idfa", log.getIdfa());
        keyValueMap.put("idfa_md5", log.getIdfaMd5());
        keyValueMap.put("androidid", log.getAnid());
        keyValueMap.put("androidid_md5", log.getAnidMd5());
        keyValueMap.put("bxmid", log.getBxmId());
        keyValueMap.put("ip", log.getIp());
        keyValueMap.put("ua", log.getUas());
        keyValueMap.put("uid", log.getUid());
        keyValueMap.put("time", log.getTimeStamp());
        keyValueMap.put("adid", log.getPreId());
        keyValueMap.put("tagid", positionRtbConfig.getPositionId());
        return FeedbackRequest.builder().config(positionRtbConfig).conversionLevel(1).conversionType("0").smartConvType(SmartConvType.NONE).referrer(log.getRefer()).adGroupId(log.getAdGroupId()).clickId(clickId).eventType(positionRtbConfig.getTargetOneRtb()).keyValueMap(keyValueMap).actionType(plusControlConfig.getActionType()).build();
    }

    private boolean existClickId(String positionId, String clickId) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            Boolean existClickId = jedis.exists(RedisKeyGenerator.strFeedbackClickId((String)positionId, (String)clickId).generateKey());
            if (existClickId.booleanValue()) {
                log.info("Plus Control the clickId has been feedback. {}", (Object)clickId);
            }
            boolean bl = existClickId;
            return bl;
        }
    }

    private Integer getAction(ActionType actionType) {
        return ActionType.TICKET_CLICK.equals((Object)actionType) || ActionType.TICKET_CONVERSION.equals((Object)actionType) ? 2 : 1;
    }

    private static KeyGenerator strAdGroupCount(String dimension, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "plus", "count", dimension, adGroupId});
    }
}

