/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.plus.listener;

import com.bxm.adscounter.integration.adsmanager.AdsmanagerService;
import com.bxm.adscounter.rtb.common.control.plus.PlusControlConfig;
import com.bxm.adscounter.rtb.common.control.plus.event.PlusNotEnoughEvent;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class PlusNotEnoughEventListener
implements EventListener<PlusNotEnoughEvent> {
    private static final Logger log = LoggerFactory.getLogger(PlusNotEnoughEventListener.class);
    private static final int EXPIRE_TIME = Math.toIntExact(Duration.ofDays(7L).getSeconds());
    private final AdsmanagerService adsmanagerService;
    private final Updater updater;

    public PlusNotEnoughEventListener(AdsmanagerService adsmanagerService, Updater updater) {
        this.adsmanagerService = adsmanagerService;
        this.updater = updater;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(PlusNotEnoughEvent event) {
        PlusControlConfig config = event.getConfig();
        Integer controlId = config.getControlId();
        this.updater.update(PlusNotEnoughEventListener.strPlusTips(config.getDimension()), (Object)"\u8865\u91cf\u6765\u6e90\u4e0d\u591f", EXPIRE_TIME);
        if (this.isAllow(controlId)) {
            this.adsmanagerService.updatePlusControlStatus(controlId, Integer.valueOf(0));
            log.info("PlusNotEnoughEventListener consume controlId: {}", (Object)controlId);
        } else {
            log.info("PlusNotEnoughEventListener consume controlId: {} is not allow", (Object)controlId);
        }
    }

    public static KeyGenerator strPlusTips(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "plus", "tips", dimension});
    }

    private boolean isAllow(Integer controlId) {
        JedisPool jedisPool = (JedisPool)this.updater.getClientOriginal();
        try (Jedis jedis = jedisPool.getResource();){
            String key = "plus_not_enough_update_lock_" + controlId;
            Long v = jedis.incr(key);
            if (v == 1L) {
                jedis.expire(key, 300);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

