/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.plustask;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class PlusTaskScheduler {
    private static final Logger log = LoggerFactory.getLogger(PlusTaskScheduler.class);
    private final RtbIntegrationFactory rtbIntegrationFactory;
    private final JedisPool jedisPool;

    public PlusTaskScheduler(RtbIntegrationFactory rtbIntegrationFactory, JedisPool jedisPool) {
        this.rtbIntegrationFactory = rtbIntegrationFactory;
        this.jedisPool = jedisPool;
    }

    @Scheduled(cron="0/30 * * * * ?")
    public void execute() {
        try {
            this.execute0();
        }
        catch (Exception e) {
            log.error("PlusTaskScheduler ", (Throwable)e);
        }
    }

    private void execute0() {
        String data;
        int maxSize = 50;
        long start = System.currentTimeMillis();
        ArrayList dataList = Lists.newArrayList();
        while (!StringUtils.isBlank((String)(data = this.rightPop(PlusTaskScheduler.listPlusQueue().generateKey())))) {
            dataList.add(data);
            if (dataList.size() <= maxSize) continue;
        }
        this.doConversion(dataList);
        if (dataList.size() > 0) {
            log.info("Plus task finished in {} ms. executed {}", (Object)(System.currentTimeMillis() - start), (Object)dataList.size());
        }
    }

    private void doFeedbackQuietly(FeedbackRequest request) {
        PositionRtb config = request.getConfig();
        if (config == null) {
            log.warn("Cannot find positionRtb:{}", (Object)request);
            return;
        }
        Rtb rtb = Rtb.of(config.getSourceType());
        RtbIntegration instance = this.rtbIntegrationFactory.get(rtb);
        try {
            instance.doFeedback(request, 1);
        }
        catch (RtbIntegrationException e) {
            log.error("doFeedbackQuietly: ", (Throwable)e);
        }
    }

    private void doConversion(List<String> conversions) {
        for (String conversion : conversions) {
            FeedbackRequest feedbackRequest = (FeedbackRequest)JsonHelper.convert((String)conversion, FeedbackRequest.class);
            if (!Objects.nonNull(feedbackRequest)) continue;
            try {
                feedbackRequest.setSmartConvType(SmartConvType.CONV_QUEUE);
                this.doFeedbackQuietly(feedbackRequest);
            }
            catch (Exception e) {
                log.error("occur exception: ", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String rightPop(String key) {
        try (Jedis jedis = this.getJedisPool().getResource();){
            String string = jedis.rpop(key);
            return string;
        }
        catch (Exception e) {
            log.error("rpop: {}", (Object)e.getMessage());
            return null;
        }
    }

    static KeyGenerator listPlusQueue() {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "plus_task", "CONV_QUEUE"});
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }
}

