/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.rate;

import com.bxm.adscounter.rtb.common.control.rate.RateControl;
import com.bxm.adscounter.rtb.common.control.rate.RateControlConfig;
import com.bxm.adscounter.rtb.common.control.rate.RedisRateControlScheduler;
import com.bxm.adscounter.rtb.common.mapper.SrcAdUserAccessLogMapper;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.zk.ZkClientHolder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Deprecated
public class RedisRateControlImpl
implements RateControl {
    private static final Logger log = LoggerFactory.getLogger(RedisRateControlImpl.class);
    private static final String SPLIT = "|";
    private final RateControlConfig config;
    private final ScheduledThreadPoolExecutor control = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("control"));
    private final JedisPool jedisPool;
    private final MeterRegistry registry;
    private final EventPark eventPark;
    private final RedisRateControlScheduler scheduler;
    private final LeaderLatch leaderLatch;

    public RedisRateControlImpl(RateControlConfig config, JedisPool jedisPool, MeterRegistry registry, EventPark eventPark, ZkClientHolder zkClientHolder, SrcAdUserAccessLogMapper srcAdUserAccessLogMapper) {
        this.eventPark = eventPark;
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)config.getDimension()), (Object)"dimension cannot be null");
        Preconditions.checkNotNull(config.getConsumer(), (Object)"consumer cannot be null");
        long count = config.getCount();
        Preconditions.checkArgument((count > 0L && count < 10000L ? 1 : 0) != 0, (Object)"count must > 0 and < 10000");
        this.config = config;
        this.jedisPool = jedisPool;
        this.registry = registry;
        this.scheduler = new RedisRateControlScheduler(this, jedisPool, eventPark, srcAdUserAccessLogMapper, registry);
        this.leaderLatch = new LeaderLatch(zkClientHolder.get(), "/adscounter/rtb/control/rate/" + config.getDimension());
    }

    @Override
    public void start() {
        this.leaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                long millis = Duration.between(LocalTime.now(), RedisRateControlImpl.this.config.getEnd()).toMillis();
                long delay = millis / (RedisRateControlImpl.this.config.getCount() - RedisRateControlImpl.this.getCount());
                if (log.isInfoEnabled()) {
                    log.info("[{}] Rate Control Start, Delay time is {} ms", (Object)RedisRateControlImpl.this.config.getDimension(), (Object)delay);
                }
                RedisRateControlImpl.this.control.scheduleWithFixedDelay(RedisRateControlImpl.this.scheduler, 0L, delay, TimeUnit.MILLISECONDS);
            }

            public void notLeader() {
            }
        });
        try {
            this.leaderLatch.start();
        }
        catch (Exception e) {
            log.error("start: ", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.leaderLatch.close();
        }
        catch (Exception e) {
            log.error("shutdown: ", (Throwable)e);
        }
        this.control.shutdownNow();
    }

    @Override
    public void count() {
        this.addCount();
        this.registry.counter("rate.control.count", this.tags()).increment();
    }

    @Override
    public long getCount() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            long l = NumberUtils.toLong((String)jedis.get(RedisRateControlImpl.string(this.config.getDimension()).generateKey()));
            return l;
        }
    }

    @Override
    public void push(String id) {
        this.lpush(id);
        this.registry.counter("rate.control.list", this.tags()).increment();
    }

    @Override
    public void refresh() {
        this.control.remove(this.scheduler);
        this.start();
    }

    @Override
    public void delete() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String dimension = this.config.getDimension();
            String count = RedisRateControlImpl.string(dimension).generateKey();
            String list = RedisRateControlImpl.list(dimension).generateKey();
            jedis.del(new String[]{count, list});
        }
    }

    @Override
    public RateControlConfig getConfig() {
        return this.config;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    private void addCount() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRateControlImpl.string(this.config.getDimension()).generateKey();
            Long rs = jedis.incr(key);
            if (log.isDebugEnabled()) {
                log.debug("{} after decrBy {}", (Object)key, (Object)rs);
            }
        }
    }

    private void lpush(String id) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.lpush(RedisRateControlImpl.list(this.config.getDimension()).generateKey(), new String[]{RedisRateControlImpl.createLargeId(id)});
        }
    }

    private List<Tag> tags() {
        return Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"dim", (String)this.config.getDimension())});
    }

    static String createLargeId(String id) {
        return System.currentTimeMillis() + SPLIT + id;
    }

    static KeyGenerator string(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "rate", "count", dimension});
    }

    static KeyGenerator list(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "rate", "list", dimension});
    }

    static String[] splitLargeId(String id) {
        int i = id.indexOf(SPLIT);
        if (i == -1) {
            throw new IllegalStateException(String.format("%s is illegal value", id));
        }
        String t = id.substring(0, i);
        String d = id.substring(i + 1);
        return new String[]{t, d};
    }

    static LocalDateTime ofTimeMillis(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
    }
}

