/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.rate;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.control.AbstractStandaloneControlScheduler;
import com.bxm.adscounter.rtb.common.control.rate.RateControl;
import com.bxm.adscounter.rtb.common.control.rate.RateControlConfig;
import com.bxm.adscounter.rtb.common.data.QueryParam;
import com.bxm.adscounter.rtb.common.data.SrcAdUserAccessLog;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.adscounter.rtb.common.mapper.SrcAdUserAccessLogMapper;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

@Deprecated
public class RedisRateControlScheduler
extends AbstractStandaloneControlScheduler {
    private static final Logger log = LoggerFactory.getLogger(RedisRateControlScheduler.class);
    private final RateControl control;
    private final SrcAdUserAccessLogMapper srcAdUserAccessLogMapper;
    private final MeterRegistry registry;

    public RedisRateControlScheduler(RateControl control, JedisPool jedisPool, EventPark eventPark, SrcAdUserAccessLogMapper srcAdUserAccessLogMapper, MeterRegistry registry) {
        super(null, jedisPool, eventPark);
        this.control = control;
        this.srcAdUserAccessLogMapper = srcAdUserAccessLogMapper;
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doRun() {
        long total;
        RateControlConfig config = this.control.getConfig();
        PositionRtb positionRtbConfig = config.getPositionRtb();
        long current = this.control.getCount();
        if (current >= (total = config.getCount())) {
            return;
        }
        FeedbackRequest lastOne = this.getOneFeedbackRequestFromDB(config, positionRtbConfig);
        if (!Objects.nonNull(lastOne)) return;
        try {
            config.getConsumer().accept(lastOne);
            this.control.count();
        }
        catch (Exception e) {
            try {
                log.error("occur exception | accept: ", (Throwable)e);
                this.control.count();
            }
            catch (Throwable throwable) {
                this.control.count();
                if (!log.isDebugEnabled()) throw throwable;
                log.debug("[{}] progress: {}/{}", new Object[]{config.getDimension(), this.control.getCount(), total});
                throw throwable;
            }
            if (!log.isDebugEnabled()) return;
            log.debug("[{}] progress: {}/{}", new Object[]{config.getDimension(), this.control.getCount(), total});
            return;
        }
        if (!log.isDebugEnabled()) return;
        log.debug("[{}] progress: {}/{}", new Object[]{config.getDimension(), this.control.getCount(), total});
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeedbackRequest getOneFeedbackRequestFromDB(RateControlConfig config, PositionRtb positionRtbConfig) {
        Timer timer = this.registry.timer("rtb.querydb.cost", new String[0]);
        long start = System.currentTimeMillis();
        try {
            String positionId = config.getPositionId();
            if (StringUtils.isBlank((String)positionId)) {
                FeedbackRequest feedbackRequest = null;
                return feedbackRequest;
            }
            String[] split = positionId.split("-");
            String appKey = split[0];
            String business = split[1];
            QueryParam queryParam = QueryParam.builder().appKey(appKey).business("money-" + business).positionId(positionId).date(DateHelper.format((String)"yyyyMMdd")).action(this.getAction(config.getActionType())).adId(config.getAdId()).build();
            SrcAdUserAccessLog srcAdUserAccessLog = this.srcAdUserAccessLogMapper.getLastOneNew(queryParam);
            if (srcAdUserAccessLog != null) {
                log.info("rate control found log. {}", (Object)srcAdUserAccessLog.toSimpleString());
                FeedbackRequest feedbackRequest = this.of(srcAdUserAccessLog, positionRtbConfig, config);
                return feedbackRequest;
            }
            log.info("Cannot found log from database. {}", (Object)queryParam.toSimpleString());
        }
        catch (Exception e) {
            log.error("getOneFeedbackRequestFromDB occur error", (Throwable)e);
        }
        finally {
            timer.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public FeedbackRequest of(SrcAdUserAccessLog log, PositionRtb positionRtbConfig, RateControlConfig rateControlConfig) {
        String rtbExt = log.getRtbExt();
        String clickId = null;
        if (StringUtils.isNotBlank((String)rtbExt)) {
            JSONObject rtbExtJsonObject = (JSONObject)JsonHelper.convert((String)rtbExt, JSONObject.class);
            clickId = rtbExtJsonObject.getString("click_id");
        }
        KeyValueMap keyValueMap = new KeyValueMap();
        keyValueMap.put("oaid", log.getOaid());
        keyValueMap.put("oaid_md5", log.getOaidMd5());
        keyValueMap.put("imei", log.getImei());
        keyValueMap.put("imei_md5", log.getImeiMd5());
        keyValueMap.put("idfa", log.getIdfa());
        keyValueMap.put("idfa_md5", log.getIdfaMd5());
        keyValueMap.put("androidid", log.getAnid());
        keyValueMap.put("androidid_md5", log.getAnidMd5());
        keyValueMap.put("bxmid", log.getBxmId());
        keyValueMap.put("ip", log.getIp());
        keyValueMap.put("ua", log.getUas());
        keyValueMap.put("uid", log.getUid());
        keyValueMap.put("time", log.getTimeStamp());
        keyValueMap.put("adid", log.getPreId());
        keyValueMap.put("tagid", positionRtbConfig.getPositionId());
        return FeedbackRequest.builder().config(positionRtbConfig).conversionLevel(1).conversionType("0").smartConvType(SmartConvType.NONE).referrer(log.getRefer()).adGroupId(rateControlConfig.getAdGroupId()).clickId(clickId).eventType(positionRtbConfig.getTargetOneRtb()).keyValueMap(keyValueMap).actionType(rateControlConfig.getActionType()).build();
    }

    private Integer getAction(ActionType actionType) {
        return ActionType.TICKET_CLICK.equals((Object)actionType) || ActionType.TICKET_CONVERSION.equals((Object)actionType) ? 2 : 1;
    }
}

