/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.ratio;

import com.bxm.adscounter.rtb.common.control.deduction.ConversionLevel;
import java.time.Duration;
import java.util.Objects;

public class RatioControlConfig {
    private String tagId;
    private String advertiserId;
    private String advertiserName;
    private String adGroupId;
    private String dimension;
    private Long hitConfigId;
    private double ratio = 1.0;
    private double deductionShallowRatio = 1.0;
    private double deductionDeepRatio = 1.0;
    private double cost;
    private int intervalInSec = 30;
    private int dataFetchInMinute = 10;
    private int expireInHours = 24;
    private int dataExpireInMinute = 10;
    private long onsetOfConversion = 20L;
    private boolean enableCvrControl;
    private boolean enableDeductionControl;
    private boolean enableCostControl;
    private String shallowEventType;
    private String deepEventType;
    private ConversionLevel conversionLevel;
    private Integer limitUnconvs;
    private Duration2 duration = Duration2.DAY;
    private PlusStrategy plusStrategy = PlusStrategy.CONV_COUNT;

    public int getExpireInSeconds() {
        return (int)Duration.ofHours(this.expireInHours).getSeconds();
    }

    public int getDataExpireInSeconds() {
        return (int)Duration.ofMinutes(this.dataExpireInMinute).getSeconds();
    }

    public int minForLimit(long current, int remain) {
        if (Objects.isNull(this.limitUnconvs)) {
            return remain;
        }
        int a = this.limitUnconvs - (int)current;
        return Math.min(a, remain);
    }

    public String getTagId() {
        return this.tagId;
    }

    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public String getAdvertiserName() {
        return this.advertiserName;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getDimension() {
        return this.dimension;
    }

    public Long getHitConfigId() {
        return this.hitConfigId;
    }

    public double getRatio() {
        return this.ratio;
    }

    public double getDeductionShallowRatio() {
        return this.deductionShallowRatio;
    }

    public double getDeductionDeepRatio() {
        return this.deductionDeepRatio;
    }

    public double getCost() {
        return this.cost;
    }

    public int getIntervalInSec() {
        return this.intervalInSec;
    }

    public int getDataFetchInMinute() {
        return this.dataFetchInMinute;
    }

    public int getExpireInHours() {
        return this.expireInHours;
    }

    public int getDataExpireInMinute() {
        return this.dataExpireInMinute;
    }

    public long getOnsetOfConversion() {
        return this.onsetOfConversion;
    }

    public boolean isEnableCvrControl() {
        return this.enableCvrControl;
    }

    public boolean isEnableDeductionControl() {
        return this.enableDeductionControl;
    }

    public boolean isEnableCostControl() {
        return this.enableCostControl;
    }

    public String getShallowEventType() {
        return this.shallowEventType;
    }

    public String getDeepEventType() {
        return this.deepEventType;
    }

    public ConversionLevel getConversionLevel() {
        return this.conversionLevel;
    }

    public Integer getLimitUnconvs() {
        return this.limitUnconvs;
    }

    public Duration2 getDuration() {
        return this.duration;
    }

    public PlusStrategy getPlusStrategy() {
        return this.plusStrategy;
    }

    public RatioControlConfig setTagId(String tagId) {
        this.tagId = tagId;
        return this;
    }

    public RatioControlConfig setAdvertiserId(String advertiserId) {
        this.advertiserId = advertiserId;
        return this;
    }

    public RatioControlConfig setAdvertiserName(String advertiserName) {
        this.advertiserName = advertiserName;
        return this;
    }

    public RatioControlConfig setAdGroupId(String adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public RatioControlConfig setDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    public RatioControlConfig setHitConfigId(Long hitConfigId) {
        this.hitConfigId = hitConfigId;
        return this;
    }

    public RatioControlConfig setRatio(double ratio) {
        this.ratio = ratio;
        return this;
    }

    public RatioControlConfig setDeductionShallowRatio(double deductionShallowRatio) {
        this.deductionShallowRatio = deductionShallowRatio;
        return this;
    }

    public RatioControlConfig setDeductionDeepRatio(double deductionDeepRatio) {
        this.deductionDeepRatio = deductionDeepRatio;
        return this;
    }

    public RatioControlConfig setCost(double cost) {
        this.cost = cost;
        return this;
    }

    public RatioControlConfig setIntervalInSec(int intervalInSec) {
        this.intervalInSec = intervalInSec;
        return this;
    }

    public RatioControlConfig setDataFetchInMinute(int dataFetchInMinute) {
        this.dataFetchInMinute = dataFetchInMinute;
        return this;
    }

    public RatioControlConfig setExpireInHours(int expireInHours) {
        this.expireInHours = expireInHours;
        return this;
    }

    public RatioControlConfig setDataExpireInMinute(int dataExpireInMinute) {
        this.dataExpireInMinute = dataExpireInMinute;
        return this;
    }

    public RatioControlConfig setOnsetOfConversion(long onsetOfConversion) {
        this.onsetOfConversion = onsetOfConversion;
        return this;
    }

    public RatioControlConfig setEnableCvrControl(boolean enableCvrControl) {
        this.enableCvrControl = enableCvrControl;
        return this;
    }

    public RatioControlConfig setEnableDeductionControl(boolean enableDeductionControl) {
        this.enableDeductionControl = enableDeductionControl;
        return this;
    }

    public RatioControlConfig setEnableCostControl(boolean enableCostControl) {
        this.enableCostControl = enableCostControl;
        return this;
    }

    public RatioControlConfig setShallowEventType(String shallowEventType) {
        this.shallowEventType = shallowEventType;
        return this;
    }

    public RatioControlConfig setDeepEventType(String deepEventType) {
        this.deepEventType = deepEventType;
        return this;
    }

    public RatioControlConfig setConversionLevel(ConversionLevel conversionLevel) {
        this.conversionLevel = conversionLevel;
        return this;
    }

    public RatioControlConfig setLimitUnconvs(Integer limitUnconvs) {
        this.limitUnconvs = limitUnconvs;
        return this;
    }

    public RatioControlConfig setDuration(Duration2 duration) {
        this.duration = duration;
        return this;
    }

    public RatioControlConfig setPlusStrategy(PlusStrategy plusStrategy) {
        this.plusStrategy = plusStrategy;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RatioControlConfig)) {
            return false;
        }
        RatioControlConfig other = (RatioControlConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getRatio(), other.getRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getDeductionShallowRatio(), other.getDeductionShallowRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getDeductionDeepRatio(), other.getDeductionDeepRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getCost(), other.getCost()) != 0) {
            return false;
        }
        if (this.getIntervalInSec() != other.getIntervalInSec()) {
            return false;
        }
        if (this.getDataFetchInMinute() != other.getDataFetchInMinute()) {
            return false;
        }
        if (this.getExpireInHours() != other.getExpireInHours()) {
            return false;
        }
        if (this.getDataExpireInMinute() != other.getDataExpireInMinute()) {
            return false;
        }
        if (this.getOnsetOfConversion() != other.getOnsetOfConversion()) {
            return false;
        }
        if (this.isEnableCvrControl() != other.isEnableCvrControl()) {
            return false;
        }
        if (this.isEnableDeductionControl() != other.isEnableDeductionControl()) {
            return false;
        }
        if (this.isEnableCostControl() != other.isEnableCostControl()) {
            return false;
        }
        Long this$hitConfigId = this.getHitConfigId();
        Long other$hitConfigId = other.getHitConfigId();
        if (this$hitConfigId == null ? other$hitConfigId != null : !((Object)this$hitConfigId).equals(other$hitConfigId)) {
            return false;
        }
        Integer this$limitUnconvs = this.getLimitUnconvs();
        Integer other$limitUnconvs = other.getLimitUnconvs();
        if (this$limitUnconvs == null ? other$limitUnconvs != null : !((Object)this$limitUnconvs).equals(other$limitUnconvs)) {
            return false;
        }
        String this$tagId = this.getTagId();
        String other$tagId = other.getTagId();
        if (this$tagId == null ? other$tagId != null : !this$tagId.equals(other$tagId)) {
            return false;
        }
        String this$advertiserId = this.getAdvertiserId();
        String other$advertiserId = other.getAdvertiserId();
        if (this$advertiserId == null ? other$advertiserId != null : !this$advertiserId.equals(other$advertiserId)) {
            return false;
        }
        String this$advertiserName = this.getAdvertiserName();
        String other$advertiserName = other.getAdvertiserName();
        if (this$advertiserName == null ? other$advertiserName != null : !this$advertiserName.equals(other$advertiserName)) {
            return false;
        }
        String this$adGroupId = this.getAdGroupId();
        String other$adGroupId = other.getAdGroupId();
        if (this$adGroupId == null ? other$adGroupId != null : !this$adGroupId.equals(other$adGroupId)) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$shallowEventType = this.getShallowEventType();
        String other$shallowEventType = other.getShallowEventType();
        if (this$shallowEventType == null ? other$shallowEventType != null : !this$shallowEventType.equals(other$shallowEventType)) {
            return false;
        }
        String this$deepEventType = this.getDeepEventType();
        String other$deepEventType = other.getDeepEventType();
        if (this$deepEventType == null ? other$deepEventType != null : !this$deepEventType.equals(other$deepEventType)) {
            return false;
        }
        ConversionLevel this$conversionLevel = this.getConversionLevel();
        ConversionLevel other$conversionLevel = other.getConversionLevel();
        if (this$conversionLevel == null ? other$conversionLevel != null : !((Object)((Object)this$conversionLevel)).equals((Object)other$conversionLevel)) {
            return false;
        }
        Duration2 this$duration = this.getDuration();
        Duration2 other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)((Object)this$duration)).equals((Object)other$duration)) {
            return false;
        }
        PlusStrategy this$plusStrategy = this.getPlusStrategy();
        PlusStrategy other$plusStrategy = other.getPlusStrategy();
        return !(this$plusStrategy == null ? other$plusStrategy != null : !((Object)((Object)this$plusStrategy)).equals((Object)other$plusStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RatioControlConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ratio = Double.doubleToLongBits(this.getRatio());
        result = result * 59 + (int)($ratio >>> 32 ^ $ratio);
        long $deductionShallowRatio = Double.doubleToLongBits(this.getDeductionShallowRatio());
        result = result * 59 + (int)($deductionShallowRatio >>> 32 ^ $deductionShallowRatio);
        long $deductionDeepRatio = Double.doubleToLongBits(this.getDeductionDeepRatio());
        result = result * 59 + (int)($deductionDeepRatio >>> 32 ^ $deductionDeepRatio);
        long $cost = Double.doubleToLongBits(this.getCost());
        result = result * 59 + (int)($cost >>> 32 ^ $cost);
        result = result * 59 + this.getIntervalInSec();
        result = result * 59 + this.getDataFetchInMinute();
        result = result * 59 + this.getExpireInHours();
        result = result * 59 + this.getDataExpireInMinute();
        long $onsetOfConversion = this.getOnsetOfConversion();
        result = result * 59 + (int)($onsetOfConversion >>> 32 ^ $onsetOfConversion);
        result = result * 59 + (this.isEnableCvrControl() ? 79 : 97);
        result = result * 59 + (this.isEnableDeductionControl() ? 79 : 97);
        result = result * 59 + (this.isEnableCostControl() ? 79 : 97);
        Long $hitConfigId = this.getHitConfigId();
        result = result * 59 + ($hitConfigId == null ? 43 : ((Object)$hitConfigId).hashCode());
        Integer $limitUnconvs = this.getLimitUnconvs();
        result = result * 59 + ($limitUnconvs == null ? 43 : ((Object)$limitUnconvs).hashCode());
        String $tagId = this.getTagId();
        result = result * 59 + ($tagId == null ? 43 : $tagId.hashCode());
        String $advertiserId = this.getAdvertiserId();
        result = result * 59 + ($advertiserId == null ? 43 : $advertiserId.hashCode());
        String $advertiserName = this.getAdvertiserName();
        result = result * 59 + ($advertiserName == null ? 43 : $advertiserName.hashCode());
        String $adGroupId = this.getAdGroupId();
        result = result * 59 + ($adGroupId == null ? 43 : $adGroupId.hashCode());
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $shallowEventType = this.getShallowEventType();
        result = result * 59 + ($shallowEventType == null ? 43 : $shallowEventType.hashCode());
        String $deepEventType = this.getDeepEventType();
        result = result * 59 + ($deepEventType == null ? 43 : $deepEventType.hashCode());
        ConversionLevel $conversionLevel = this.getConversionLevel();
        result = result * 59 + ($conversionLevel == null ? 43 : ((Object)((Object)$conversionLevel)).hashCode());
        Duration2 $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)((Object)$duration)).hashCode());
        PlusStrategy $plusStrategy = this.getPlusStrategy();
        result = result * 59 + ($plusStrategy == null ? 43 : ((Object)((Object)$plusStrategy)).hashCode());
        return result;
    }

    public String toString() {
        return "RatioControlConfig(tagId=" + this.getTagId() + ", advertiserId=" + this.getAdvertiserId() + ", advertiserName=" + this.getAdvertiserName() + ", adGroupId=" + this.getAdGroupId() + ", dimension=" + this.getDimension() + ", hitConfigId=" + this.getHitConfigId() + ", ratio=" + this.getRatio() + ", deductionShallowRatio=" + this.getDeductionShallowRatio() + ", deductionDeepRatio=" + this.getDeductionDeepRatio() + ", cost=" + this.getCost() + ", intervalInSec=" + this.getIntervalInSec() + ", dataFetchInMinute=" + this.getDataFetchInMinute() + ", expireInHours=" + this.getExpireInHours() + ", dataExpireInMinute=" + this.getDataExpireInMinute() + ", onsetOfConversion=" + this.getOnsetOfConversion() + ", enableCvrControl=" + this.isEnableCvrControl() + ", enableDeductionControl=" + this.isEnableDeductionControl() + ", enableCostControl=" + this.isEnableCostControl() + ", shallowEventType=" + this.getShallowEventType() + ", deepEventType=" + this.getDeepEventType() + ", conversionLevel=" + (Object)((Object)this.getConversionLevel()) + ", limitUnconvs=" + this.getLimitUnconvs() + ", duration=" + (Object)((Object)this.getDuration()) + ", plusStrategy=" + (Object)((Object)this.getPlusStrategy()) + ")";
    }

    public static enum PlusStrategy {
        CONV_COUNT(1),
        CVR(2);

        private final int value;

        private PlusStrategy(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PlusStrategy of(Integer v) {
            if (Objects.isNull(v)) {
                return null;
            }
            for (PlusStrategy d : PlusStrategy.values()) {
                if (d.getValue() != v.intValue()) continue;
                return d;
            }
            return null;
        }
    }

    public static enum Duration2 {
        DAY(1),
        HOUR(2);

        private final int value;

        private Duration2(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Duration2 of(Integer v) {
            if (Objects.isNull(v)) {
                return null;
            }
            for (Duration2 d : Duration2.values()) {
                if (d.getValue() != v.intValue()) continue;
                return d;
            }
            return null;
        }
    }
}

