/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.ratio;

import com.alibaba.fastjson.JSONArray;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.control.cpa.CpaControl;
import com.bxm.adscounter.rtb.common.control.plus.PlusQueueService;
import com.bxm.adscounter.rtb.common.control.ratio.ClickLog;
import com.bxm.adscounter.rtb.common.control.ratio.DataFetchingScheduler;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlBus;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.RedisRatioControlScheduler;
import com.bxm.adscounter.rtb.common.control.ratio.Stat;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioDeductionEvent;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioFeedbackEvent;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioFeedbackExceptionEvent;
import com.bxm.adscounter.rtb.common.control.ratio.listener.ListenerKey;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.event.RtbDeductionEvent;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisRatioControlImpl
implements RatioControl {
    private static final Logger log = LoggerFactory.getLogger(RedisRatioControlImpl.class);
    static final int ONE_DAY_SEC = TypeHelper.castToInt((Object)Duration.ofDays(1L).getSeconds());
    private static final String SPLIT = "|";
    private RatioControlBus bus;
    private RatioControlConfig config;
    private final ScheduledThreadPoolExecutor computeScheduler;
    private final ScheduledThreadPoolExecutor dataFetchScheduler;
    private final JedisPool jedisPool;
    private final MeterRegistry registry;
    private final EventPark eventPark;
    private final RedisRatioControlScheduler scheduler;
    private final DataFetchingScheduler dataFetchingScheduler;
    private final LeaderLatch leaderLatch;
    private final CpaControl cpaControl;
    private final PlusQueueService plusQueueService;
    private final AtomicBoolean leader = new AtomicBoolean(false);
    private final AtomicBoolean computerIsRunning = new AtomicBoolean(false);
    private final AtomicBoolean dataFetchIsRunning = new AtomicBoolean(false);
    private final String hostAddress;

    public RedisRatioControlImpl(RatioControlBus bus, RatioControlConfig config, CpaControl cpaControl, PlusQueueService plusQueueService) {
        this.plusQueueService = plusQueueService;
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)bus.getInstance());
        Preconditions.checkNotNull((Object)bus.getJedisPool());
        Preconditions.checkNotNull((Object)bus.getRegistry());
        Preconditions.checkNotNull((Object)bus.getEventPark());
        Preconditions.checkNotNull((Object)bus.getZkClientHolder());
        Preconditions.checkNotNull((Object)bus.getFactory());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)config.getDimension()), (Object)"dimension cannot be null");
        Preconditions.checkArgument((config.getExpireInHours() > 0 ? 1 : 0) != 0, (Object)"expire hours must > 0");
        this.bus = bus;
        this.eventPark = bus.getEventPark();
        this.registry = bus.getRegistry();
        this.jedisPool = bus.getJedisPool();
        this.config = config;
        this.scheduler = new RedisRatioControlScheduler(this);
        this.dataFetchingScheduler = new DataFetchingScheduler(this);
        this.leaderLatch = new LeaderLatch(bus.getZkClientHolder().get(), "/adscounter/rtb/control/ratio/" + config.getDimension());
        this.hostAddress = RedisRatioControlImpl.getHost();
        this.computeScheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("cs"));
        this.dataFetchScheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("dfs"));
        this.cpaControl = cpaControl;
    }

    @Override
    public void start() {
        this.leaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                RedisRatioControlImpl.this.leader.compareAndSet(false, true);
                RedisRatioControlImpl.this.startScheduler(true);
            }

            public void notLeader() {
                RedisRatioControlImpl.this.leader.compareAndSet(true, false);
            }
        });
        try {
            this.leaderLatch.start();
        }
        catch (Exception e) {
            log.error("start: ", (Throwable)e);
        }
    }

    private void startScheduler(boolean showLeaderLog) {
        if (!this.leader.get()) {
            if (showLeaderLog && log.isInfoEnabled()) {
                log.info("[{}] {} is not leader.", (Object)this.config.getDimension(), (Object)this.hostAddress);
            }
        } else {
            if (showLeaderLog && log.isInfoEnabled()) {
                log.info("[{}] {} is leader!", (Object)this.config.getDimension(), (Object)this.hostAddress);
            }
            if (this.isAllowScheduleComputer() && this.computerIsRunning.compareAndSet(false, true)) {
                int intervalInSec = this.config.getIntervalInSec();
                if (log.isInfoEnabled()) {
                    log.info("[{}] {} Computer Start, Delay time is {} sec", new Object[]{this.config.getDimension(), this.hostAddress, intervalInSec});
                }
                this.computeScheduler.scheduleWithFixedDelay(this.scheduler, 0L, intervalInSec, TimeUnit.SECONDS);
            }
            if (this.isAllowScheduleDataFetcher() && this.dataFetchIsRunning.compareAndSet(false, true)) {
                int dataFetchInMinute = this.config.getDataFetchInMinute();
                if (log.isInfoEnabled()) {
                    log.info("[{}] {} DataFetcher Start, Delay time is {} min", new Object[]{this.config.getDimension(), this.hostAddress, dataFetchInMinute});
                }
                this.dataFetchScheduler.scheduleWithFixedDelay(this.dataFetchingScheduler, 0L, dataFetchInMinute, TimeUnit.MINUTES);
            }
        }
    }

    private boolean isAllowScheduleComputer() {
        return this.config.isEnableCvrControl() || this.config.isEnableCostControl();
    }

    private boolean isAllowScheduleDataFetcher() {
        return this.config.isEnableCostControl();
    }

    @Override
    public void shutdown() {
        try {
            this.leaderLatch.close();
        }
        catch (Exception e) {
            log.error("shutdown: ", (Throwable)e);
        }
        this.computeScheduler.shutdownNow();
        this.dataFetchScheduler.shutdownNow();
    }

    @Override
    public void onClick(String clickId, String app) {
        this.incrClickTotalCount(clickId);
        this.incrClickTotalCount(clickId, app);
        this.registry.counter("ratio.control.denominator", this.tags()).increment();
    }

    @Override
    public void onAdClick(ClickLog clickLog) {
        this.addClickQueue(clickLog);
        this.addTicketClick2SortApp(clickLog.getApp());
        this.registry.counter("ratio.control.adclick", this.tags()).increment();
    }

    @Override
    public void onConversion() {
        this.incrConversionTotalCount();
        this.registry.counter("ratio.control.numerator", this.tags()).increment();
    }

    @Override
    public void pushConversion(FeedbackRequest request, String app) {
        String data = JsonHelper.convert((Object)request);
        this.incrReceiverTotalCount();
        double currentConvCount = this.addConversion2SortApp(app);
        this.setCvr2SortApp(app, currentConvCount / (double)this.getClickTotalCount(app));
        if (this.config.isEnableDeductionControl()) {
            if (this.isDeduction(request)) {
                this.addConversion(this.config.getDimension(), data);
                this.addAppConversion(this.config.getDimension(), app, data);
                this.cpaControl.pushConversion(request);
                this.plusQueueService.pushConversion(request);
            } else {
                String adGroupId = request.getAdGroupId();
                String appid = request.getAppid();
                try {
                    FeedbackResponse response = this.bus.getInstance().doFeedback(request, 1);
                    if (!response.isSuccess()) {
                        throw new RtbIntegrationException(null);
                    }
                    this.onConversion();
                    this.eventPark.post((EventObject)new RatioFeedbackEvent(this, this, adGroupId, appid, null));
                }
                catch (RtbIntegrationException e) {
                    this.eventPark.post((EventObject)new RatioFeedbackExceptionEvent(this, this, adGroupId, appid, null));
                }
                catch (Exception e) {
                    log.error("occur exception | accept: ", (Throwable)e);
                }
            }
        } else {
            this.addConversion(this.config.getDimension(), data);
            this.addAppConversion(this.config.getDimension(), app, data);
        }
        this.registry.counter("ratio.control.numerator.list", this.tags()).increment();
    }

    @Override
    public void onX() {
        this.incrX(1L);
    }

    @Override
    public void cleanX() {
        this.delX();
    }

    private boolean isDeduction(FeedbackRequest request) {
        boolean feedbackIfNecessary;
        double ratio;
        int level = request.getConversionLevel();
        double stepValue = 1.0;
        double zeroRatio = 0.0;
        double d = ratio = request.isDeepConversion() ? this.config.getDeductionDeepRatio() : this.config.getDeductionShallowRatio();
        if (!this.isInitializedCountRate(level) && ratio > zeroRatio) {
            this.incrCountRateBy(level, stepValue);
        }
        this.registry.counter("deduction.control", this.tags2(level)).increment();
        double after = this.incrCountRateBy(level, ratio);
        boolean bl = feedbackIfNecessary = after >= stepValue;
        if (feedbackIfNecessary) {
            this.incrCountRateBy(level, -stepValue);
            this.registry.counter("deduction.control.accept", this.tags2(level)).increment();
            return false;
        }
        Rtb rtb = this.bus.getInstance().rtb();
        this.eventPark.post((EventObject)new RtbDeductionEvent(this, rtb, request, null));
        this.eventPark.post((EventObject)new RatioDeductionEvent(this, this, request.getAdGroupId(), request.getAppid()));
        this.registry.counter("deduction.control.reject", this.tags2(level)).increment();
        return true;
    }

    @Override
    public void delete() {
    }

    @Override
    public Stat getStat() {
        double v;
        long conversions = 0L;
        long clicks = 0L;
        long x = 0L;
        long plus = 0L;
        long receivers = 0L;
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            conversions = NumberUtils.toLong((String)jedis.get(RedisRatioControlImpl.stringConversionTotal(this.config.getDimension()).generateKey()), (long)0L);
            clicks = NumberUtils.toLong((String)jedis.get(RedisRatioControlImpl.stringClickTotal(this.config.getDimension()).generateKey()), (long)0L);
            x = NumberUtils.toLong((String)jedis.get(RedisRatioControlImpl.stringX(this.bus.getInstance().rtb(), this.config.getAdGroupId()).generateKey()), (long)0L);
            plus = NumberUtils.toLong((String)jedis.hget(ListenerKey.hashData(this.config.getDimension()).generateKey(), "plus"), (long)0L);
            receivers = NumberUtils.toLong((String)jedis.get(RedisRatioControlImpl.stringReceiverTotal(this.config.getDimension()).generateKey()), (long)0L);
        }
        double d = v = clicks == 0L ? 0.0 : BigDecimal.valueOf(conversions).divide(BigDecimal.valueOf(clicks), 3, RoundingMode.HALF_UP).doubleValue();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Current ratio: {}/{} = {}", new Object[]{this.config.getDimension(), conversions, clicks, v});
        }
        return new Stat().setConversions(conversions).setClicks(clicks).setCvr(v).setX(x).setPlus(plus).setReceivers(receivers);
    }

    @Override
    public Set<String> getTopN(int start, int stop) {
        if (this.config.getPlusStrategy() == RatioControlConfig.PlusStrategy.CVR) {
            return this.orderByCvr(start, stop);
        }
        return this.orderByConversion(start, stop);
    }

    @Override
    public void pushData(List<AdGroupData> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        this.pushAdGroupData(dataList);
    }

    @Override
    public List<AdGroupData> getDataList() {
        return this.getAdGroupData();
    }

    @Override
    public RatioControlBus getBus() {
        return this.bus;
    }

    @Override
    public void refreshConfig(RatioControlConfig config) {
        this.config = config;
        this.startScheduler(false);
    }

    @Override
    public RatioControlConfig getConfig() {
        return this.config;
    }

    private List<Tag> tags() {
        return Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"dim", (String)this.config.getDimension())});
    }

    private List<Tag> tags2(int level) {
        return Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"dim", (String)(this.config.getDimension() + "_" + level))});
    }

    private JedisPool getJedisPool() {
        return this.jedisPool;
    }

    private boolean isInitializedCountRate(int level) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringRateCountInitialized(this.config.getDimension(), level).generateKey();
            Long rs = jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
            boolean bl = Optional.ofNullable(rs).orElse(1L) > 1L;
            return bl;
        }
    }

    private double incrCountRateBy(int level, double incrementValue) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringCountRate(this.config.getDimension(), level).generateKey();
            double rs = jedis.incrByFloat(key, incrementValue);
            jedis.expire(key, ONE_DAY_SEC);
            double d = rs;
            return d;
        }
    }

    private void incrClickTotalCount(String clickId) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringClickTotal(this.config.getDimension()).generateKey();
            jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
        }
    }

    private void incrClickTotalCount(String clickId, String app) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringClickTotal(this.config.getDimension(), app).generateKey();
            jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
        }
    }

    private long getClickTotalCount(String app) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringClickTotal(this.config.getDimension(), app).generateKey();
            long l = NumberUtils.toLong((String)jedis.get(key), (long)0L);
            return l;
        }
    }

    private void addClickQueue(ClickLog clickLog) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.listClickQueue(this.config.getDuration(), this.config.getDimension(), clickLog.getApp()).generateKey();
            jedis.lpush(key, new String[]{JsonHelper.convert((Object)clickLog)});
            jedis.expire(key, RedisRatioControlImpl.getRemainInSeconds());
        }
    }

    private void incrReceiverTotalCount() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringReceiverTotal(this.config.getDimension()).generateKey();
            jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
        }
    }

    private void incrConversionTotalCount() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringConversionTotal(this.config.getDimension()).generateKey();
            jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
        }
    }

    private double addConversion2SortApp(String app) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = RedisRatioControlImpl.sortsetConversion(this.config.getDuration(), this.config.getDimension()).generateKey();
            Double rs = jedis.zincrby(key, 1.0, app);
            jedis.expire(key, ONE_DAY_SEC);
            double d = rs;
            return d;
        }
    }

    private void addTicketClick2SortApp(String app) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = RedisRatioControlImpl.sortsetTicketClick(this.config.getDuration(), this.config.getDimension()).generateKey();
            jedis.zincrby(key, 1.0, app);
            jedis.expire(key, ONE_DAY_SEC);
        }
    }

    private void setCvr2SortApp(String app, double cvr) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = RedisRatioControlImpl.sortsetCvr(this.config.getDuration(), this.config.getDimension()).generateKey();
            jedis.zadd(key, cvr, app);
            jedis.expire(key, ONE_DAY_SEC);
        }
    }

    private void addConversion(String dimension, String data) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.listConversionQueue(this.config.getDuration(), dimension).generateKey();
            jedis.lpush(key, new String[]{RedisRatioControlImpl.createLargeId(data)});
            jedis.expire(key, this.config.getExpireInSeconds());
        }
    }

    private void addAppConversion(String dimension, String app, String data) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.listAppConversionQueue(this.config.getDuration(), dimension, app).generateKey();
            jedis.lpush(key, new String[]{RedisRatioControlImpl.createLargeId(data)});
            jedis.expire(key, this.config.getExpireInSeconds());
        }
    }

    private Set<String> orderByConversion(int start, int stop) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = RedisRatioControlImpl.sortsetConversion(this.config.getDuration(), this.config.getDimension()).generateKey();
            Set set = jedis.zrevrange(key, (long)start, (long)stop);
            return set;
        }
    }

    private Set<String> orderByTicketClick(int start, int stop) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = RedisRatioControlImpl.sortsetTicketClick(this.config.getDuration(), this.config.getDimension()).generateKey();
            Set set = jedis.zrevrange(key, (long)start, (long)stop);
            return set;
        }
    }

    private Set<String> orderByCvr(int start, int stop) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = RedisRatioControlImpl.sortsetCvr(this.config.getDuration(), this.config.getDimension()).generateKey();
            Set set = jedis.zrevrange(key, (long)start, (long)stop);
            return set;
        }
    }

    private void pushAdGroupData(List<AdGroupData> dataList) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringRtbData(this.bus.getInstance().rtb(), this.config.getAdGroupId()).generateKey();
            jedis.set(key, JsonHelper.convert(dataList));
            jedis.expire(key, this.config.getDataExpireInSeconds());
        }
    }

    private List<AdGroupData> getAdGroupData() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringRtbData(this.bus.getInstance().rtb(), this.config.getAdGroupId()).generateKey();
            String rs = jedis.get(key);
            List list = JSONArray.parseArray((String)rs, AdGroupData.class);
            return list;
        }
    }

    private void incrX(long incrementValue) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringX(this.bus.getInstance().rtb(), this.config.getAdGroupId()).generateKey();
            Long rs = jedis.incrBy(key, incrementValue);
            jedis.expire(key, this.config.getDataExpireInSeconds());
            if (log.isDebugEnabled()) {
                log.debug("X - {} - {}", (Object)key, (Object)rs);
            }
        }
    }

    private void delX() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisRatioControlImpl.stringX(this.bus.getInstance().rtb(), this.config.getAdGroupId()).generateKey();
            jedis.del(key);
            if (log.isDebugEnabled()) {
                log.debug("Delete X - {}", (Object)key);
            }
        }
    }

    private static String createLargeId(String data) {
        return System.currentTimeMillis() + SPLIT + data;
    }

    private static KeyGenerator stringRateCountInitialized(String dimension, int level) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "DED_INIT", RedisRatioControlImpl.getDate(), dimension, level});
    }

    private static KeyGenerator stringCountRate(String dimension, int level) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "DED_RATE", RedisRatioControlImpl.getDate(), dimension, level});
    }

    private static KeyGenerator stringReceiverTotal(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "RECEIVER", RedisRatioControlImpl.getDate(), dimension});
    }

    private static KeyGenerator stringClickTotal(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "CLICK", RedisRatioControlImpl.getDate(), dimension});
    }

    private static KeyGenerator stringClickTotal(String dimension, String app) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "APP_CLICK", RedisRatioControlImpl.getDate(), dimension, app});
    }

    private static KeyGenerator stringConversionTotal(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "CONVERSION", RedisRatioControlImpl.getDate(), dimension});
    }

    private static KeyGenerator sortsetConversion(RatioControlConfig.Duration2 duration2, String dimension) {
        String split = duration2 == RatioControlConfig.Duration2.HOUR ? RedisRatioControlImpl.getDateHour() : RedisRatioControlImpl.getDate();
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "APP_CONV", split, dimension});
    }

    private static KeyGenerator sortsetTicketClick(RatioControlConfig.Duration2 duration2, String dimension) {
        String split = duration2 == RatioControlConfig.Duration2.HOUR ? RedisRatioControlImpl.getDateHour() : RedisRatioControlImpl.getDate();
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "APP_TICKET_CLICK", split, dimension});
    }

    private static KeyGenerator sortsetCvr(RatioControlConfig.Duration2 duration2, String dimension) {
        String split = duration2 == RatioControlConfig.Duration2.HOUR ? RedisRatioControlImpl.getDateHour() : RedisRatioControlImpl.getDate();
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "APP_CONV_CVR", split, dimension});
    }

    static KeyGenerator listClickQueue(RatioControlConfig.Duration2 duration2, String dimension, String app) {
        String split = duration2 == RatioControlConfig.Duration2.HOUR ? RedisRatioControlImpl.getDateHour() : RedisRatioControlImpl.getDate();
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "CLICK_QUEUE", split, dimension, app});
    }

    static KeyGenerator listConversionQueue(RatioControlConfig.Duration2 duration2, String dimension) {
        String split = duration2 == RatioControlConfig.Duration2.HOUR ? RedisRatioControlImpl.getDateHour() : RedisRatioControlImpl.getDate();
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "CONV_QUEUE", split, dimension});
    }

    static KeyGenerator listAppConversionQueue(RatioControlConfig.Duration2 duration2, String dimension, String app) {
        String split = duration2 == RatioControlConfig.Duration2.HOUR ? RedisRatioControlImpl.getDateHour() : RedisRatioControlImpl.getDate();
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "APP_CONV_QUEUE", split, dimension, app});
    }

    static KeyGenerator stringRtbData(Rtb rtb, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "RTB_DATA", rtb.getType(), adGroupId});
    }

    static KeyGenerator stringX(Rtb rtb, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "X", rtb.getType(), adGroupId});
    }

    static String[] splitLargeId(String id) {
        int i = id.indexOf(SPLIT);
        if (i == -1) {
            throw new IllegalStateException(String.format("%s is illegal value", id));
        }
        String t = id.substring(0, i);
        String d = id.substring(i + 1);
        return new String[]{t, d};
    }

    static KeyGenerator listTicketConversionQueue(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "TICKET_CONV_QUEUE", RedisRatioControlImpl.getDate(), dimension});
    }

    static LocalDateTime ofTimeMillis(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
    }

    private static String getDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    private static String getDateHour() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHH"));
    }

    private static int getRemainInSeconds() {
        return (int)DateHelper.getRemainSecondsOfToday() + RandomUtils.nextInt((int)600);
    }

    private static String getHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    public EventPark getEventPark() {
        return this.eventPark;
    }
}

