/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.ratio;

import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.control.AbstractStandaloneControlScheduler;
import com.bxm.adscounter.rtb.common.control.ControlUtils;
import com.bxm.adscounter.rtb.common.control.LocalDateTimeUtils;
import com.bxm.adscounter.rtb.common.control.deduction.ConversionLevel;
import com.bxm.adscounter.rtb.common.control.ratio.ClickLog;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlBus;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.RedisRatioControlImpl;
import com.bxm.adscounter.rtb.common.control.ratio.Stat;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioFeedbackEvent;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioFeedbackExceptionEvent;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioPlusEvent;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisRatioControlScheduler
extends AbstractStandaloneControlScheduler {
    private static final Logger log = LoggerFactory.getLogger(RedisRatioControlScheduler.class);
    private final RatioControl control;

    RedisRatioControlScheduler(RatioControl control) {
        super(control.getBus().getInstance(), control.getBus().getJedisPool(), control.getBus().getEventPark());
        this.control = control;
    }

    @Override
    protected void doRun() {
        RatioControlConfig config = this.control.getConfig();
        String dimension = this.getDimension();
        boolean enableDeductionControl = config.isEnableDeductionControl();
        boolean enableCvrControl = config.isEnableCvrControl();
        boolean enableCostControl = config.isEnableCostControl();
        if (!enableCvrControl && !enableCostControl) {
            return;
        }
        ArrayList result = Lists.newArrayList();
        RtbIntegration instance = this.getInstance();
        if (enableCostControl) {
            List<AdGroupData> dataList = this.control.getDataList();
            if (CollectionUtils.isEmpty(dataList)) {
                enableCostControl = false;
            } else {
                Stat stat = this.control.getStat();
                int count = this.computeCostCount(config, dataList, stat.getX());
                result.addAll(this.getOnConversionAndClickQueue(stat, count));
            }
        }
        if (!enableCostControl && enableCvrControl) {
            Stat stat = this.control.getStat();
            long clickTotal = stat.getClicks();
            long conversions = stat.getConversions();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Stat: {}", (Object)dimension, (Object)stat);
            }
            if (conversions < config.getOnsetOfConversion()) {
                List<Conversion> queue = this.getOnAppConversionQueueOrderBy(Integer.MAX_VALUE);
                if (CollectionUtils.isNotEmpty(queue)) {
                    result.addAll(queue);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Starting progress {}/{}", new Object[]{dimension, conversions, config.getOnsetOfConversion()});
                    }
                }
            } else {
                int count = this.computeCvrCount(config, clickTotal, conversions);
                if (!enableDeductionControl) {
                    List<Conversion> conversionQueue = this.getOnAppConversionQueueOrderBy(Integer.MAX_VALUE);
                    result.addAll(conversionQueue);
                    count -= conversionQueue.size();
                }
                result.addAll(this.getOnConversionAndClickQueue(stat, count));
            }
        }
        if (!(enableCvrControl || enableCostControl || enableDeductionControl)) {
            List<Conversion> conversions = this.getOnAppConversionQueueOrderBy(Integer.MAX_VALUE);
            result.addAll(conversions);
        }
        this.doConversion(result, instance, enableCostControl);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Finished count: {}", (Object)dimension, (Object)result.size());
        }
    }

    private RatioControlConfig getConfig() {
        return this.control.getConfig();
    }

    private String getDimension() {
        return this.getConfig().getDimension();
    }

    private int computeCostCount(RatioControlConfig config, List<AdGroupData> dataList, long x) {
        AdGroupData data = dataList.get(0);
        double cfgCost = config.getCost();
        BigDecimal charge = Optional.ofNullable(data.getCharge()).orElse(BigDecimal.ZERO);
        long rtbCount = Optional.ofNullable(data.getConvNumByImpression()).orElse(0L);
        if (config.getDuration() == RatioControlConfig.Duration2.DAY) {
            if (config.getConversionLevel() == ConversionLevel.SHALLOW) {
                rtbCount = Optional.ofNullable(data.getShallowConvCount()).orElse(0L);
            } else if (config.getConversionLevel() == ConversionLevel.DEEP) {
                rtbCount = Optional.ofNullable(data.getDeepConvCount()).orElse(0L);
            }
        }
        BigDecimal g = charge.divide(BigDecimal.valueOf(cfgCost), 2, RoundingMode.HALF_UP).subtract(BigDecimal.valueOf(rtbCount)).subtract(BigDecimal.valueOf(x));
        int count = g.intValue();
        if (log.isInfoEnabled()) {
            log.info("COST: (duration={},level={}): [{}] {}={}/{}-{}-{}", new Object[]{this.getDimension(), config.getDuration(), config.getConversionLevel(), g, charge, cfgCost, rtbCount, x});
        }
        return count;
    }

    private int computeCvrCount(RatioControlConfig config, long clickTotal, long conversions) {
        double exceptRatio = config.getRatio();
        BigDecimal necessaryTotal = BigDecimal.valueOf(clickTotal).multiply(BigDecimal.valueOf(exceptRatio));
        int count = necessaryTotal.subtract(BigDecimal.valueOf(conversions)).intValue();
        if (log.isDebugEnabled()) {
            log.debug("CVR: [{}] {}={}*({}%)-{}", new Object[]{this.getDimension(), count, clickTotal, exceptRatio * 100.0, conversions});
        }
        return count;
    }

    private void doConversion(List<Conversion> result, RtbIntegration instance, boolean enableCostControl) {
        EventPark eventPark = this.getEventPark();
        for (Conversion conversion : result) {
            FeedbackRequest feedbackRequest = conversion.getRequest();
            if (Objects.isNull(feedbackRequest)) continue;
            String adGroupId = feedbackRequest.getAdGroupId();
            String appid = feedbackRequest.getAppid();
            ClickLog clickLog = conversion.getClickLog();
            try {
                FeedbackResponse response = instance.doFeedback(feedbackRequest, 1);
                if (response.isSuccess()) {
                    this.control.onConversion();
                    if (enableCostControl) {
                        this.control.onX();
                    }
                    eventPark.post((EventObject)new RatioFeedbackEvent(this, this.control, adGroupId, appid, clickLog));
                    eventPark.post((EventObject)new RatioPlusEvent(this, this.control, adGroupId, appid, clickLog));
                    continue;
                }
                throw new RtbIntegrationException(null);
            }
            catch (RtbIntegrationException ignore) {
                eventPark.post((EventObject)new RatioFeedbackExceptionEvent(this, this.control, adGroupId, appid, clickLog));
            }
            catch (Exception e) {
                log.error("occur exception | accept: ", (Throwable)e);
            }
        }
    }

    private List<Conversion> convert(List<String> json) {
        if (CollectionUtils.isEmpty(json)) {
            return Lists.newArrayList();
        }
        return json.stream().map(this::convert).collect(Collectors.toList());
    }

    private Conversion convert(String json) {
        FeedbackRequest request = (FeedbackRequest)JsonHelper.convert((String)json, FeedbackRequest.class);
        request.setSmartConvType(SmartConvType.CONV_QUEUE);
        return new Conversion().setRequest(request);
    }

    private List<Conversion> getOnConversionAndClickQueue(Stat stat, int count) {
        ArrayList result;
        block8: {
            result = Lists.newArrayList();
            try {
                if (count > 0) {
                    List<Conversion> conversionQueue = this.getOnAppConversionQueueOrderBy(count);
                    result.addAll(conversionQueue);
                    List<Object> ticketConversionQueue = Lists.newArrayList();
                    int remain = count - result.size();
                    if (remain > 0) {
                        ticketConversionQueue = this.getOnTicketConversionQueueOrderBy(remain);
                        result.addAll(ticketConversionQueue);
                    }
                    List<Object> clickQueue = Lists.newArrayList();
                    remain = count - result.size();
                    if (remain > 0) {
                        if (stat.getReceivers() == 0L) {
                            throw new IllegalStateException("\u6ca1\u6709\u5b9e\u9645\u8f6c\u5316\u6570\uff0c\u6240\u4ee5\u4e0d\u80fd\u8fdb\u884c\u8865\u91cf\u3002");
                        }
                        remain = this.getConfig().minForLimit(stat.getPlus(), remain);
                        if (remain <= 0) {
                            throw new IllegalStateException(String.format("\u5f53\u524d\u5df2\u8865\u91cf\u6570 %s \u8d85\u8fc7\u4e86\u9650\u5236\u6570 %s\u3002", stat.getPlus(), this.getConfig().getLimitUnconvs()));
                        }
                        clickQueue = this.getOnClickQueue(remain);
                        result.addAll(clickQueue);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Need size: {} From Conversion={}, TicketConversion={}, Click={}", new Object[]{this.getDimension(), count, conversionQueue.size(), ticketConversionQueue.size(), clickQueue.size()});
                    }
                }
            }
            catch (IllegalStateException e) {
                if (!log.isInfoEnabled()) break block8;
                log.info("[{}] - {}", (Object)this.getDimension(), (Object)e.getMessage());
            }
        }
        return result;
    }

    private List<Conversion> getOnAppConversionQueueOrderBy(int size) {
        RatioControlConfig config = this.getConfig();
        String dimension = this.getDimension();
        int offset = 0;
        int step = 10;
        ArrayList result = Lists.newArrayList();
        block0: do {
            int stop;
            int start;
            Set<String> topN;
            if (CollectionUtils.isEmpty(topN = this.control.getTopN(start = offset * step, stop = (offset + 1) * step - 1))) {
                if (!log.isWarnEnabled()) break;
                log.warn("[{}] \u6ca1\u6709\u7b56\u7565\u6392\u884c\u5355\u5728\u8f6c\u5316\u65f6 {}-{}", new Object[]{config.getDimension(), start, stop});
                break;
            }
            for (String app : topN) {
                String json;
                String key = RedisRatioControlImpl.listAppConversionQueue(config.getDuration(), config.getDimension(), app).generateKey();
                while (!StringUtils.isBlank((String)(json = this.rightPopOneOnKeyQueue(key)))) {
                    Conversion conversion = this.convert(json);
                    if (!this.isValid(conversion)) {
                        log.info("[{}] - \u65e0\u6548\u7684\u8f6c\u5316\uff1a{}", (Object)dimension, (Object)conversion.getRequest().getKeyValueMap());
                    } else {
                        result.add(json);
                    }
                    if (result.size() < size) continue;
                }
                if (result.size() >= size) continue block0;
                ++offset;
            }
        } while (result.size() < size);
        return this.convert(result);
    }

    private List<Conversion> getOnTicketConversionQueueOrderBy(int size) {
        String key;
        String json;
        RatioControlConfig config = this.getConfig();
        String ticketConversionDimension = ControlUtils.createKey(config.getTagId(), config.getAdGroupId());
        ArrayList result = Lists.newArrayList();
        while (!StringUtils.isBlank((String)(json = this.rightPopOneOnKeyQueue(key = RedisRatioControlImpl.listTicketConversionQueue(ticketConversionDimension).generateKey())))) {
            Conversion conversion = this.convert(json);
            if (!this.isValid(conversion)) {
                log.info("[{}] - \u65e0\u6548\u7684\u8f6c\u5316\uff1a{}", (Object)ticketConversionDimension, (Object)conversion.getRequest().getKeyValueMap());
            } else {
                result.add(json);
            }
            if (result.size() < size) continue;
        }
        return this.convert(result);
    }

    private boolean isValid(Conversion conversion) {
        KeyValueMap inadsLog = conversion.getRequest().getKeyValueMap();
        ClickTracker clickTracker = this.getClickTracker();
        if (Objects.isNull(clickTracker)) {
            log.warn("[{}] - No clickTracker!", (Object)this.getDimension());
            return true;
        }
        String clickId = clickTracker.getClickIdOnInadsAdClickLog(inadsLog);
        return this.isValid(clickId);
    }

    private List<Conversion> getOnClickQueue(int size) {
        ArrayList result = Lists.newArrayList();
        List<ClickLog> clickLogs = this.searchOnClickQueue(size);
        clickLogs.forEach(e -> {
            FeedbackRequest request = this.of((ClickLog)e);
            result.add(new Conversion().setRequest(request).setClickLog((ClickLog)e));
        });
        return result;
    }

    private List<ClickLog> searchOnClickQueue(int size) {
        RatioControlConfig config = this.getConfig();
        String dimension = this.getDimension();
        int offset = 0;
        int step = 10;
        ArrayList headList = Lists.newArrayList();
        ArrayList helpList = Lists.newArrayList();
        block0: do {
            int stop;
            int start;
            Set<String> topN;
            if (CollectionUtils.isEmpty(topN = this.control.getTopN(start = offset * step, stop = (offset + 1) * step - 1))) {
                if (!log.isWarnEnabled()) break;
                log.warn("[{}] \u6ca1\u6709\u7b56\u7565\u6392\u884c\u5355\u5728\u70b9\u51fb\u65f6 {}-{}", new Object[]{config.getDimension(), start, stop});
                break;
            }
            for (String app : topN) {
                String clickLogJson;
                String key = RedisRatioControlImpl.listClickQueue(config.getDuration(), config.getDimension(), app).generateKey();
                while (!StringUtils.isBlank((String)(clickLogJson = this.leftPop(key)))) {
                    ClickLog clickLog = (ClickLog)JsonHelper.convert((String)clickLogJson, ClickLog.class);
                    if (!this.isValid(clickLog)) {
                        log.info("[{}] - \u65e0\u6548\u7684\u70b9\u51fb\uff1a{}", (Object)dimension, (Object)clickLog.getClickId());
                    } else if (!clickLog.isHeadTicket()) {
                        if (size > helpList.size()) {
                            helpList.add(clickLog);
                        }
                    } else {
                        headList.add(clickLog);
                    }
                    if (headList.size() < size) continue;
                }
                if (headList.size() >= size) continue block0;
                ++offset;
            }
        } while (headList.size() < size);
        if (headList.size() >= size) {
            return headList;
        }
        int remainHead = size - headList.size();
        for (int j = 0; j < remainHead && j < helpList.size(); ++j) {
            headList.add(helpList.get(remainHead));
        }
        if (log.isDebugEnabled()) {
            headList.forEach(o -> log.debug("[{}] From click: adid={}, app={}", new Object[]{config.getDimension(), o.getAdid(), o.getApp()}));
        }
        return headList;
    }

    private boolean isValid(ClickLog clickLog) {
        String clickId = clickLog.getClickId();
        return this.isValid(clickId);
    }

    private boolean isValid(String clickId) {
        RatioControlConfig config = this.getConfig();
        String dimension = this.getDimension();
        ClickTracker clickTracker = this.getClickTracker();
        if (Objects.isNull(clickTracker)) {
            log.warn("[{}] - No clickTracker!", (Object)dimension);
            return true;
        }
        KeyValueMap trackerLog = clickTracker.getClickTracker(clickId);
        if (Objects.isNull(trackerLog)) {
            log.warn("[{}] - No found: {}", (Object)dimension, (Object)clickId);
            return true;
        }
        long timestamp = NumberUtils.toLong((String)((String)trackerLog.getFirst((Object)"time")), (long)0L);
        if (timestamp == 0L) {
            log.warn("[{}] - Illegal time value: {}", (Object)dimension, (Object)trackerLog);
            return true;
        }
        LocalDateTime localDateTime = LocalDateTimeUtils.of(timestamp);
        if (config.getDuration() == RatioControlConfig.Duration2.HOUR) {
            return LocalTime.now().getHour() == localDateTime.getHour();
        }
        if (config.getDuration() == RatioControlConfig.Duration2.DAY) {
            return LocalDate.now().equals(localDateTime.toLocalDate());
        }
        return true;
    }

    private String rightPopOneOnKeyQueue(String key) {
        String item = this.rightPop(key);
        if (StringUtils.isBlank((String)item)) {
            return null;
        }
        String[] largeId = RedisRatioControlImpl.splitLargeId(item);
        long createTime = NumberUtils.toLong((String)largeId[0]);
        Duration duration = Duration.ofHours(this.getConfig().getExpireInHours());
        if (System.currentTimeMillis() - createTime > duration.toMillis()) {
            if (log.isInfoEnabled()) {
                log.info("{} | Created at {}, Expired hour: {}", new Object[]{item, RedisRatioControlImpl.ofTimeMillis(createTime), duration.toHours()});
            }
            return this.rightPopOneOnKeyQueue(key);
        }
        return largeId[1];
    }

    private FeedbackRequest of(ClickLog clickLog) {
        PositionRtb positionRtb = clickLog.getConfig();
        String targetOneRtb = positionRtb.getTargetOneRtb();
        String targetTwoRtb = positionRtb.getTargetTwoRtb();
        String eventType = targetOneRtb;
        int conversionLevel = 1;
        if (this.getConfig().getConversionLevel() == ConversionLevel.DEEP) {
            eventType = targetTwoRtb;
            conversionLevel = 2;
        }
        KeyValueMap clickKeyValueMap = clickLog.getClickKeyValueMap();
        String referrer = (String)clickKeyValueMap.getFirst((Object)"refer");
        FeedbackRequest request = FeedbackRequest.builder().config(positionRtb).conversionLevel(conversionLevel).conversionType("0").smartConvType(SmartConvType.CLICK_QUEUE).keyValueMap(clickKeyValueMap).eventType(eventType).referrer(referrer).appid(clickLog.getApp()).build();
        request.setAdGroupId(this.fetchAdGroupId(this.getInstance(), request));
        return request;
    }

    private String fetchAdGroupId(RtbIntegration integration, FeedbackRequest request) {
        String adGroupId = null;
        if (integration instanceof ClickTracker) {
            ClickTracker clickTracker = (ClickTracker)((Object)integration);
            adGroupId = clickTracker.getAdGroupId(request);
        }
        return adGroupId;
    }

    private void leftPush(String key, String ... members) {
        try (Jedis jedis = this.getJedisPool().getResource();){
            jedis.lpush(key, members);
            jedis.expire(key, this.getConfig().getExpireInSeconds());
        }
        catch (Exception e) {
            log.error("lpush: {}", (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String leftPop(String key) {
        try (Jedis jedis = this.getJedisPool().getResource();){
            String string = jedis.lpop(key);
            return string;
        }
        catch (Exception e) {
            log.error("lpop: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String rightPop(String key) {
        try (Jedis jedis = this.getJedisPool().getResource();){
            String string = jedis.rpop(key);
            return string;
        }
        catch (Exception e) {
            log.error("rpop: {}", (Object)e.getMessage());
            return null;
        }
    }

    private ClickTracker getClickTracker() {
        RatioControlBus bus = this.control.getBus();
        RtbIntegration instance = bus.getInstance();
        if (instance instanceof ClickTracker) {
            return (ClickTracker)((Object)instance);
        }
        return null;
    }

    private static class Conversion {
        private FeedbackRequest request;
        private ClickLog clickLog;

        public boolean isFromClick() {
            return Objects.nonNull(this.clickLog);
        }

        public FeedbackRequest getRequest() {
            return this.request;
        }

        public ClickLog getClickLog() {
            return this.clickLog;
        }

        public Conversion setRequest(FeedbackRequest request) {
            this.request = request;
            return this;
        }

        public Conversion setClickLog(ClickLog clickLog) {
            this.clickLog = clickLog;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conversion)) {
                return false;
            }
            Conversion other = (Conversion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FeedbackRequest this$request = this.getRequest();
            FeedbackRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            ClickLog this$clickLog = this.getClickLog();
            ClickLog other$clickLog = other.getClickLog();
            return !(this$clickLog == null ? other$clickLog != null : !((Object)this$clickLog).equals(other$clickLog));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Conversion;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FeedbackRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            ClickLog $clickLog = this.getClickLog();
            result = result * 59 + ($clickLog == null ? 43 : ((Object)$clickLog).hashCode());
            return result;
        }

        public String toString() {
            return "RedisRatioControlScheduler.Conversion(request=" + this.getRequest() + ", clickLog=" + this.getClickLog() + ")";
        }
    }
}

