/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioClickEvent;
import com.bxm.adscounter.rtb.common.control.ratio.listener.ListenerKey;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Objects;

public class RatioClickEventListener
implements EventListener<RatioClickEvent> {
    private final Updater updater;
    private final Counter counter;

    public RatioClickEventListener(Updater updater, Counter counter) {
        this.updater = updater;
        this.counter = counter;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(RatioClickEvent event) {
        RatioControl control = event.getControl();
        RatioControlConfig config = control.getConfig();
        String dimension = config.getDimension();
        String tagid = config.getTagId();
        String adGroupId = event.getAdGroupId();
        String app = event.getApp();
        this.counter.hincrementByAndGet(ListenerKey.hashData(Objects.toString(config.getHitConfigId())), "click", 1L, ListenerKey.ONE_DAY_SEC);
        this.counter.hincrementByAndGet(ListenerKey.hashData(dimension), "click", 1L, ListenerKey.ONE_DAY_SEC);
        this.counter.hincrementByAndGet(ListenerKey.hashDataApp(dimension, app), "click", 1L, ListenerKey.ONE_DAY_SEC);
        this.updater.supdate(ListenerKey.setsMap(tagid, adGroupId), ListenerKey.ONE_DAY_SEC, new String[]{app});
    }
}

