/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.AbstractRatioEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

public class RatioOpenLogEventListener
implements EventListener<AbstractRatioEvent> {
    private final RtbProperties properties;
    private final OpenLogClient openLogClient;

    public RatioOpenLogEventListener(RtbProperties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AbstractRatioEvent event) {
        int actionType = event.getActionTypeForOpenLog();
        if (actionType == -1) {
            return;
        }
        RatioControl control = event.getControl();
        RatioControlConfig config = control.getConfig();
        String tagId = config.getTagId();
        Rtb rtb = control.getBus().getInstance().rtb();
        String adGroupId = event.getAdGroupId();
        String app = event.getApp();
        KeyValueMap map = new KeyValueMap();
        map.put("p", Production.COMMON.getName());
        map.put("mt", Common.Mt.RtbSmartConversion.original());
        map.put("action", (Object)actionType);
        map.put("tagid", tagId);
        map.put("rtb_id", (Object)rtb.getType());
        map.put("ad_group_id", adGroupId);
        map.put("appid", app);
        map.put("time", (Object)System.currentTimeMillis());
        map.put("duration", (Object)config.getDuration().getValue());
        map.put("plus_strategy", (Object)config.getPlusStrategy().getValue());
        String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain());
        this.openLogClient.asyncRequest(openLogRequestUri);
    }
}

