/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.ticket;

import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.control.ControlUtils;
import com.bxm.adscounter.rtb.common.control.ticket.TicketRatioControl;
import com.bxm.adscounter.rtb.common.event.RtbDeductionEvent;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.utils.PositionRTBUtils;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisTicketRatioControlImpl
implements TicketRatioControl {
    private static final Logger log = LoggerFactory.getLogger(RedisTicketRatioControlImpl.class);
    private static final String SPLIT = "|";
    private static final Integer ONE_DAY_SEC = (int)Duration.ofHours(24L).getSeconds();
    private final JedisPool jedisPool;
    private final EventPark eventPark;
    private MeterRegistry registry;

    public RedisTicketRatioControlImpl(JedisPool jedisPool, EventPark eventPark) {
        this.jedisPool = jedisPool;
        this.eventPark = eventPark;
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    @Override
    public boolean onControl(FeedbackRequest request, RtbIntegration rtbIntegration) {
        boolean isDeduction;
        PositionRtb config = request.getConfig();
        if (config.isFeedbackModeSummaryCpa()) {
            return false;
        }
        if (rtbIntegration instanceof ClickTracker && (isDeduction = this.isDeduction(request))) {
            this.pushConversion(request);
            return true;
        }
        return false;
    }

    public boolean isDeduction(FeedbackRequest request) {
        PositionRtb config = request.getConfig();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String ticketId = (String)keyValueMap.getFirst((Object)"adid");
        if (StringUtils.isBlank((String)ticketId)) {
            return false;
        }
        PositionRtb.TargetBXM targetBXM = PositionRTBUtils.convert(ticketId, config);
        Double ratio = Optional.ofNullable(targetBXM.getRatio()).orElse(1.0);
        if (ratio == 1.0) {
            return false;
        }
        String positionId = config.getPositionId();
        String adGroupId = request.getAdGroupId();
        String dimension = ControlUtils.createKey(positionId, adGroupId, ticketId);
        Integer sourceType = config.getSourceType();
        Rtb rtb = Rtb.of(sourceType);
        return this.isDeduction0(ratio, dimension, request, rtb);
    }

    private boolean isDeduction0(Double ratio, String dimension, FeedbackRequest request, Rtb rtb) {
        boolean feedbackIfNecessary;
        double stepValue = 1.0;
        double zeroRatio = 0.0;
        if (!this.isInitializedCountRate(dimension) && ratio > zeroRatio) {
            this.incrCountRateBy(stepValue, dimension);
        }
        this.registry.counter("deduction.ticket.control", this.tags(dimension)).increment();
        double after = this.incrCountRateBy(ratio, dimension);
        boolean bl = feedbackIfNecessary = after >= stepValue;
        if (feedbackIfNecessary) {
            this.incrCountRateBy(-stepValue, dimension);
            this.registry.counter("deduction.ticket.control.accept", this.tags(dimension)).increment();
            return false;
        }
        this.eventPark.post((EventObject)new RtbDeductionEvent(this, rtb, request, RtbDeductionEvent.DEDUCTION_TICKET));
        this.registry.counter("deduction.ticket.control.reject", this.tags(dimension)).increment();
        return true;
    }

    private void pushConversion(FeedbackRequest request) {
        String dimension = ControlUtils.createKey(request.getConfig().getPositionId(), request.getAdGroupId());
        String data = JsonHelper.convert((Object)request);
        this.addConversion(dimension, data);
    }

    private void addConversion(String dimension, String data) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = RedisTicketRatioControlImpl.listConversionQueue(dimension).generateKey();
            jedis.lpush(key, new String[]{RedisTicketRatioControlImpl.createLargeId(data)});
            jedis.expire(key, this.getExpireInSeconds());
        }
    }

    private boolean isInitializedCountRate(String dimension) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisTicketRatioControlImpl.stringRateCountInitialized(dimension).generateKey();
            Long rs = jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC.intValue());
            boolean bl = Optional.ofNullable(rs).orElse(1L) > 1L;
            return bl;
        }
    }

    private double incrCountRateBy(double incrementValue, String dimension) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisTicketRatioControlImpl.stringCountRate(dimension).generateKey();
            double rs = jedis.incrByFloat(key, incrementValue);
            jedis.expire(key, ONE_DAY_SEC.intValue());
            double d = rs;
            return d;
        }
    }

    private static KeyGenerator stringRateCountInitialized(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "DED_TICKET_INIT", RedisTicketRatioControlImpl.getDate(), dimension});
    }

    private static KeyGenerator stringCountRate(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "DED_TICKET_RATE", RedisTicketRatioControlImpl.getDate(), dimension});
    }

    static KeyGenerator listConversionQueue(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "TICKET_CONV_QUEUE", RedisTicketRatioControlImpl.getDate(), dimension});
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    private static String getDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    private static String createLargeId(String data) {
        return System.currentTimeMillis() + SPLIT + data;
    }

    public int getExpireInSeconds() {
        return (int)Duration.ofHours(24L).getSeconds();
    }

    private List<Tag> tags(String dimension) {
        return Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"dim", (String)dimension)});
    }
}

