/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl;

import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.impl.AbstractHttpRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractClickTrackerRtbIntegration
extends AbstractHttpRtbIntegration
implements ClickTracker {
    private static final Logger log = LoggerFactory.getLogger(AbstractClickTrackerRtbIntegration.class);
    private Fetcher fetcher;
    private Updater updater;
    private PositionRtbService positionRtbService;

    public AbstractClickTrackerRtbIntegration(RtbConfig config) {
        super(config);
    }

    public AbstractClickTrackerRtbIntegration(RtbConfig config, HttpClient httpClient) {
        super(config, httpClient);
    }

    @Autowired
    public void setFetcher(@Qualifier(value="rtbJedisFetcher") Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Autowired
    public void setUpdater(@Qualifier(value="rtbJedisUpdater") Updater updater) {
        this.updater = updater;
    }

    @Autowired
    public void setPositionRtbService(PositionRtbService positionRtbService) {
        this.positionRtbService = positionRtbService;
    }

    @Override
    public void saveClickTracker(KeyValueMap clickTrackerKeyValueMap) {
        if (!this.saveIfNecessary(clickTrackerKeyValueMap)) {
            return;
        }
        String clickId = this.getClickId(clickTrackerKeyValueMap);
        if (StringUtils.isBlank((String)clickId)) {
            return;
        }
        this.updater.update(this.createKey(clickId), (Object)clickTrackerKeyValueMap, 86400);
    }

    @Override
    public KeyValueMap getClickTracker(String clickId) {
        return (KeyValueMap)this.fetcher.fetch(this.createKey(clickId), KeyValueMap.class);
    }

    private boolean saveIfNecessary(KeyValueMap clickTrackerKeyValueMap) {
        if (this.forceSaveClickTracker()) {
            return true;
        }
        String tagId = (String)clickTrackerKeyValueMap.getFirst((Object)"tagid");
        if (StringUtils.isNotBlank((String)tagId)) {
            PositionRtb config = this.positionRtbService.get(tagId);
            if (Objects.isNull(config)) {
                return false;
            }
            return config.isControlForAnyType();
        }
        if (log.isWarnEnabled()) {
            log.warn("{} - recommend integration 'tagid' on this click tracker url.", (Object)this.rtb());
        }
        return true;
    }
}

