/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.alipaydh;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayDataDataserviceAdConversionUploadRequest;
import com.alipay.api.response.AlipayDataDataserviceAdConversionUploadResponse;
import com.bxm.adscounter.integration.adsmedia.AdsmediaService;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.alipaydh.AlipayDHConfig;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceUrlVO;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.util.UriComponentsBuilder;

public class AlipayDHRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(AlipayDHRtbIntegration.class);
    private final Fetcher fetcher;
    private final AlipayDHConfig config;
    private final AdsmediaService adsmediaService;

    public AlipayDHRtbIntegration(AlipayDHConfig config, @Qualifier(value="rtbJedisFetcher") Fetcher fetcher, AdsmediaService adsmediaService) {
        super(config);
        this.fetcher = fetcher;
        this.config = config;
        this.adsmediaService = adsmediaService;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)"click_id");
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        return UrlHelper.getFirstValueOfParamName((String)request.getReferrer(), (String)"ad_group_id");
    }

    @Override
    public FeedbackResponse doFeedback(FeedbackRequest request, int status) throws RtbIntegrationException {
        try {
            String eventType = request.getEventType();
            KeyValueMap keyValueMap = request.getKeyValueMap();
            String bxmId = (String)keyValueMap.getFirst((Object)"bxmid");
            String clickId = request.getClickId();
            if (StringUtils.isBlank((String)clickId)) {
                clickId = (String)UriComponentsBuilder.fromUriString((String)request.getReferrer()).build().getQueryParams().getFirst((Object)"click_id");
            }
            String tagId = (String)keyValueMap.getFirst((Object)"tagid");
            if (StringUtils.isBlank((String)clickId)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found clickId. keyValueMap: %s", JSONObject.toJSONString((Object)keyValueMap)));
            }
            String customerId = request.getConfig().getCustomerId();
            String token = request.getConfig().getToken();
            String sourceId = request.getConfig().getSourceId();
            String extend = request.getConfig().getExtend();
            String privateKey = null;
            String publicKey = null;
            String appId = null;
            if (StringUtils.isNotBlank((String)extend)) {
                AlipayConfig alipayConfig = (AlipayConfig)JsonHelper.convert((String)extend, AlipayConfig.class);
                appId = alipayConfig.getAppId();
                privateKey = alipayConfig.getPrivateKey();
                publicKey = alipayConfig.getPublicKey();
            } else {
                AlipayDHConfig.AlipayDHEnum alipayDHEnum = AlipayDHConfig.AlipayDHEnum.of(sourceId);
                appId = alipayDHEnum.getAppId();
                privateKey = alipayDHEnum.getPrivateKey();
                publicKey = alipayDHEnum.getPublicKey();
            }
            if (StringUtils.isBlank((String)appId) || StringUtils.isBlank((String)publicKey) || StringUtils.isBlank((String)privateKey)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found appId/publicKey/privateKey keyValueMap: %s", JSONObject.toJSONString((Object)keyValueMap)));
            }
            DefaultAlipayClient alipayClient = new DefaultAlipayClient(this.config.getUrl(), appId, privateKey, "json", "GBK", publicKey, "RSA2");
            AlipayDataDataserviceAdConversionUploadRequest alipayRequest = new AlipayDataDataserviceAdConversionUploadRequest();
            String appendvalue = "{          \"key\":\"tinyapp_id\",          \"value\":\"" + appId + "\"}";
            AppEntranceUrlVO appEntranceUrlVO = this.adsmediaService.getUrl(tagId);
            if (Objects.isNull(appEntranceUrlVO)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, String.format("nomal is null , tagId: %s Cannot found sourceId. keyValueMap: %s", tagId, JSONObject.toJSONString((Object)keyValueMap)));
            }
            if (StringUtils.equalsIgnoreCase((String)"425", (String)eventType)) {
                appendvalue = "{          \"key\":\"conversion_target_url\",          \"value\":\"" + appEntranceUrlVO.getNormal() + "\"}";
            } else if (StringUtils.equalsIgnoreCase((String)"426", (String)eventType)) {
                String finalUrl = "alipays://platformapi/startapp?appId=" + appId + "&page=pages/preW/index" + UrlHelper.urlEncode((String)("?url=" + UrlHelper.urlEncode((String)appEntranceUrlVO.getNormal().split("&click_id")[0])));
                appendvalue = appendvalue + ",{          \"key\":\"conversion_target_url\",          \"value\":\"" + finalUrl + "\"}";
            }
            alipayRequest.setBizContent("{  \"biz_token\":\"" + token + "\",  \"conversion_data_list\":[    {      \"source\":\"COMMON_TARGET\",      \"principal_tag\":\"" + customerId + "\",      \"biz_no\":\"" + System.currentTimeMillis() + "\",      \"conversion_type\":\"" + eventType + "\",      \"conversion_time\":" + System.currentTimeMillis() / 1000L + ",      \"uuid_type\":\"PID\",      \"uuid\":\"2088UID\",      \"property_list\":[" + appendvalue + "      ],      \"callback_ext_info\":\"" + UrlHelper.urlDecode((String)clickId) + "\"    }  ]}");
            AlipayDataDataserviceAdConversionUploadResponse alipayResponse = (AlipayDataDataserviceAdConversionUploadResponse)alipayClient.execute((AlipayRequest)alipayRequest);
            if (alipayResponse.isSuccess()) {
                return this.convert(request, null);
            }
            FeedbackResponse feedbackResponse = new FeedbackResponse();
            feedbackResponse.setSuccess(false);
            feedbackResponse.setBody(JSON.toJSONString((Object)alipayResponse));
            return feedbackResponse;
        }
        catch (Exception e) {
            throw new RtbIntegrationException(FailType.OtherException, (Throwable)e);
        }
    }

    @Override
    public Rtb rtb() {
        return Rtb.ALIPAY_DH;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        return null;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

    public static void main(String[] args) {
        AlipayDHConfig.AlipayDHEnum alipayDHEnum = AlipayDHConfig.AlipayDHEnum.of("5");
        String finalUrl = "alipays://platformapi/startapp?appId=" + alipayDHEnum.getAppId() + "&page=pages/preW/index" + UrlHelper.urlEncode((String)("?url=" + UrlHelper.urlDecode((String)"https://i.hangzhouyiyao.com/activities?appKey=9589f21a5898482db619691afe0eabc7&appEntrance=3&business=money&click_id=__CALLBACK_EXT_INFO__&ad_group_id=__GROUP_ID__")));
        System.out.println(finalUrl);
        String url = "http://47.98.242.33:19822/activities/?appKey=d3e539ff67104565ab7a27d1face582e&appEntrance=52&business=money&click_id=__CALLBACK_EXT_INFO__&ad_group_id=__GROUP_ID__";
        System.out.println(url);
        System.out.println(url.split("&click_id")[0]);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url);
        builder.replaceQueryParam("click_id", new Object[0]);
        builder.replaceQueryParam("ad_group_id", new Object[0]);
        System.out.println(builder.build().toUriString());
    }

    private static class AlipayConfig {
        private String privateKey;
        private String publicKey;
        private String appId;

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlipayConfig)) {
                return false;
            }
            AlipayConfig other = (AlipayConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$privateKey = this.getPrivateKey();
            String other$privateKey = other.getPrivateKey();
            if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
                return false;
            }
            String this$publicKey = this.getPublicKey();
            String other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            String this$appId = this.getAppId();
            String other$appId = other.getAppId();
            return !(this$appId == null ? other$appId != null : !this$appId.equals(other$appId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlipayConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            String $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            String $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
            return result;
        }

        public String toString() {
            return "AlipayDHRtbIntegration.AlipayConfig(privateKey=" + this.getPrivateKey() + ", publicKey=" + this.getPublicKey() + ", appId=" + this.getAppId() + ")";
        }
    }
}

