/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.alipaylife;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.alipaylife.AlipayLifeConfig;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class AlipayLifeRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(AlipayLifeRtbIntegration.class);

    public AlipayLifeRtbIntegration(AlipayLifeConfig config) {
        super(config);
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "qcjParamStr";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String clickIdParameterNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        String qcjParamStr = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank((String)qcjParamStr)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        AlipayLifeRequest alipayLifeRequest = new AlipayLifeRequest().setQcjParamStr(qcjParamStr);
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)alipayLifeRequest), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    public Rtb rtb() {
        return Rtb.AlipayLife;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class AlipayLifeRequest {
        private String qcjParamStr;
        private int event = 2;

        public String getQcjParamStr() {
            return this.qcjParamStr;
        }

        public int getEvent() {
            return this.event;
        }

        public AlipayLifeRequest setQcjParamStr(String qcjParamStr) {
            this.qcjParamStr = qcjParamStr;
            return this;
        }

        public AlipayLifeRequest setEvent(int event) {
            this.event = event;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlipayLifeRequest)) {
                return false;
            }
            AlipayLifeRequest other = (AlipayLifeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getEvent() != other.getEvent()) {
                return false;
            }
            String this$qcjParamStr = this.getQcjParamStr();
            String other$qcjParamStr = other.getQcjParamStr();
            return !(this$qcjParamStr == null ? other$qcjParamStr != null : !this$qcjParamStr.equals(other$qcjParamStr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlipayLifeRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getEvent();
            String $qcjParamStr = this.getQcjParamStr();
            result = result * 59 + ($qcjParamStr == null ? 43 : $qcjParamStr.hashCode());
            return result;
        }

        public String toString() {
            return "AlipayLifeRtbIntegration.AlipayLifeRequest(qcjParamStr=" + this.getQcjParamStr() + ", event=" + this.getEvent() + ")";
        }
    }

    private static class Response
    extends FeedbackResponse {
        private String code;
        private String msg;
        private String data;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase((String)"000000", (String)this.code);
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

