/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.baidu;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.DataFetchFailException;
import com.bxm.adscounter.rtb.common.DataFetcher;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.data.Parameter;
import com.bxm.adscounter.rtb.common.impl.AbstractHttpRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.baidu.BaiduAk;
import com.bxm.adscounter.rtb.common.impl.baidu.BaiduConfig;
import com.bxm.adscounter.rtb.common.impl.kuaishou.AccountBindCache;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class BaiduDataFetcher
implements DataFetcher {
    private static final Logger log = LoggerFactory.getLogger(BaiduDataFetcher.class);
    private final BaiduConfig config;
    private final JedisPool rtbJedisPool;
    private final HttpClient httpClient;
    private final Fetcher fetcher;
    private static final int UNIT_REPORT_TYPE = 2330652;

    public BaiduDataFetcher(BaiduConfig config, JedisPool rtbJedisPool, Fetcher fetcher) {
        this.config = config;
        this.httpClient = AbstractHttpRtbIntegration.createHttpClient(config);
        this.rtbJedisPool = rtbJedisPool;
        this.fetcher = fetcher;
    }

    private static String getToday() {
        return BaiduDataFetcher.getToday(0L);
    }

    private static String getToday(long days) {
        return LocalDate.now().plusDays(days).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    private static String getHour(long hours) {
        return LocalDateTime.now().plusHours(hours).withMinute(0).format(DateTimeFormatter.ofPattern("HH"));
    }

    @Override
    public Rtb rtb() {
        return Rtb.Baidu;
    }

    @Override
    public List<AdGroupData> fetchTodayData(Parameter parameter) throws DataFetchFailException {
        String today = BaiduDataFetcher.getToday();
        return this.fetch0(parameter, today, null);
    }

    @Override
    public List<AdGroupData> fetchCurrentHourData(Parameter parameter) throws DataFetchFailException {
        String today = BaiduDataFetcher.getToday();
        String hour = BaiduDataFetcher.getHour(0L);
        return this.fetch0(parameter, today, hour);
    }

    @Override
    public List<AdGroupData> fetchPreviousHourData(Parameter parameter) throws DataFetchFailException {
        String today = LocalTime.now().getHour() == 0 ? BaiduDataFetcher.getToday(-1L) : BaiduDataFetcher.getToday();
        String hour = BaiduDataFetcher.getHour(-1L);
        return this.fetch0(parameter, today, hour);
    }

    private List<AdGroupData> fetch0(Parameter parameter, String date, String hour) throws DataFetchFailException {
        String tagId = parameter.getTagId();
        String adGroupId = parameter.getAdGroupId();
        String advertiserId = null;
        String advertiserName = null;
        String json = null;
        try {
            BaiduUnitReportRes res;
            AccountBindCache accountBind = this.getAccountBind(tagId);
            if (Objects.isNull(accountBind)) {
                throw new DataFetchFailException("\u767e\u5ea6\u8d26\u6237\u7ed1\u5b9a\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5728\u5e7f\u544a\u4f4d\uff1a" + tagId);
            }
            advertiserId = accountBind.getAccountId();
            advertiserName = accountBind.getAccountName();
            if (StringUtils.isBlank((String)advertiserId)) {
                throw new DataFetchFailException("'advertiserId' \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5728\u5e7f\u544a\u4f4d\uff1a" + tagId);
            }
            if (StringUtils.isBlank((String)advertiserName)) {
                throw new DataFetchFailException("'advertiserName' \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5728\u5e7f\u544a\u4f4d\uff1a" + tagId);
            }
            BaiduAk ak = this.getAk(Objects.toString(this.rtb().getType()), advertiserId);
            if (Objects.isNull(ak)) {
                throw new DataFetchFailException(String.format("\u6ca1\u6709\u627e\u5230 AK \u5bc6\u94a5\uff0c\u5728\u5e7f\u544a\u4f4d\uff1a%s \u548c advertiserId\uff1a%s", tagId, advertiserId));
            }
            String accessToken = ak.getAccessToken();
            JSONObject header = new JSONObject();
            header.put("userName", (Object)advertiserName);
            header.put("accessToken", (Object)accessToken);
            JSONObject body = new JSONObject();
            body.put("reportType", (Object)2330652);
            body.put("userId", (Object)new Long[]{Long.valueOf(advertiserId)});
            body.put("timeUnit", (Object)"HOUR");
            body.put("startDate", (Object)date);
            body.put("endDate", (Object)date);
            body.put("columns", (Object)new String[]{"date", "hour", "adGroupId", "click", "cost", "ocpcTransType", "ocpcTargetTrans", "ocpcTargetTransCPC", "ocpcTargetTransRatio"});
            body.put("filters", (Object)BaiduDataFetcher.buildDataFilter(adGroupId, hour));
            JSONObject req = new JSONObject();
            req.put("header", (Object)header);
            req.put("body", (Object)body);
            if (log.isInfoEnabled()) {
                log.info("baidu data request : {}", (Object)req.toJSONString());
            }
            HttpPost post = new HttpPost(this.config.getUrlReportData());
            post.setEntity((HttpEntity)new StringEntity(req.toJSONString(), StandardCharsets.UTF_8));
            post.addHeader("Content-Type", "application/json;charset=UTF-8");
            HttpResponse hr = this.httpClient.execute((HttpUriRequest)post);
            json = EntityUtils.toString((HttpEntity)hr.getEntity());
            if (log.isInfoEnabled()) {
                log.info("baidu data response : {}", (Object)json);
            }
            if (!(res = (BaiduUnitReportRes)JSONObject.parseObject((String)json, BaiduUnitReportRes.class)).isSuccess()) {
                throw new DataFetchFailException(String.format("\u63a5\u53e3\u8bf7\u6c42\u4e0d\u6210\u529f\uff01\u5e7f\u544a\u4f4d\uff1a%s\uff0cadvertiserId\uff1a%s\u3002\u8fd4\u56de\u7ed3\u679c\uff1a%s", tagId, advertiserId, json));
            }
            return this.convert(res);
        }
        catch (IOException e) {
            throw new DataFetchFailException(String.format("\u63a5\u53e3\u7f51\u7edc\u5f02\u5e38\uff08%s\uff09\uff01\u5e7f\u544a\u4f4d\uff1a%s\uff0cadvertiserId\uff1a%s\u3002", e.getClass().getName(), tagId, advertiserId));
        }
        catch (JSONException e) {
            throw new DataFetchFailException(String.format("\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff01\u5e7f\u544a\u4f4d\uff1a%s\uff0cadvertiserId\uff1a%s, advertiserName\uff1a%s\u3002\u8fd4\u56de\u7ed3\u679c\uff1a%s", tagId, advertiserId, advertiserName, json));
        }
    }

    private BaiduAk getAk(String rtbId, String advertiserId) {
        try (Jedis jedis = this.rtbJedisPool.getResource();){
            String v = jedis.hget(KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "AK", rtbId}), advertiserId);
            BaiduAk baiduAk = Optional.ofNullable(v).filter(StringUtils::isNotBlank).map(s -> (BaiduAk)JsonHelper.convert((String)s, BaiduAk.class)).orElse(null);
            return baiduAk;
        }
    }

    private AccountBindCache getAccountBind(String tagId) {
        return (AccountBindCache)this.fetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"rtb", "account_binding"}), tagId, AccountBindCache.class);
    }

    private List<AdGroupData> convert(BaiduUnitReportRes res) {
        ResHeader header = res.getHeader();
        if (header == null) {
            return null;
        }
        Integer status = header.getStatus();
        if (!Objects.equals(status, 0)) {
            return null;
        }
        Body body = res.getBody();
        if (body == null) {
            return null;
        }
        List<RowData> rowData = body.getData();
        if (CollectionUtils.isEmpty(rowData)) {
            return null;
        }
        List<UnitRow> unitRows = rowData.iterator().next().getRows();
        if (CollectionUtils.isEmpty(unitRows)) {
            return null;
        }
        ArrayList ret = Lists.newArrayList();
        unitRows.forEach(e -> {
            AdGroupData adGroupData = new AdGroupData().setAdGroupId(e.getAdGroupId()).setDate(e.getDate()).setHour(e.getHour()).setCharge(e.getCost()).setTime(System.currentTimeMillis());
            adGroupData.setShallowConvCount(e.getOcpcTargetTrans());
            adGroupData.setShallowConvCost(e.getOcpcTargetTransCPC());
            adGroupData.setDeepConvCount(e.getOcpcTargetTrans());
            adGroupData.setDeepConvCost(e.getOcpcTargetTransCPC());
            adGroupData.setConvNumByImpression(e.getOcpcTargetTrans());
            ret.add(adGroupData);
        });
        log.info("ret {}", (Object)JSONObject.toJSONString((Object)ret));
        return ret;
    }

    private static DataFilter[] buildDataFilter(String adGroupId, String hour) {
        Object[] dataFilters = new DataFilter[]{};
        if (StringUtils.isNotBlank((String)adGroupId)) {
            DataFilter adGroupIdFilter = DataFilter.builder().column("adGroupId").operator("IN").values(new String[]{adGroupId}).build();
            dataFilters = (DataFilter[])ArrayUtils.add((Object[])dataFilters, (Object)adGroupIdFilter);
        }
        if (StringUtils.isNotBlank((String)hour)) {
            DataFilter hourFilter = DataFilter.builder().column("hour").operator("EQ").values(new String[]{hour}).build();
            dataFilters = (DataFilter[])ArrayUtils.add((Object[])dataFilters, (Object)hourFilter);
        }
        return dataFilters;
    }

    private static class DataFilter {
        private String column;
        private String operator;
        private String[] values;

        public static DataFilterBuilder builder() {
            return new DataFilterBuilder();
        }

        public String getColumn() {
            return this.column;
        }

        public String getOperator() {
            return this.operator;
        }

        public String[] getValues() {
            return this.values;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public void setValues(String[] values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataFilter)) {
                return false;
            }
            DataFilter other = (DataFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$column = this.getColumn();
            String other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                return false;
            }
            String this$operator = this.getOperator();
            String other$operator = other.getOperator();
            if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                return false;
            }
            return Arrays.deepEquals(this.getValues(), other.getValues());
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataFilter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            String $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getValues());
            return result;
        }

        public String toString() {
            return "BaiduDataFetcher.DataFilter(column=" + this.getColumn() + ", operator=" + this.getOperator() + ", values=" + Arrays.deepToString(this.getValues()) + ")";
        }

        public DataFilter(String column, String operator, String[] values) {
            this.column = column;
            this.operator = operator;
            this.values = values;
        }

        public static class DataFilterBuilder {
            private String column;
            private String operator;
            private String[] values;

            DataFilterBuilder() {
            }

            public DataFilterBuilder column(String column) {
                this.column = column;
                return this;
            }

            public DataFilterBuilder operator(String operator) {
                this.operator = operator;
                return this;
            }

            public DataFilterBuilder values(String[] values) {
                this.values = values;
                return this;
            }

            public DataFilter build() {
                return new DataFilter(this.column, this.operator, this.values);
            }

            public String toString() {
                return "BaiduDataFetcher.DataFilter.DataFilterBuilder(column=" + this.column + ", operator=" + this.operator + ", values=" + Arrays.deepToString(this.values) + ")";
            }
        }
    }

    public static class ResHeader {
        private int status = -1;
        private String desc;
        private Integer quota;
        private String failures;
        private Integer oprs;
        private String oprtime;

        public int getStatus() {
            return this.status;
        }

        public String getDesc() {
            return this.desc;
        }

        public Integer getQuota() {
            return this.quota;
        }

        public String getFailures() {
            return this.failures;
        }

        public Integer getOprs() {
            return this.oprs;
        }

        public String getOprtime() {
            return this.oprtime;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public void setQuota(Integer quota) {
            this.quota = quota;
        }

        public void setFailures(String failures) {
            this.failures = failures;
        }

        public void setOprs(Integer oprs) {
            this.oprs = oprs;
        }

        public void setOprtime(String oprtime) {
            this.oprtime = oprtime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResHeader)) {
                return false;
            }
            ResHeader other = (ResHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            Integer this$quota = this.getQuota();
            Integer other$quota = other.getQuota();
            if (this$quota == null ? other$quota != null : !((Object)this$quota).equals(other$quota)) {
                return false;
            }
            Integer this$oprs = this.getOprs();
            Integer other$oprs = other.getOprs();
            if (this$oprs == null ? other$oprs != null : !((Object)this$oprs).equals(other$oprs)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
                return false;
            }
            String this$failures = this.getFailures();
            String other$failures = other.getFailures();
            if (this$failures == null ? other$failures != null : !this$failures.equals(other$failures)) {
                return false;
            }
            String this$oprtime = this.getOprtime();
            String other$oprtime = other.getOprtime();
            return !(this$oprtime == null ? other$oprtime != null : !this$oprtime.equals(other$oprtime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResHeader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatus();
            Integer $quota = this.getQuota();
            result = result * 59 + ($quota == null ? 43 : ((Object)$quota).hashCode());
            Integer $oprs = this.getOprs();
            result = result * 59 + ($oprs == null ? 43 : ((Object)$oprs).hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            String $failures = this.getFailures();
            result = result * 59 + ($failures == null ? 43 : $failures.hashCode());
            String $oprtime = this.getOprtime();
            result = result * 59 + ($oprtime == null ? 43 : $oprtime.hashCode());
            return result;
        }

        public String toString() {
            return "BaiduDataFetcher.ResHeader(status=" + this.getStatus() + ", desc=" + this.getDesc() + ", quota=" + this.getQuota() + ", failures=" + this.getFailures() + ", oprs=" + this.getOprs() + ", oprtime=" + this.getOprtime() + ")";
        }
    }

    public static class UnitRow {
        private String date;
        private Integer hour;
        private String adGroupId;
        private Long click;
        private BigDecimal cost;
        private String ocpcTransType;
        private Long ocpcTargetTrans;
        private BigDecimal ocpcTargetTransCPC;
        private BigDecimal ocpcTargetTransRatio;

        public String getDate() {
            return this.date;
        }

        public Integer getHour() {
            return this.hour;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public Long getClick() {
            return this.click;
        }

        public BigDecimal getCost() {
            return this.cost;
        }

        public String getOcpcTransType() {
            return this.ocpcTransType;
        }

        public Long getOcpcTargetTrans() {
            return this.ocpcTargetTrans;
        }

        public BigDecimal getOcpcTargetTransCPC() {
            return this.ocpcTargetTransCPC;
        }

        public BigDecimal getOcpcTargetTransRatio() {
            return this.ocpcTargetTransRatio;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public void setHour(Integer hour) {
            this.hour = hour;
        }

        public void setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
        }

        public void setClick(Long click) {
            this.click = click;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public void setOcpcTransType(String ocpcTransType) {
            this.ocpcTransType = ocpcTransType;
        }

        public void setOcpcTargetTrans(Long ocpcTargetTrans) {
            this.ocpcTargetTrans = ocpcTargetTrans;
        }

        public void setOcpcTargetTransCPC(BigDecimal ocpcTargetTransCPC) {
            this.ocpcTargetTransCPC = ocpcTargetTransCPC;
        }

        public void setOcpcTargetTransRatio(BigDecimal ocpcTargetTransRatio) {
            this.ocpcTargetTransRatio = ocpcTargetTransRatio;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnitRow)) {
                return false;
            }
            UnitRow other = (UnitRow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$hour = this.getHour();
            Integer other$hour = other.getHour();
            if (this$hour == null ? other$hour != null : !((Object)this$hour).equals(other$hour)) {
                return false;
            }
            Long this$click = this.getClick();
            Long other$click = other.getClick();
            if (this$click == null ? other$click != null : !((Object)this$click).equals(other$click)) {
                return false;
            }
            Long this$ocpcTargetTrans = this.getOcpcTargetTrans();
            Long other$ocpcTargetTrans = other.getOcpcTargetTrans();
            if (this$ocpcTargetTrans == null ? other$ocpcTargetTrans != null : !((Object)this$ocpcTargetTrans).equals(other$ocpcTargetTrans)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                return false;
            }
            String this$adGroupId = this.getAdGroupId();
            String other$adGroupId = other.getAdGroupId();
            if (this$adGroupId == null ? other$adGroupId != null : !this$adGroupId.equals(other$adGroupId)) {
                return false;
            }
            BigDecimal this$cost = this.getCost();
            BigDecimal other$cost = other.getCost();
            if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
                return false;
            }
            String this$ocpcTransType = this.getOcpcTransType();
            String other$ocpcTransType = other.getOcpcTransType();
            if (this$ocpcTransType == null ? other$ocpcTransType != null : !this$ocpcTransType.equals(other$ocpcTransType)) {
                return false;
            }
            BigDecimal this$ocpcTargetTransCPC = this.getOcpcTargetTransCPC();
            BigDecimal other$ocpcTargetTransCPC = other.getOcpcTargetTransCPC();
            if (this$ocpcTargetTransCPC == null ? other$ocpcTargetTransCPC != null : !((Object)this$ocpcTargetTransCPC).equals(other$ocpcTargetTransCPC)) {
                return false;
            }
            BigDecimal this$ocpcTargetTransRatio = this.getOcpcTargetTransRatio();
            BigDecimal other$ocpcTargetTransRatio = other.getOcpcTargetTransRatio();
            return !(this$ocpcTargetTransRatio == null ? other$ocpcTargetTransRatio != null : !((Object)this$ocpcTargetTransRatio).equals(other$ocpcTargetTransRatio));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UnitRow;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $hour = this.getHour();
            result = result * 59 + ($hour == null ? 43 : ((Object)$hour).hashCode());
            Long $click = this.getClick();
            result = result * 59 + ($click == null ? 43 : ((Object)$click).hashCode());
            Long $ocpcTargetTrans = this.getOcpcTargetTrans();
            result = result * 59 + ($ocpcTargetTrans == null ? 43 : ((Object)$ocpcTargetTrans).hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            String $adGroupId = this.getAdGroupId();
            result = result * 59 + ($adGroupId == null ? 43 : $adGroupId.hashCode());
            BigDecimal $cost = this.getCost();
            result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
            String $ocpcTransType = this.getOcpcTransType();
            result = result * 59 + ($ocpcTransType == null ? 43 : $ocpcTransType.hashCode());
            BigDecimal $ocpcTargetTransCPC = this.getOcpcTargetTransCPC();
            result = result * 59 + ($ocpcTargetTransCPC == null ? 43 : ((Object)$ocpcTargetTransCPC).hashCode());
            BigDecimal $ocpcTargetTransRatio = this.getOcpcTargetTransRatio();
            result = result * 59 + ($ocpcTargetTransRatio == null ? 43 : ((Object)$ocpcTargetTransRatio).hashCode());
            return result;
        }

        public String toString() {
            return "BaiduDataFetcher.UnitRow(date=" + this.getDate() + ", hour=" + this.getHour() + ", adGroupId=" + this.getAdGroupId() + ", click=" + this.getClick() + ", cost=" + this.getCost() + ", ocpcTransType=" + this.getOcpcTransType() + ", ocpcTargetTrans=" + this.getOcpcTargetTrans() + ", ocpcTargetTransCPC=" + this.getOcpcTargetTransCPC() + ", ocpcTargetTransRatio=" + this.getOcpcTargetTransRatio() + ")";
        }
    }

    public static class RowData {
        private List<UnitRow> rows;
        private UnitRow summary;
        private Integer rowCount;
        private Integer totalRowCount;

        public List<UnitRow> getRows() {
            return this.rows;
        }

        public UnitRow getSummary() {
            return this.summary;
        }

        public Integer getRowCount() {
            return this.rowCount;
        }

        public Integer getTotalRowCount() {
            return this.totalRowCount;
        }

        public void setRows(List<UnitRow> rows) {
            this.rows = rows;
        }

        public void setSummary(UnitRow summary) {
            this.summary = summary;
        }

        public void setRowCount(Integer rowCount) {
            this.rowCount = rowCount;
        }

        public void setTotalRowCount(Integer totalRowCount) {
            this.totalRowCount = totalRowCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RowData)) {
                return false;
            }
            RowData other = (RowData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowCount = this.getRowCount();
            Integer other$rowCount = other.getRowCount();
            if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
                return false;
            }
            Integer this$totalRowCount = this.getTotalRowCount();
            Integer other$totalRowCount = other.getTotalRowCount();
            if (this$totalRowCount == null ? other$totalRowCount != null : !((Object)this$totalRowCount).equals(other$totalRowCount)) {
                return false;
            }
            List<UnitRow> this$rows = this.getRows();
            List<UnitRow> other$rows = other.getRows();
            if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
                return false;
            }
            UnitRow this$summary = this.getSummary();
            UnitRow other$summary = other.getSummary();
            return !(this$summary == null ? other$summary != null : !((Object)this$summary).equals(other$summary));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RowData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowCount = this.getRowCount();
            result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
            Integer $totalRowCount = this.getTotalRowCount();
            result = result * 59 + ($totalRowCount == null ? 43 : ((Object)$totalRowCount).hashCode());
            List<UnitRow> $rows = this.getRows();
            result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
            UnitRow $summary = this.getSummary();
            result = result * 59 + ($summary == null ? 43 : ((Object)$summary).hashCode());
            return result;
        }

        public String toString() {
            return "BaiduDataFetcher.RowData(rows=" + this.getRows() + ", summary=" + this.getSummary() + ", rowCount=" + this.getRowCount() + ", totalRowCount=" + this.getTotalRowCount() + ")";
        }
    }

    public static class Body {
        private List<RowData> data;

        public List<RowData> getData() {
            return this.data;
        }

        public void setData(List<RowData> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Body)) {
                return false;
            }
            Body other = (Body)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<RowData> this$data = this.getData();
            List<RowData> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Body;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<RowData> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "BaiduDataFetcher.Body(data=" + this.getData() + ")";
        }
    }

    public static class Bd {
        private ResHeader header;
        private Body body;

        public boolean isSuccess() {
            return this.header != null && this.header.getStatus() == 0;
        }

        public ResHeader getHeader() {
            return this.header;
        }

        public Body getBody() {
            return this.body;
        }

        public void setHeader(ResHeader header) {
            this.header = header;
        }

        public void setBody(Body body) {
            this.body = body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bd)) {
                return false;
            }
            Bd other = (Bd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ResHeader this$header = this.getHeader();
            ResHeader other$header = other.getHeader();
            if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
                return false;
            }
            Body this$body = this.getBody();
            Body other$body = other.getBody();
            return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Bd;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ResHeader $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
            Body $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
            return result;
        }

        public String toString() {
            return "BaiduDataFetcher.Bd(header=" + this.getHeader() + ", body=" + this.getBody() + ")";
        }
    }

    public static class BaiduUnitReportRes
    extends Bd {
    }
}

