/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.baidu;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.baidu.BaiduConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class BaiduRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    public static final String CLICK_ID = "bd_vid";
    public static final String AD_GROUP_ID = "ad_group_id";

    public BaiduRtbIntegration(BaiduConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        String clickId = (String)queryParams.getFirst((Object)CLICK_ID);
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)AD_GROUP_ID)).orElse("");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        HttpPost post = new HttpPost(this.config.getUrl());
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        BaiduRequest req = new BaiduRequest().setToken(request.getConfig().getToken());
        Long time = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        ConversionType conversionType = new ConversionType().setLogidUrl(request.getReferrer()).setNewType(request.getEventType()).setConvertTime(time);
        req.setConversionTypes(Lists.newArrayList((Object[])new ConversionType[]{conversionType}));
        String entity = JsonHelper.convert((Object)req);
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        request.setRequestBody(entity);
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        return (FeedbackResponse)JsonHelper.convert((String)body, BaiduResponse.class);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Baidu;
    }

    @Override
    public String[] getMissingAdGroupIdList() {
        return new String[]{"__UNIT_ID__", "NULL"};
    }

    private static class Header {
        private String desc;
        private String status;

        private Header() {
        }

        public boolean isSuccess() {
            return StringUtils.equals((String)"0", (String)this.status);
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    private static class BaiduResponse
    extends FeedbackResponse {
        private Header header;

        private BaiduResponse() {
        }

        @Override
        public boolean isSuccess() {
            return Objects.nonNull(this.header) && this.header.isSuccess();
        }

        public Header getHeader() {
            return this.header;
        }

        public void setHeader(Header header) {
            this.header = header;
        }
    }

    private static class ConversionType {
        private String logidUrl;
        private String newType;
        private Long convertTime;

        public String getLogidUrl() {
            return this.logidUrl;
        }

        public String getNewType() {
            return this.newType;
        }

        public Long getConvertTime() {
            return this.convertTime;
        }

        public ConversionType setLogidUrl(String logidUrl) {
            this.logidUrl = logidUrl;
            return this;
        }

        public ConversionType setNewType(String newType) {
            this.newType = newType;
            return this;
        }

        public ConversionType setConvertTime(Long convertTime) {
            this.convertTime = convertTime;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConversionType)) {
                return false;
            }
            ConversionType other = (ConversionType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$convertTime = this.getConvertTime();
            Long other$convertTime = other.getConvertTime();
            if (this$convertTime == null ? other$convertTime != null : !((Object)this$convertTime).equals(other$convertTime)) {
                return false;
            }
            String this$logidUrl = this.getLogidUrl();
            String other$logidUrl = other.getLogidUrl();
            if (this$logidUrl == null ? other$logidUrl != null : !this$logidUrl.equals(other$logidUrl)) {
                return false;
            }
            String this$newType = this.getNewType();
            String other$newType = other.getNewType();
            return !(this$newType == null ? other$newType != null : !this$newType.equals(other$newType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConversionType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $convertTime = this.getConvertTime();
            result = result * 59 + ($convertTime == null ? 43 : ((Object)$convertTime).hashCode());
            String $logidUrl = this.getLogidUrl();
            result = result * 59 + ($logidUrl == null ? 43 : $logidUrl.hashCode());
            String $newType = this.getNewType();
            result = result * 59 + ($newType == null ? 43 : $newType.hashCode());
            return result;
        }

        public String toString() {
            return "BaiduRtbIntegration.ConversionType(logidUrl=" + this.getLogidUrl() + ", newType=" + this.getNewType() + ", convertTime=" + this.getConvertTime() + ")";
        }
    }

    private static class BaiduRequest {
        private String token;
        private List<ConversionType> conversionTypes;

        public String getToken() {
            return this.token;
        }

        public List<ConversionType> getConversionTypes() {
            return this.conversionTypes;
        }

        public BaiduRequest setToken(String token) {
            this.token = token;
            return this;
        }

        public BaiduRequest setConversionTypes(List<ConversionType> conversionTypes) {
            this.conversionTypes = conversionTypes;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaiduRequest)) {
                return false;
            }
            BaiduRequest other = (BaiduRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            List<ConversionType> this$conversionTypes = this.getConversionTypes();
            List<ConversionType> other$conversionTypes = other.getConversionTypes();
            return !(this$conversionTypes == null ? other$conversionTypes != null : !((Object)this$conversionTypes).equals(other$conversionTypes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BaiduRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            List<ConversionType> $conversionTypes = this.getConversionTypes();
            result = result * 59 + ($conversionTypes == null ? 43 : ((Object)$conversionTypes).hashCode());
            return result;
        }

        public String toString() {
            return "BaiduRtbIntegration.BaiduRequest(token=" + this.getToken() + ", conversionTypes=" + this.getConversionTypes() + ")";
        }
    }
}

