/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.baiduocpx;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.baiduocpx.BaiduOcpxConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

public class BaiduOcpxRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    public BaiduOcpxRtbIntegration(BaiduOcpxConfig config) {
        super(config);
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String eventType = request.getEventType();
        String callBack = request.getClickId();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String akey = (String)keyValueMap.getFirst((Object)"akey");
        if (StringUtils.isBlank((String)callBack)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback_url'.");
        }
        if (StringUtils.isBlank((String)akey)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'akey'.");
        }
        callBack = UrlHelper.urlDecode((String)callBack);
        String url = UriComponentsBuilder.fromUriString((String)callBack).replaceQueryParam("a_type", new Object[]{eventType}).replaceQueryParam("a_value", new Object[]{0}).replaceQueryParam("sign", new Object[]{this.sign(callBack, akey)}).build().toString();
        return new HttpGet(url.trim());
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        BaiduResponse response = (BaiduResponse)JsonHelper.convert((String)body, BaiduResponse.class);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(response != null && response.isSuccess());
        feedbackResponse.setBody(response != null ? response.getError_msg() : null);
        return feedbackResponse;
    }

    @Override
    public Rtb rtb() {
        return Rtb.BaiduOcpx;
    }

    private String sign(String callback, String akey) {
        String string = callback + akey;
        return DigestUtils.md5Hex((byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    public static class BaiduResponse {
        private String error_code;
        private String error_msg;

        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase((String)"0", (String)this.error_code);
        }

        public String getError_code() {
            return this.error_code;
        }

        public String getError_msg() {
            return this.error_msg;
        }

        public void setError_code(String error_code) {
            this.error_code = error_code;
        }

        public void setError_msg(String error_msg) {
            this.error_msg = error_msg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaiduResponse)) {
                return false;
            }
            BaiduResponse other = (BaiduResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$error_code = this.getError_code();
            String other$error_code = other.getError_code();
            if (this$error_code == null ? other$error_code != null : !this$error_code.equals(other$error_code)) {
                return false;
            }
            String this$error_msg = this.getError_msg();
            String other$error_msg = other.getError_msg();
            return !(this$error_msg == null ? other$error_msg != null : !this$error_msg.equals(other$error_msg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BaiduResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $error_code = this.getError_code();
            result = result * 59 + ($error_code == null ? 43 : $error_code.hashCode());
            String $error_msg = this.getError_msg();
            result = result * 59 + ($error_msg == null ? 43 : $error_msg.hashCode());
            return result;
        }

        public String toString() {
            return "BaiduOcpxRtbIntegration.BaiduResponse(error_code=" + this.getError_code() + ", error_msg=" + this.getError_msg() + ")";
        }
    }
}

