/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.bigo;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.bigo.BigoConfig;
import com.bxm.adscounter.rtb.common.impl.bigo.BigoRequest;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class BigoRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(BigoRtbIntegration.class);
    private BigoConfig bigoConfig;

    public BigoRtbIntegration(BigoConfig config) {
        super(config);
        this.bigoConfig = config;
    }

    @Override
    public Rtb rtb() {
        return Rtb.Bigo;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String appId;
        String sid;
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        if (request.isOcpxRequest()) {
            sid = (String)queryParams.getFirst((Object)"click_id");
            appId = (String)queryParams.getFirst((Object)"sub_id");
        } else {
            sid = (String)queryParams.getFirst((Object)"sid");
            appId = (String)queryParams.getFirst((Object)"appId");
        }
        String idfa = (String)queryParams.getFirst((Object)"idfa");
        String gaid = (String)queryParams.getFirst((Object)"gaid");
        if (StringUtils.isBlank((String)sid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sid'.");
        }
        if (StringUtils.isBlank((String)appId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'appId'.");
        }
        if (StringUtils.isBlank((String)idfa) && StringUtils.isBlank((String)gaid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'idfa' or 'gaid'.");
        }
        BigoRequest vivoRequest = BigoRequest.builder().appKey(this.bigoConfig.getAppkey()).sid(sid).appId(appId).idfa(idfa).gaid(gaid).mappedIae(eventType).build();
        String entity = JsonHelper.convert((Object)vivoRequest);
        if (log.isInfoEnabled()) {
            log.info("\u3010bigo\u3011request body : {}", (Object)entity);
        }
        String url = this.getFeedbackUrl();
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        request.setRequestBody(entity);
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

