/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.bxm;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.bxm.BxmConfig;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.UrlHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class BxmRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(BxmRtbIntegration.class);
    public static final String CLICK_ID = "click_id";
    public static final String AD_GROUP_ID = "ad_group_id";
    private final Fetcher fetcher;

    public BxmRtbIntegration(BxmConfig config, Fetcher fetcher) {
        super(config);
        this.fetcher = fetcher;
    }

    @Override
    public Rtb rtb() {
        return Rtb.BXM;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        return (String)queryParams.getFirst((Object)AD_GROUP_ID);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String clickId = (String)queryParams.getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'click_id' by referrer.");
        }
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.INADS);
        map.setMt(Inads.Mt.AdConversion.original());
        map.putIfNotBlank("bxmid", clickId);
        map.putIfNotBlank("conversion_type", eventType);
        String bxmId = (String)keyValueMap.getFirst((Object)"bxmid");
        if (StringUtils.isNotBlank((String)bxmId)) {
            String phone = (String)this.fetcher.fetch(TicketKeyGenerator.strBxmIdPhone((String)bxmId), String.class);
            map.putIfNotBlank("phone_num", phone);
        }
        String uri = map.createOpenLogRequestUri(this.getFeedbackUrl());
        return new HttpGet(uri);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

