/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.bxmtest;

import com.bxm.adscounter.rtb.common.DataFetchFailException;
import com.bxm.adscounter.rtb.common.DataFetcher;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.data.Parameter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BxmTestDataFetcher
implements DataFetcher {
    private static final Logger log = LoggerFactory.getLogger(BxmTestDataFetcher.class);
    public final Fetcher fetcher;

    public BxmTestDataFetcher(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    private static String getToday() {
        return BxmTestDataFetcher.getToday(0L);
    }

    private static String getToday(long days) {
        return LocalDate.now().plusDays(days).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    private static String getHour(long hours) {
        return LocalDateTime.now().plusHours(hours).withMinute(0).format(DateTimeFormatter.ofPattern("HH"));
    }

    @Override
    public Rtb rtb() {
        return Rtb.BXM_TEST;
    }

    @Override
    public List<AdGroupData> fetchTodayData(Parameter parameter) throws DataFetchFailException {
        String today = BxmTestDataFetcher.getToday();
        return this.fetch0(parameter, today, null);
    }

    @Override
    public List<AdGroupData> fetchCurrentHourData(Parameter parameter) throws DataFetchFailException {
        String today = BxmTestDataFetcher.getToday();
        String hour = BxmTestDataFetcher.getHour(0L);
        return this.fetch0(parameter, today, hour);
    }

    @Override
    public List<AdGroupData> fetchPreviousHourData(Parameter parameter) throws DataFetchFailException {
        String today = LocalTime.now().getHour() == 0 ? BxmTestDataFetcher.getToday(-1L) : BxmTestDataFetcher.getToday();
        String hour = BxmTestDataFetcher.getHour(-1L);
        return this.fetch0(parameter, today, hour);
    }

    private List<AdGroupData> fetch0(Parameter parameter, String date, String hour) throws DataFetchFailException {
        String tagId = parameter.getTagId();
        String adGroupId = parameter.getAdGroupId();
        ArrayList fetchResult = Lists.newArrayList();
        for (int h = 0; h < 24; ++h) {
            hour = Objects.toString(h);
            if (StringUtils.isNotBlank((String)adGroupId)) {
                Obj fetch = (Obj)this.fetcher.hfetch(BxmTestDataFetcher.hash(tagId, hour), adGroupId, Obj.class);
                if (!Objects.nonNull(fetch)) continue;
                fetchResult.addAll(this.convert(Lists.newArrayList((Object[])new Obj[]{fetch})));
                continue;
            }
            Map hfetchall = this.fetcher.hfetchall(BxmTestDataFetcher.hash(parameter.getTagId(), hour), Obj.class);
            if (!MapUtils.isNotEmpty((Map)hfetchall)) continue;
            fetchResult.addAll(this.convert(new ArrayList<Obj>(hfetchall.values())));
        }
        return fetchResult;
    }

    private List<AdGroupData> convert(List<Obj> objs) {
        return objs.stream().map(obj -> new AdGroupData().setAdGroupId(obj.getAdGroupId()).setDate(obj.getDate()).setHour(obj.getHour()).setCharge(obj.getCharge()).setConvNumByImpression(obj.getConvNum().longValue())).collect(Collectors.toList());
    }

    static KeyGenerator hash(String positionId, String hour) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "hosting_test", positionId, DateHelper.format((String)"yyyyMMdd"), hour});
    }

    public static class Obj {
        private String positionId;
        private String adGroupId;
        private String date;
        private Integer hour;
        private BigDecimal income;
        private BigDecimal charge;
        private Integer convNum;

        public String getPositionId() {
            return this.positionId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getDate() {
            return this.date;
        }

        public Integer getHour() {
            return this.hour;
        }

        public BigDecimal getIncome() {
            return this.income;
        }

        public BigDecimal getCharge() {
            return this.charge;
        }

        public Integer getConvNum() {
            return this.convNum;
        }

        public void setPositionId(String positionId) {
            this.positionId = positionId;
        }

        public void setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public void setHour(Integer hour) {
            this.hour = hour;
        }

        public void setIncome(BigDecimal income) {
            this.income = income;
        }

        public void setCharge(BigDecimal charge) {
            this.charge = charge;
        }

        public void setConvNum(Integer convNum) {
            this.convNum = convNum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Obj)) {
                return false;
            }
            Obj other = (Obj)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$hour = this.getHour();
            Integer other$hour = other.getHour();
            if (this$hour == null ? other$hour != null : !((Object)this$hour).equals(other$hour)) {
                return false;
            }
            Integer this$convNum = this.getConvNum();
            Integer other$convNum = other.getConvNum();
            if (this$convNum == null ? other$convNum != null : !((Object)this$convNum).equals(other$convNum)) {
                return false;
            }
            String this$positionId = this.getPositionId();
            String other$positionId = other.getPositionId();
            if (this$positionId == null ? other$positionId != null : !this$positionId.equals(other$positionId)) {
                return false;
            }
            String this$adGroupId = this.getAdGroupId();
            String other$adGroupId = other.getAdGroupId();
            if (this$adGroupId == null ? other$adGroupId != null : !this$adGroupId.equals(other$adGroupId)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                return false;
            }
            BigDecimal this$income = this.getIncome();
            BigDecimal other$income = other.getIncome();
            if (this$income == null ? other$income != null : !((Object)this$income).equals(other$income)) {
                return false;
            }
            BigDecimal this$charge = this.getCharge();
            BigDecimal other$charge = other.getCharge();
            return !(this$charge == null ? other$charge != null : !((Object)this$charge).equals(other$charge));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Obj;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $hour = this.getHour();
            result = result * 59 + ($hour == null ? 43 : ((Object)$hour).hashCode());
            Integer $convNum = this.getConvNum();
            result = result * 59 + ($convNum == null ? 43 : ((Object)$convNum).hashCode());
            String $positionId = this.getPositionId();
            result = result * 59 + ($positionId == null ? 43 : $positionId.hashCode());
            String $adGroupId = this.getAdGroupId();
            result = result * 59 + ($adGroupId == null ? 43 : $adGroupId.hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            BigDecimal $income = this.getIncome();
            result = result * 59 + ($income == null ? 43 : ((Object)$income).hashCode());
            BigDecimal $charge = this.getCharge();
            result = result * 59 + ($charge == null ? 43 : ((Object)$charge).hashCode());
            return result;
        }

        public String toString() {
            return "BxmTestDataFetcher.Obj(positionId=" + this.getPositionId() + ", adGroupId=" + this.getAdGroupId() + ", date=" + this.getDate() + ", hour=" + this.getHour() + ", income=" + this.getIncome() + ", charge=" + this.getCharge() + ", convNum=" + this.getConvNum() + ")";
        }
    }
}

