/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.bxmtest;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.bxmtest.BxmTestConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class BxmTestRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(BxmTestRtbIntegration.class);
    public static final String CLICK_ID = "click_id";
    public static final String AD_GROUP_ID = "ad_group_id";

    public BxmTestRtbIntegration(BxmTestConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.BXM_TEST;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        return (String)queryParams.getFirst((Object)AD_GROUP_ID);
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String clickid = (String)queryParams.getFirst((Object)this.getClickIdParameterNameOnReferrer());
        if (StringUtils.isBlank((String)clickid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'click_id' by referrer.");
        }
        HashMap params = Maps.newHashMap();
        params.put("clickid", clickid);
        params.put("eventType", eventType);
        params.put("convTime", System.currentTimeMillis());
        String feedbackUrl = this.getFeedbackUrl();
        feedbackUrl = OkHttpUtils.appendParams((String)feedbackUrl, (Map)params);
        return new HttpGet(feedbackUrl);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        BxmResponse response = (BxmResponse)JsonHelper.convert((String)body, BxmResponse.class);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        if (Objects.nonNull(response) && response.isSuccess()) {
            feedbackResponse.setSuccess(true);
            feedbackResponse.setBody(response.getMessage());
        } else {
            feedbackResponse.setSuccess(false);
        }
        return feedbackResponse;
    }

    private static class BxmResponse {
        private Integer code;
        private String message;

        public boolean isSuccess() {
            return Objects.equals(0, this.code);
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BxmResponse)) {
                return false;
            }
            BxmResponse other = (BxmResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BxmResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "BxmTestRtbIntegration.BxmResponse(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
        }
    }
}

