/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.facaishu;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.facaishu.FacaishuConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class FacaishuRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(FacaishuRtbIntegration.class);
    public static final String CLICK_ID = "click_id";

    public FacaishuRtbIntegration(FacaishuConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.FACAISHU;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        return (String)keyValueMap.getFirst((Object)"tagid");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String clickId = (String)UriComponentsBuilder.fromUriString((String)request.getReferrer()).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'click_id' by referrer.");
        }
        Request facaishuRequest = new Request().setClickId(clickId);
        HttpPost post = new HttpPost(this.getFeedbackUrl());
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)facaishuRequest), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Response
    extends FeedbackResponse {
        private Boolean success;
        private String code;
        private String msg;

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"1", (String)this.code);
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public String getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$success = this.getSuccess();
            Boolean other$success = other.getSuccess();
            if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $success = this.getSuccess();
            result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "FacaishuRtbIntegration.Response(success=" + this.getSuccess() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
        }
    }

    public static class Request {
        private String clickId;

        public String getClickId() {
            return this.clickId;
        }

        public Request setClickId(String clickId) {
            this.clickId = clickId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clickId = this.getClickId();
            String other$clickId = other.getClickId();
            return !(this$clickId == null ? other$clickId != null : !this$clickId.equals(other$clickId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clickId = this.getClickId();
            result = result * 59 + ($clickId == null ? 43 : $clickId.hashCode());
            return result;
        }

        public String toString() {
            return "FacaishuRtbIntegration.Request(clickId=" + this.getClickId() + ")";
        }
    }
}

