/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.hiv;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.hiv.HivConfig;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class HivRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    public HivRtbIntegration(HivConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.HIV;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String clickId = request.getClickId();
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickId'.");
        }
        HashMap params = Maps.newHashMap();
        params.put("transaction_id", clickId);
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(StringUtils.isNotBlank((String)body) && Objects.equals("success", body));
        return feedbackResponse;
    }
}

