/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.huawei;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.huawei.HuaweiConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.base.Charsets;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class HuaweiRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(HuaweiRtbIntegration.class);
    public static final String CLICK_ID = "callback";
    public static final String AD_GROUP_ID = "adgroup_id";

    public HuaweiRtbIntegration(HuaweiConfig config) {
        super(config, (HttpClient)HuaweiRtbIntegration.createHttpClient());
    }

    @Override
    public Rtb rtb() {
        return Rtb.HUAWEI;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        return (String)queryParams.getFirst((Object)AD_GROUP_ID);
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String eventType = request.getEventType();
        PositionRtb positionRtb = request.getConfig();
        String secretKey = positionRtb.getToken();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)request.getReferrer()).build().getQueryParams();
        String oaid = (String)queryParams.getFirst((Object)"oaid");
        String content_id = (String)queryParams.getFirst((Object)"content_id");
        String campaign_id = (String)queryParams.getFirst((Object)"campaign_id");
        String callback = (String)queryParams.getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)secretKey)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot find 'secretKey'.");
        }
        if (StringUtils.isBlank((String)content_id)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot find 'content_id'");
        }
        if (StringUtils.isBlank((String)campaign_id)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot find 'campaign_id'");
        }
        if (StringUtils.isBlank((String)eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot find 'eventType'.");
        }
        if (StringUtils.isBlank((String)callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot find 'callback'.");
        }
        callback = UrlHelper.urlEncode((String)UrlHelper.urlDecode((String)UrlHelper.urlDecode((String)callback)));
        HuaweiRequest huaweiRequest = HuaweiRequest.builder().callback(callback).oaid(oaid).conversion_type(eventType).content_id(content_id).campaign_id(campaign_id).conversion_time(Objects.toString(System.currentTimeMillis() / 1000L)).timestamp(Objects.toString(System.currentTimeMillis())).build();
        String entity = JsonHelper.convert((Object)huaweiRequest);
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.addHeader("Authorization", HuaweiRtbIntegration.buildAuthorizationHeader(entity, secretKey));
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        Response response = (Response)JsonHelper.convert((String)body, Response.class);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        if (Objects.nonNull(response)) {
            feedbackResponse.setSuccess(response.isSuccess());
            feedbackResponse.setBody(response.getResultMessage());
        } else {
            feedbackResponse.setSuccess(false);
        }
        return feedbackResponse;
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectionRequestTimeout(1000).setConnectTimeout(1000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    public static String buildAuthorizationHeader(String body, String key) {
        String authorizationFormat = "Digest validTime=\"{0}\", response=\"{1}\"";
        String authorization = null;
        try {
            byte[] keyBytes = key.getBytes(Charsets.UTF_8);
            byte[] bodyBytes = body.getBytes(Charsets.UTF_8);
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "HmacSHA256");
            mac.init(secretKey);
            byte[] signatureBytes = mac.doFinal(bodyBytes);
            String timestamp = String.valueOf(System.currentTimeMillis());
            String signature = signatureBytes == null ? null : Hex.encodeHexString((byte[])signatureBytes);
            authorization = MessageFormat.format("Digest validTime=\"{0}\", response=\"{1}\"", timestamp, signature);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return authorization;
    }

    public static class Response {
        private Integer resultCode;
        private String resultMessage;

        public boolean isSuccess() {
            return Objects.equals(this.resultCode, 0);
        }

        public Integer getResultCode() {
            return this.resultCode;
        }

        public String getResultMessage() {
            return this.resultMessage;
        }

        public void setResultCode(Integer resultCode) {
            this.resultCode = resultCode;
        }

        public void setResultMessage(String resultMessage) {
            this.resultMessage = resultMessage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$resultCode = this.getResultCode();
            Integer other$resultCode = other.getResultCode();
            if (this$resultCode == null ? other$resultCode != null : !((Object)this$resultCode).equals(other$resultCode)) {
                return false;
            }
            String this$resultMessage = this.getResultMessage();
            String other$resultMessage = other.getResultMessage();
            return !(this$resultMessage == null ? other$resultMessage != null : !this$resultMessage.equals(other$resultMessage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $resultCode = this.getResultCode();
            result = result * 59 + ($resultCode == null ? 43 : ((Object)$resultCode).hashCode());
            String $resultMessage = this.getResultMessage();
            result = result * 59 + ($resultMessage == null ? 43 : $resultMessage.hashCode());
            return result;
        }

        public String toString() {
            return "HuaweiRtbIntegration.Response(resultCode=" + this.getResultCode() + ", resultMessage=" + this.getResultMessage() + ")";
        }
    }

    public static class HuaweiRequest {
        private String oaid;
        private String conversion_type;
        private String content_id;
        private String callback;
        private String campaign_id;
        private String timestamp;
        private String conversion_time;

        public static HuaweiRequestBuilder builder() {
            return new HuaweiRequestBuilder();
        }

        public String getOaid() {
            return this.oaid;
        }

        public String getConversion_type() {
            return this.conversion_type;
        }

        public String getContent_id() {
            return this.content_id;
        }

        public String getCallback() {
            return this.callback;
        }

        public String getCampaign_id() {
            return this.campaign_id;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getConversion_time() {
            return this.conversion_time;
        }

        public void setOaid(String oaid) {
            this.oaid = oaid;
        }

        public void setConversion_type(String conversion_type) {
            this.conversion_type = conversion_type;
        }

        public void setContent_id(String content_id) {
            this.content_id = content_id;
        }

        public void setCallback(String callback) {
            this.callback = callback;
        }

        public void setCampaign_id(String campaign_id) {
            this.campaign_id = campaign_id;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public void setConversion_time(String conversion_time) {
            this.conversion_time = conversion_time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HuaweiRequest)) {
                return false;
            }
            HuaweiRequest other = (HuaweiRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$oaid = this.getOaid();
            String other$oaid = other.getOaid();
            if (this$oaid == null ? other$oaid != null : !this$oaid.equals(other$oaid)) {
                return false;
            }
            String this$conversion_type = this.getConversion_type();
            String other$conversion_type = other.getConversion_type();
            if (this$conversion_type == null ? other$conversion_type != null : !this$conversion_type.equals(other$conversion_type)) {
                return false;
            }
            String this$content_id = this.getContent_id();
            String other$content_id = other.getContent_id();
            if (this$content_id == null ? other$content_id != null : !this$content_id.equals(other$content_id)) {
                return false;
            }
            String this$callback = this.getCallback();
            String other$callback = other.getCallback();
            if (this$callback == null ? other$callback != null : !this$callback.equals(other$callback)) {
                return false;
            }
            String this$campaign_id = this.getCampaign_id();
            String other$campaign_id = other.getCampaign_id();
            if (this$campaign_id == null ? other$campaign_id != null : !this$campaign_id.equals(other$campaign_id)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                return false;
            }
            String this$conversion_time = this.getConversion_time();
            String other$conversion_time = other.getConversion_time();
            return !(this$conversion_time == null ? other$conversion_time != null : !this$conversion_time.equals(other$conversion_time));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HuaweiRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $oaid = this.getOaid();
            result = result * 59 + ($oaid == null ? 43 : $oaid.hashCode());
            String $conversion_type = this.getConversion_type();
            result = result * 59 + ($conversion_type == null ? 43 : $conversion_type.hashCode());
            String $content_id = this.getContent_id();
            result = result * 59 + ($content_id == null ? 43 : $content_id.hashCode());
            String $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            String $campaign_id = this.getCampaign_id();
            result = result * 59 + ($campaign_id == null ? 43 : $campaign_id.hashCode());
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            String $conversion_time = this.getConversion_time();
            result = result * 59 + ($conversion_time == null ? 43 : $conversion_time.hashCode());
            return result;
        }

        public String toString() {
            return "HuaweiRtbIntegration.HuaweiRequest(oaid=" + this.getOaid() + ", conversion_type=" + this.getConversion_type() + ", content_id=" + this.getContent_id() + ", callback=" + this.getCallback() + ", campaign_id=" + this.getCampaign_id() + ", timestamp=" + this.getTimestamp() + ", conversion_time=" + this.getConversion_time() + ")";
        }

        public HuaweiRequest(String oaid, String conversion_type, String content_id, String callback, String campaign_id, String timestamp, String conversion_time) {
            this.oaid = oaid;
            this.conversion_type = conversion_type;
            this.content_id = content_id;
            this.callback = callback;
            this.campaign_id = campaign_id;
            this.timestamp = timestamp;
            this.conversion_time = conversion_time;
        }

        public static class HuaweiRequestBuilder {
            private String oaid;
            private String conversion_type;
            private String content_id;
            private String callback;
            private String campaign_id;
            private String timestamp;
            private String conversion_time;

            HuaweiRequestBuilder() {
            }

            public HuaweiRequestBuilder oaid(String oaid) {
                this.oaid = oaid;
                return this;
            }

            public HuaweiRequestBuilder conversion_type(String conversion_type) {
                this.conversion_type = conversion_type;
                return this;
            }

            public HuaweiRequestBuilder content_id(String content_id) {
                this.content_id = content_id;
                return this;
            }

            public HuaweiRequestBuilder callback(String callback) {
                this.callback = callback;
                return this;
            }

            public HuaweiRequestBuilder campaign_id(String campaign_id) {
                this.campaign_id = campaign_id;
                return this;
            }

            public HuaweiRequestBuilder timestamp(String timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public HuaweiRequestBuilder conversion_time(String conversion_time) {
                this.conversion_time = conversion_time;
                return this;
            }

            public HuaweiRequest build() {
                return new HuaweiRequest(this.oaid, this.conversion_type, this.content_id, this.callback, this.campaign_id, this.timestamp, this.conversion_time);
            }

            public String toString() {
                return "HuaweiRtbIntegration.HuaweiRequest.HuaweiRequestBuilder(oaid=" + this.oaid + ", conversion_type=" + this.conversion_type + ", content_id=" + this.content_id + ", callback=" + this.callback + ", campaign_id=" + this.campaign_id + ", timestamp=" + this.timestamp + ", conversion_time=" + this.conversion_time + ")";
            }
        }
    }
}

