/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.ifeng;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.ifeng.IfengConfig;
import com.bxm.adscounter.rtb.common.impl.youku.MapStrUtil;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.id.random.RandomIdGenerator;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.crypto.AesCipher;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class IfengRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(IfengRtbIntegration.class);
    public static final String CLICK_ID = "clickSign";
    public static final String AD_GROUP_ID = "adId";

    public IfengRtbIntegration(IfengConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.IFENG;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        return (String)queryParams.getFirst((Object)AD_GROUP_ID);
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String encryptParamStr;
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        PositionRtb config = request.getConfig();
        String customerId = config.getCustomerId();
        String secretKey = config.getToken();
        String convertId = config.getSourceId();
        if (StringUtils.isBlank((String)customerId) || StringUtils.isBlank((String)secretKey) || StringUtils.isBlank((String)convertId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'customerId' or 'token' or 'sourceId' by PositionRtb Config.");
        }
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String clickSign = (String)queryParams.getFirst((Object)CLICK_ID);
        String adId = (String)queryParams.getFirst((Object)AD_GROUP_ID);
        String creativeId = (String)queryParams.getFirst((Object)"creativeId");
        if (StringUtils.isBlank((String)clickSign)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickSign' by referrer.");
        }
        if (StringUtils.isBlank((String)adId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'adId' by referrer.");
        }
        if (StringUtils.isBlank((String)creativeId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'creativeId' by referrer.");
        }
        String orderId = new RandomIdGenerator().next();
        LinkedHashMap signParams = Maps.newLinkedHashMap();
        signParams.put("orderId", orderId);
        signParams.put(CLICK_ID, clickSign);
        signParams.put("customerId", customerId);
        signParams.put("convertType", eventType);
        signParams.put(AD_GROUP_ID, adId);
        signParams.put("creativeId", creativeId);
        String signParamStr = MapStrUtil.toStr(signParams);
        try {
            byte[] encrypt = AesCipher.encrypt((byte[])secretKey.getBytes(), (byte[])signParamStr.getBytes());
            encryptParamStr = Base64.encodeBase64String((byte[])encrypt);
            encryptParamStr = StringUtils.replace((String)encryptParamStr, (String)"/", (String)"_");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RtbIntegrationException(FailType.IllegalParameter, "Occur error in AES encrypt.");
        }
        HashMap params = Maps.newHashMap();
        params.put("args", encryptParamStr);
        params.put("convertId", convertId);
        String feedbackUrl = this.getFeedbackUrl();
        if (log.isInfoEnabled()) {
            log.info("[{}] - ifeng paramsStr: {} | secretKey: {}", new Object[]{orderId, signParamStr, secretKey});
        }
        feedbackUrl = OkHttpUtils.appendParams((String)feedbackUrl, (Map)params);
        return new HttpGet(feedbackUrl);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

