/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.jparking;

import cn.hutool.crypto.SmUtil;
import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.jparking.JparkingConfig;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class JparkingRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(JparkingRtbIntegration.class);
    public static final String CLICK_ID = "jtcAdRequestId";
    private final Fetcher fetcher;
    private final JparkingConfig config;

    public JparkingRtbIntegration(JparkingConfig config, Fetcher fetcher) {
        super(config);
        this.fetcher = fetcher;
        this.config = config;
    }

    @Override
    public Rtb rtb() {
        return Rtb.JPARKING;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        return (String)keyValueMap.getFirst((Object)"tagid");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        PositionRtb positionRtb = request.getConfig();
        String jtcCoupons = positionRtb.getSourceId();
        if (StringUtils.isBlank((String)jtcCoupons)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'jtcCoupons' by config");
        }
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String clickId = (String)UriComponentsBuilder.fromUriString((String)request.getReferrer()).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'click_id' by referrer.");
        }
        String phone = this.getPhone(keyValueMap);
        if (StringUtils.isBlank((String)phone) && log.isInfoEnabled()) {
            log.info("\u3010jparking\u3011Cannot found phone by bxmId {}", keyValueMap.getFirst((Object)"bxmid"));
        }
        String carNo = "0";
        JparkingRequest jparkingRequest = new JparkingRequest().setAppId(this.config.getAppId()).setMethod("syt.ad.dsp.cpa.convert").setTimestamp(System.currentTimeMillis()).setCharset("utf-8").setFormat("json").setAbilityCode("dsp.ad.service").setSign(this.getSign(clickId, phone, carNo, jtcCoupons)).setBizContent(new JparkingRequest.BizContent().setJtcAdRequestId(clickId).setJtcCoupons(jtcCoupons).setCarNo(carNo).setPhone(phone));
        HttpPost post = new HttpPost(this.getFeedbackUrl());
        String json = JsonHelper.convert((Object)jparkingRequest);
        log.info("jparking req : {}", (Object)json);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
        return post;
    }

    private String getPhone(KeyValueMap keyValueMap) {
        String phone = (String)keyValueMap.getFirst((Object)"phone_num");
        if (StringUtils.isNotBlank((String)phone)) {
            log.info("get phone from keyValueMap :{}", (Object)phone);
            return phone;
        }
        String bxmId = (String)keyValueMap.getFirst((Object)"bxmid");
        if (StringUtils.isNotBlank((String)bxmId)) {
            return (String)this.fetcher.fetch(TicketKeyGenerator.strBxmIdPhone((String)bxmId), String.class);
        }
        return null;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private String getSign(String jtcAdRequestId, String phone, String carNo, String jtcCoupons) {
        String s = "";
        if (StringUtils.isNotBlank((String)carNo)) {
            s = s + "carNo=" + carNo + "&";
        }
        s = s + "jtcAdRequestId=" + jtcAdRequestId + "&";
        if (StringUtils.isNotBlank((String)jtcCoupons)) {
            s = s + "jtcCoupons=" + jtcCoupons + "&";
        }
        if (StringUtils.isNotBlank((String)phone)) {
            s = s + "phone=" + phone + "&";
        }
        s = s + "key=" + this.config.getSecret();
        String sign = SmUtil.sm3((String)s);
        log.info("jparking sign {} - {}", (Object)sign, (Object)s);
        return sign;
    }

    public static void main(String[] args) {
        ArrayList strings = Lists.newArrayList((Object[])new String[]{CLICK_ID, "carNo", "jtcCoupons", "phone"});
        Collections.sort(strings);
        System.out.println(strings);
    }

    private static class Response
    extends FeedbackResponse {
        private String request_id;
        private String code;
        private String msg;
        private String sub_code;
        private String sub_msg;

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"10000", (String)this.code);
        }

        public String getRequest_id() {
            return this.request_id;
        }

        public String getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getSub_code() {
            return this.sub_code;
        }

        public String getSub_msg() {
            return this.sub_msg;
        }

        public void setRequest_id(String request_id) {
            this.request_id = request_id;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setSub_code(String sub_code) {
            this.sub_code = sub_code;
        }

        public void setSub_msg(String sub_msg) {
            this.sub_msg = sub_msg;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$request_id = this.getRequest_id();
            String other$request_id = other.getRequest_id();
            if (this$request_id == null ? other$request_id != null : !this$request_id.equals(other$request_id)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            String this$sub_code = this.getSub_code();
            String other$sub_code = other.getSub_code();
            if (this$sub_code == null ? other$sub_code != null : !this$sub_code.equals(other$sub_code)) {
                return false;
            }
            String this$sub_msg = this.getSub_msg();
            String other$sub_msg = other.getSub_msg();
            return !(this$sub_msg == null ? other$sub_msg != null : !this$sub_msg.equals(other$sub_msg));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $request_id = this.getRequest_id();
            result = result * 59 + ($request_id == null ? 43 : $request_id.hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            String $sub_code = this.getSub_code();
            result = result * 59 + ($sub_code == null ? 43 : $sub_code.hashCode());
            String $sub_msg = this.getSub_msg();
            result = result * 59 + ($sub_msg == null ? 43 : $sub_msg.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "JparkingRtbIntegration.Response(request_id=" + this.getRequest_id() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", sub_code=" + this.getSub_code() + ", sub_msg=" + this.getSub_msg() + ")";
        }
    }

    public static class JparkingRequest {
        @JSONField(name="app_id")
        private Long appId;
        private String method;
        private Long timestamp;
        private String charset;
        private String format;
        private String abilityCode;
        private String sign;
        @JSONField(name="biz_content")
        private BizContent bizContent;

        public Long getAppId() {
            return this.appId;
        }

        public String getMethod() {
            return this.method;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public String getCharset() {
            return this.charset;
        }

        public String getFormat() {
            return this.format;
        }

        public String getAbilityCode() {
            return this.abilityCode;
        }

        public String getSign() {
            return this.sign;
        }

        public BizContent getBizContent() {
            return this.bizContent;
        }

        public JparkingRequest setAppId(Long appId) {
            this.appId = appId;
            return this;
        }

        public JparkingRequest setMethod(String method) {
            this.method = method;
            return this;
        }

        public JparkingRequest setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public JparkingRequest setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public JparkingRequest setFormat(String format) {
            this.format = format;
            return this;
        }

        public JparkingRequest setAbilityCode(String abilityCode) {
            this.abilityCode = abilityCode;
            return this;
        }

        public JparkingRequest setSign(String sign) {
            this.sign = sign;
            return this;
        }

        public JparkingRequest setBizContent(BizContent bizContent) {
            this.bizContent = bizContent;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JparkingRequest)) {
                return false;
            }
            JparkingRequest other = (JparkingRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$appId = this.getAppId();
            Long other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
                return false;
            }
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$charset = this.getCharset();
            String other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            String this$abilityCode = this.getAbilityCode();
            String other$abilityCode = other.getAbilityCode();
            if (this$abilityCode == null ? other$abilityCode != null : !this$abilityCode.equals(other$abilityCode)) {
                return false;
            }
            String this$sign = this.getSign();
            String other$sign = other.getSign();
            if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
                return false;
            }
            BizContent this$bizContent = this.getBizContent();
            BizContent other$bizContent = other.getBizContent();
            return !(this$bizContent == null ? other$bizContent != null : !((Object)this$bizContent).equals(other$bizContent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JparkingRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            String $abilityCode = this.getAbilityCode();
            result = result * 59 + ($abilityCode == null ? 43 : $abilityCode.hashCode());
            String $sign = this.getSign();
            result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
            BizContent $bizContent = this.getBizContent();
            result = result * 59 + ($bizContent == null ? 43 : ((Object)$bizContent).hashCode());
            return result;
        }

        public String toString() {
            return "JparkingRtbIntegration.JparkingRequest(appId=" + this.getAppId() + ", method=" + this.getMethod() + ", timestamp=" + this.getTimestamp() + ", charset=" + this.getCharset() + ", format=" + this.getFormat() + ", abilityCode=" + this.getAbilityCode() + ", sign=" + this.getSign() + ", bizContent=" + this.getBizContent() + ")";
        }

        public static class BizContent {
            private String jtcAdRequestId;
            private String jtcCoupons;
            private String phone;
            private String carNo;

            public String getJtcAdRequestId() {
                return this.jtcAdRequestId;
            }

            public String getJtcCoupons() {
                return this.jtcCoupons;
            }

            public String getPhone() {
                return this.phone;
            }

            public String getCarNo() {
                return this.carNo;
            }

            public BizContent setJtcAdRequestId(String jtcAdRequestId) {
                this.jtcAdRequestId = jtcAdRequestId;
                return this;
            }

            public BizContent setJtcCoupons(String jtcCoupons) {
                this.jtcCoupons = jtcCoupons;
                return this;
            }

            public BizContent setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public BizContent setCarNo(String carNo) {
                this.carNo = carNo;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BizContent)) {
                    return false;
                }
                BizContent other = (BizContent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$jtcAdRequestId = this.getJtcAdRequestId();
                String other$jtcAdRequestId = other.getJtcAdRequestId();
                if (this$jtcAdRequestId == null ? other$jtcAdRequestId != null : !this$jtcAdRequestId.equals(other$jtcAdRequestId)) {
                    return false;
                }
                String this$jtcCoupons = this.getJtcCoupons();
                String other$jtcCoupons = other.getJtcCoupons();
                if (this$jtcCoupons == null ? other$jtcCoupons != null : !this$jtcCoupons.equals(other$jtcCoupons)) {
                    return false;
                }
                String this$phone = this.getPhone();
                String other$phone = other.getPhone();
                if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                    return false;
                }
                String this$carNo = this.getCarNo();
                String other$carNo = other.getCarNo();
                return !(this$carNo == null ? other$carNo != null : !this$carNo.equals(other$carNo));
            }

            protected boolean canEqual(Object other) {
                return other instanceof BizContent;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $jtcAdRequestId = this.getJtcAdRequestId();
                result = result * 59 + ($jtcAdRequestId == null ? 43 : $jtcAdRequestId.hashCode());
                String $jtcCoupons = this.getJtcCoupons();
                result = result * 59 + ($jtcCoupons == null ? 43 : $jtcCoupons.hashCode());
                String $phone = this.getPhone();
                result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                String $carNo = this.getCarNo();
                result = result * 59 + ($carNo == null ? 43 : $carNo.hashCode());
                return result;
            }

            public String toString() {
                return "JparkingRtbIntegration.JparkingRequest.BizContent(jtcAdRequestId=" + this.getJtcAdRequestId() + ", jtcCoupons=" + this.getJtcCoupons() + ", phone=" + this.getPhone() + ", carNo=" + this.getCarNo() + ")";
            }
        }
    }
}

