/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.juliang;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.juliang.OceanEngineConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class OceanEngineRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(OceanEngineRtbIntegration.class);
    public static final String CLICK_ID = "clickid";
    public static final String AD_GROUP_ID = "adid";

    public OceanEngineRtbIntegration(OceanEngineConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String clickId = this.getClickIdOnInadsAdClickLog(request.getKeyValueMap());
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String callBack = request.getClickId();
        if (StringUtils.isBlank((String)callBack)) {
            callBack = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        }
        if (StringUtils.isBlank((String)callBack)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickid' by referrer.");
        }
        AD ad = new AD().setCallback(callBack);
        Context context = new Context().setAd(ad);
        OceanEngineRequest oceanEngineRequest = new OceanEngineRequest().setEvent_type(eventType).setTimestamp(System.currentTimeMillis()).setContext(context);
        this.fillMeituanOcpsParam(oceanEngineRequest, keyValueMap);
        String entity = JsonHelper.convert((Object)oceanEngineRequest);
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        request.setRequestBody(entity);
        return post;
    }

    private void fillMeituanOcpsParam(OceanEngineRequest oceanEngineRequest, KeyValueMap keyValueMap) {
        Properties properties = new Properties();
        if (keyValueMap.containsKey((Object)"order_cnt")) {
            properties.setOrder_cnt((String)keyValueMap.getFirst((Object)"direct"));
        }
        if (keyValueMap.containsKey((Object)"pay_amount")) {
            properties.setPay_amount((String)keyValueMap.getFirst((Object)"quantity"));
        }
        if (properties.isNotEmpty()) {
            log.info("OceanEngine meituan order_cnt: {}", (Object)JSONObject.toJSONString((Object)properties));
            oceanEngineRequest.setProperties(properties);
        }
    }

    @Override
    public Rtb rtb() {
        return Rtb.JuLiangYinQing;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Properties {
        private String pay_amount;
        private String order_cnt;

        public boolean isNotEmpty() {
            return StringUtils.isNotBlank((String)this.pay_amount) || StringUtils.isNotBlank((String)this.order_cnt);
        }

        public String getPay_amount() {
            return this.pay_amount;
        }

        public String getOrder_cnt() {
            return this.order_cnt;
        }

        public Properties setPay_amount(String pay_amount) {
            this.pay_amount = pay_amount;
            return this;
        }

        public Properties setOrder_cnt(String order_cnt) {
            this.order_cnt = order_cnt;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties other = (Properties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$pay_amount = this.getPay_amount();
            String other$pay_amount = other.getPay_amount();
            if (this$pay_amount == null ? other$pay_amount != null : !this$pay_amount.equals(other$pay_amount)) {
                return false;
            }
            String this$order_cnt = this.getOrder_cnt();
            String other$order_cnt = other.getOrder_cnt();
            return !(this$order_cnt == null ? other$order_cnt != null : !this$order_cnt.equals(other$order_cnt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Properties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $pay_amount = this.getPay_amount();
            result = result * 59 + ($pay_amount == null ? 43 : $pay_amount.hashCode());
            String $order_cnt = this.getOrder_cnt();
            result = result * 59 + ($order_cnt == null ? 43 : $order_cnt.hashCode());
            return result;
        }

        public String toString() {
            return "OceanEngineRtbIntegration.Properties(pay_amount=" + this.getPay_amount() + ", order_cnt=" + this.getOrder_cnt() + ")";
        }
    }

    private static class OceanEngineRequest {
        private String event_type;
        private Context context;
        private Properties properties;
        private Long timestamp;

        public String getEvent_type() {
            return this.event_type;
        }

        public Context getContext() {
            return this.context;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public OceanEngineRequest setEvent_type(String event_type) {
            this.event_type = event_type;
            return this;
        }

        public OceanEngineRequest setContext(Context context) {
            this.context = context;
            return this;
        }

        public OceanEngineRequest setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public OceanEngineRequest setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OceanEngineRequest)) {
                return false;
            }
            OceanEngineRequest other = (OceanEngineRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$event_type = this.getEvent_type();
            String other$event_type = other.getEvent_type();
            if (this$event_type == null ? other$event_type != null : !this$event_type.equals(other$event_type)) {
                return false;
            }
            Context this$context = this.getContext();
            Context other$context = other.getContext();
            if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
                return false;
            }
            Properties this$properties = this.getProperties();
            Properties other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OceanEngineRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $event_type = this.getEvent_type();
            result = result * 59 + ($event_type == null ? 43 : $event_type.hashCode());
            Context $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
            Properties $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        public String toString() {
            return "OceanEngineRtbIntegration.OceanEngineRequest(event_type=" + this.getEvent_type() + ", context=" + this.getContext() + ", properties=" + this.getProperties() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }

    private static class Context {
        private AD ad;

        public AD getAd() {
            return this.ad;
        }

        public Context setAd(AD ad) {
            this.ad = ad;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AD this$ad = this.getAd();
            AD other$ad = other.getAd();
            return !(this$ad == null ? other$ad != null : !((Object)this$ad).equals(other$ad));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AD $ad = this.getAd();
            result = result * 59 + ($ad == null ? 43 : ((Object)$ad).hashCode());
            return result;
        }

        public String toString() {
            return "OceanEngineRtbIntegration.Context(ad=" + this.getAd() + ")";
        }
    }

    private static class AD {
        private String callback;

        public String getCallback() {
            return this.callback;
        }

        public AD setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AD)) {
                return false;
            }
            AD other = (AD)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$callback = this.getCallback();
            String other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AD;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }

        public String toString() {
            return "OceanEngineRtbIntegration.AD(callback=" + this.getCallback() + ")";
        }
    }

    private static class Response
    extends FeedbackResponse {
        private String code;
        private String message;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"0", (String)this.code);
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

