/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.kuaikan;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class KuaiKanRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    public KuaiKanRtbIntegration(RtbConfig config) {
        super(config);
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "callback";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.config.getUrl();
        String referrer = request.getReferrer();
        String clickIdParameterNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        String callback = UrlHelper.getFirstValueOfParamName((String)referrer, (String)clickIdParameterNameOnReferrer);
        String convTime = Objects.toString(System.currentTimeMillis() / 1000L);
        String convType = request.getEventType();
        TreeMap param = Maps.newTreeMap();
        param.put("callback", callback);
        param.put("convTime", convTime);
        param.put("convType", convType);
        String queryString = this.rawQueryString(param);
        String sign = DigestUtils.md5Hex((String)(queryString + request.getConfig().getToken()));
        param.put("sign", sign);
        param.put("callback", UrlHelper.urlEncode((String)callback));
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        param.forEach((arg_0, arg_1) -> ((LinkedMultiValueMap)map).add(arg_0, arg_1));
        String finalUrl = UriComponentsBuilder.fromUriString((String)url).queryParams((MultiValueMap)map).build().toString();
        return new HttpGet(finalUrl);
    }

    private String rawQueryString(Map<String, String> param) {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, String> entry : param.entrySet()) {
            str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return StringUtils.removeEnd((String)str.toString(), (String)"&");
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        JSONObject object = JSONObject.parseObject((String)body);
        String code = object.getString("code");
        FeedbackResponse response = new FeedbackResponse();
        response.setSuccess(StringUtils.equals((String)"200", (String)code));
        response.setBody(body);
        return response;
    }

    @Override
    public Rtb rtb() {
        return Rtb.KuaiKan;
    }
}

