/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.kuaishou;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.DataFetchFailException;
import com.bxm.adscounter.rtb.common.DataFetcher;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.data.Parameter;
import com.bxm.adscounter.rtb.common.impl.kuaishou.AccountBindCache;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouAk;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouConfig;
import com.bxm.adscounter.rtb.common.utils.HttpClientUtils;
import com.bxm.adsmanager.facade.model.base.Money;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class KuaishouDataFetcher
implements DataFetcher {
    private static final Logger log = LoggerFactory.getLogger(KuaishouDataFetcher.class);
    private final KuaishouConfig config;
    private final JedisPool jedisPool;
    private final HttpClient httpClient;
    private final Fetcher fetcher;

    public KuaishouDataFetcher(KuaishouConfig config, JedisPool jedisPool, Fetcher fetcher) {
        this.config = config;
        this.httpClient = KuaishouDataFetcher.createHttpClient();
        this.jedisPool = jedisPool;
        this.fetcher = fetcher;
    }

    public static HttpClient createHttpClient() {
        return HttpClientUtils.createHttpClient(8, 16, 1500, 1500, 5000);
    }

    private static String getToday() {
        return KuaishouDataFetcher.getToday(0L);
    }

    private static String getToday(long days) {
        return LocalDate.now().plusDays(days).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    private static String getHour(long hours) {
        return LocalDateTime.now().plusHours(hours).withMinute(0).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
    }

    @Override
    public Rtb rtb() {
        return Rtb.Kuaishou;
    }

    @Override
    public List<AdGroupData> fetchCurrentHourData(Parameter parameter) throws DataFetchFailException {
        String today = KuaishouDataFetcher.getToday();
        String start = KuaishouDataFetcher.getHour(0L);
        String end = KuaishouDataFetcher.getHour(1L);
        return this.fetch0(parameter, today, start, end);
    }

    @Override
    public List<AdGroupData> fetchPreviousHourData(Parameter parameter) throws DataFetchFailException {
        String today = LocalTime.now().getHour() == 0 ? KuaishouDataFetcher.getToday(-1L) : KuaishouDataFetcher.getToday();
        String start = KuaishouDataFetcher.getHour(-1L);
        String end = KuaishouDataFetcher.getHour(0L);
        return this.fetch0(parameter, today, start, end);
    }

    @Override
    public List<AdGroupData> fetchTodayData(Parameter parameter) throws DataFetchFailException {
        String today = LocalTime.now().getHour() == 0 ? KuaishouDataFetcher.getToday(-1L) : KuaishouDataFetcher.getToday();
        return this.fetch0(parameter, today, null, null);
    }

    private List<AdGroupData> fetch0(Parameter parameter, String date, String start, String end) throws DataFetchFailException {
        String tagId = parameter.getTagId();
        String advertiserId = this.getAdvertiserId(tagId);
        String adGroupId = parameter.getAdGroupId();
        String shallowEventType = parameter.getShallowEventType();
        String deepEventType = parameter.getDeepEventType();
        Boolean needFetchKuaishouCpa = Optional.ofNullable(parameter.getNeedFetchKuaishouCpa()).orElse(false);
        String json = null;
        try {
            if (StringUtils.isBlank((String)advertiserId)) {
                throw new DataFetchFailException("'advertiserId' \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5728\u5e7f\u544a\u4f4d\uff1a" + tagId);
            }
            KuaishouAk ak = this.getAk("GLOBAL", advertiserId);
            if (Objects.isNull(ak)) {
                ak = this.getAk(tagId, advertiserId);
            }
            if (Objects.isNull(ak)) {
                throw new DataFetchFailException(String.format("\u6ca1\u6709\u627e\u5230 AK \u5bc6\u94a5\uff0c\u5728\u5e7f\u544a\u4f4d\uff1a%s \u548c advertiserId\uff1a%s", tagId, advertiserId));
            }
            String accessToken = ak.getAccessToken();
            JSONObject params = new JSONObject();
            params.put("advertiser_id", (Object)advertiserId);
            if (StringUtils.isNotBlank((String)start) && StringUtils.isNotBlank((String)end)) {
                params.put("start_date_min", (Object)start);
                params.put("end_date_min", (Object)end);
            }
            params.put("start_date", (Object)date);
            params.put("end_date", (Object)date);
            params.put("temporal_granularity", (Object)"HOURLY");
            if (StringUtils.isNotBlank((String)adGroupId)) {
                params.put("unit_ids", (Object)new String[]{adGroupId});
            } else {
                params.put("page_size", (Object)this.config.getDataFetchPageSize());
            }
            HttpPost post = new HttpPost(this.config.getUrlUnitReport());
            log.info("ks fetch req {}", (Object)params.toJSONString());
            post.setEntity((HttpEntity)new StringEntity(params.toJSONString()));
            post.addHeader("Access-Token", accessToken);
            post.addHeader("Content-Type", "application/json;charset=UTF-8");
            HttpResponse hr = this.httpClient.execute((HttpUriRequest)post);
            json = EntityUtils.toString((HttpEntity)hr.getEntity());
            KsUnitReportRes res = (KsUnitReportRes)JSONObject.parseObject((String)json, KsUnitReportRes.class);
            if (!res.isSuccess()) {
                throw new DataFetchFailException(String.format("\u63a5\u53e3\u8bf7\u6c42\u4e0d\u6210\u529f\uff01\u5e7f\u544a\u4f4d\uff1a%s\uff0cadvertiserId\uff1a%s\u3002\u8fd4\u56de\u7ed3\u679c\uff1a%s", tagId, advertiserId, json));
            }
            List<KsUnitList> ksUnitLists = null;
            if (needFetchKuaishouCpa.booleanValue()) {
                ksUnitLists = this.getUnitListPage(advertiserId, date, adGroupId, tagId, accessToken);
            }
            return this.convert(res, ksUnitLists, shallowEventType, deepEventType);
        }
        catch (IOException e) {
            throw new DataFetchFailException(String.format("\u63a5\u53e3\u7f51\u7edc\u5f02\u5e38\uff08%s\uff09\uff01\u5e7f\u544a\u4f4d\uff1a%s\uff0cadvertiserId\uff1a%s\u3002", e.getClass().getName(), tagId, advertiserId));
        }
        catch (JSONException e) {
            throw new DataFetchFailException(String.format("\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff01\u5e7f\u544a\u4f4d\uff1a%s\uff0cadvertiserId\uff1a%s\u3002\u8fd4\u56de\u7ed3\u679c\uff1a%s", tagId, advertiserId, json));
        }
    }

    private List<KsUnitList> getUnitListPage(String advertiserId, String date, String adGroupId, String tagId, String accessToken) throws DataFetchFailException, IOException {
        List<KsUnitList> currentPageData;
        ArrayList<KsUnitList> totalData = new ArrayList<KsUnitList>(1000);
        int currentPage = 1;
        do {
            if (log.isDebugEnabled()) {
                log.debug("[{}]\u6267\u884c\u4e2d... \u5f53\u524d\u9875 {}", (Object)this.getClass().getSimpleName(), (Object)currentPage);
            }
            currentPageData = this.getUnitListRes(advertiserId, date, adGroupId, tagId, accessToken, currentPage);
            ++currentPage;
            if (!CollectionUtils.isNotEmpty(currentPageData)) continue;
            totalData.addAll(currentPageData);
        } while (CollectionUtils.isNotEmpty(currentPageData));
        return totalData;
    }

    private List<KsUnitList> getUnitListRes(String advertiserId, String date, String adGroupId, String tagId, String accessToken, Integer currentPage) throws IOException, DataFetchFailException {
        JSONObject params = new JSONObject();
        params.put("advertiser_id", (Object)advertiserId);
        params.put("page", (Object)currentPage);
        params.put("page_size", (Object)500);
        if (StringUtils.isNotBlank((String)adGroupId)) {
            params.put("unit_ids", (Object)new String[]{adGroupId});
        }
        HttpPost post = new HttpPost(this.config.getUrlUnitList());
        post.setEntity((HttpEntity)new StringEntity(params.toJSONString()));
        post.addHeader("Access-Token", accessToken);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        HttpResponse hr = this.httpClient.execute((HttpUriRequest)post);
        String json = EntityUtils.toString((HttpEntity)hr.getEntity());
        KsUnitListRes res = (KsUnitListRes)JSONObject.parseObject((String)json, KsUnitListRes.class);
        if (!res.isSuccess()) {
            throw new DataFetchFailException(String.format("\u63a5\u53e3\u8bf7\u6c42\u4e0d\u6210\u529f\uff01\u5e7f\u544a\u4f4d\uff1a%s\uff0cadvertiserId\uff1a%s\u3002\u8fd4\u56de\u7ed3\u679c\uff1a%s", tagId, advertiserId, json));
        }
        if (Objects.nonNull(res.getData())) {
            return res.getData().getDetails();
        }
        return null;
    }

    private String getAppkey(String tagId) {
        if (StringUtils.isBlank((String)tagId)) {
            return null;
        }
        return StringUtils.split((String)tagId, (String)"-")[0];
    }

    private String getAdvertiserId(String tagId) {
        AccountBindCache accountBindCache = (AccountBindCache)this.fetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"rtb", "account_binding"}), tagId, AccountBindCache.class);
        if (accountBindCache != null) {
            return accountBindCache.getAccountId();
        }
        return null;
    }

    private KuaishouAk getAk(String tagId, String advertiserId) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String v = jedis.hget(KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "AK", tagId}), advertiserId);
            KuaishouAk kuaishouAk = Optional.ofNullable(v).filter(StringUtils::isNotBlank).map(s -> (KuaishouAk)JsonHelper.convert((String)s, KuaishouAk.class)).orElse(null);
            return kuaishouAk;
        }
    }

    private List<AdGroupData> convert(KsUnitReportRes res, List<KsUnitList> ksUnitLists, String shallowEventType, String deepEventType) {
        if (!res.isSuccess()) {
            return null;
        }
        KsData ksData = res.getData();
        if (Objects.isNull(ksData)) {
            return null;
        }
        List<KsUnitReport> details = ksData.getDetails();
        if (CollectionUtils.isEmpty(details)) {
            return null;
        }
        Map<String, Long> adGroupCpaMap = this.getAdGroupCpaMap(ksUnitLists);
        ArrayList ret = Lists.newArrayList();
        details.forEach(e -> {
            Long cpaBid = (Long)adGroupCpaMap.get(e.getUnit_id());
            AdGroupData adGroupData = new AdGroupData().setAdGroupId(e.getUnit_id()).setDate(e.getStat_date()).setHour(e.getStat_hour()).setCharge(e.getCharge()).setTime(System.currentTimeMillis()).setCpa(Optional.ofNullable(cpaBid).map(cpa -> BigDecimal.valueOf(Money.ofLi((long)cpa).getYuan())).orElse(null));
            if (StringUtils.equals((String)shallowEventType, (String)"9")) {
                adGroupData.setShallowConvCount(e.getForm_count());
                adGroupData.setShallowConvCost(e.getForm_cost());
            } else if (StringUtils.equals((String)shallowEventType, (String)"3")) {
                adGroupData.setShallowConvCount(e.getEvent_new_user_pay());
                adGroupData.setShallowConvCost(e.getEvent_new_user_pay_cost());
            } else if (StringUtils.equals((String)shallowEventType, (String)"44")) {
                adGroupData.setShallowConvCount(e.getEvent_valid_clues());
                adGroupData.setShallowConvCost(e.getEvent_valid_clues_cost());
            }
            if (StringUtils.equals((String)deepEventType, (String)"9")) {
                adGroupData.setDeepConvCount(e.getForm_count());
                adGroupData.setDeepConvCost(e.getForm_cost());
            } else if (StringUtils.equals((String)deepEventType, (String)"3")) {
                adGroupData.setDeepConvCount(e.getEvent_new_user_pay());
                adGroupData.setDeepConvCost(e.getEvent_new_user_pay_cost());
            } else if (StringUtils.equals((String)deepEventType, (String)"44")) {
                adGroupData.setDeepConvCount(e.getEvent_valid_clues());
                adGroupData.setDeepConvCost(e.getEvent_valid_clues_cost());
            }
            adGroupData.setConvNumByImpression(e.getConversion_num_by_impression_7d());
            ret.add(adGroupData);
        });
        return ret;
    }

    private Map<String, Long> getAdGroupCpaMap(List<KsUnitList> ksUnitList) {
        if (CollectionUtils.isNotEmpty(ksUnitList) && CollectionUtils.isNotEmpty(ksUnitList)) {
            Map<String, Long> adGroupCpaMap = ksUnitList.stream().collect(Collectors.toMap(KsUnitList::getUnit_id, KsUnitList::getCpa_bid, (exist, replace) -> exist));
            return adGroupCpaMap;
        }
        return Collections.emptyMap();
    }

    public static void main(String[] args) {
        String today = KuaishouDataFetcher.getToday();
        System.out.println(today);
        String start = KuaishouDataFetcher.getHour(0L);
        String end = KuaishouDataFetcher.getHour(1L);
        System.out.println(start + " - " + end);
        System.out.println(KuaishouDataFetcher.getToday(-1L));
        System.out.println(KuaishouDataFetcher.getHour(-1L) + " - " + KuaishouDataFetcher.getHour(0L));
        String today1 = LocalTime.now().getHour() == 0 ? KuaishouDataFetcher.getToday(-1L) : KuaishouDataFetcher.getToday();
        String start1 = KuaishouDataFetcher.getHour(-1L);
        String end1 = KuaishouDataFetcher.getHour(0L);
        System.out.println(today1 + " > " + start1 + " - " + end1);
        ArrayList<AdGroupData> list = new ArrayList<AdGroupData>();
        AdGroupData data = new AdGroupData().setAdGroupId("8556006").setDate("2022-11-16").setHour(15).setCharge(BigDecimal.valueOf(300L)).setShallowConvCount(50L).setShallowConvCost(BigDecimal.valueOf(30L)).setDeepConvCount(20L).setDeepConvCost(BigDecimal.valueOf(120L)).setTime(System.currentTimeMillis());
        list.add(data);
        System.out.println(JsonHelper.convert(list));
    }

    public KeyGenerator hashKuaishouAdvertiserId(String tagId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "kuaishou", "position_advertiserId"});
    }

    public static class KsUnitList {
        private String unit_id;
        private Long cpa_bid;

        public String getUnit_id() {
            return this.unit_id;
        }

        public Long getCpa_bid() {
            return this.cpa_bid;
        }

        public void setUnit_id(String unit_id) {
            this.unit_id = unit_id;
        }

        public void setCpa_bid(Long cpa_bid) {
            this.cpa_bid = cpa_bid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KsUnitList)) {
                return false;
            }
            KsUnitList other = (KsUnitList)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$cpa_bid = this.getCpa_bid();
            Long other$cpa_bid = other.getCpa_bid();
            if (this$cpa_bid == null ? other$cpa_bid != null : !((Object)this$cpa_bid).equals(other$cpa_bid)) {
                return false;
            }
            String this$unit_id = this.getUnit_id();
            String other$unit_id = other.getUnit_id();
            return !(this$unit_id == null ? other$unit_id != null : !this$unit_id.equals(other$unit_id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KsUnitList;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $cpa_bid = this.getCpa_bid();
            result = result * 59 + ($cpa_bid == null ? 43 : ((Object)$cpa_bid).hashCode());
            String $unit_id = this.getUnit_id();
            result = result * 59 + ($unit_id == null ? 43 : $unit_id.hashCode());
            return result;
        }

        public String toString() {
            return "KuaishouDataFetcher.KsUnitList(unit_id=" + this.getUnit_id() + ", cpa_bid=" + this.getCpa_bid() + ")";
        }
    }

    public static class KsUnitReport {
        private String unit_id;
        private String stat_date;
        private Integer stat_hour;
        private Long form_count;
        private BigDecimal charge;
        private BigDecimal form_cost;
        private BigDecimal form_action_ratio;
        private Long event_new_user_pay;
        private BigDecimal event_new_user_pay_cost;
        private BigDecimal event_new_user_pay_ratio;
        private Long event_valid_clues;
        private BigDecimal event_valid_clues_cost;
        private Long conversion_num_by_impression_7d;

        public String getUnit_id() {
            return this.unit_id;
        }

        public String getStat_date() {
            return this.stat_date;
        }

        public Integer getStat_hour() {
            return this.stat_hour;
        }

        public Long getForm_count() {
            return this.form_count;
        }

        public BigDecimal getCharge() {
            return this.charge;
        }

        public BigDecimal getForm_cost() {
            return this.form_cost;
        }

        public BigDecimal getForm_action_ratio() {
            return this.form_action_ratio;
        }

        public Long getEvent_new_user_pay() {
            return this.event_new_user_pay;
        }

        public BigDecimal getEvent_new_user_pay_cost() {
            return this.event_new_user_pay_cost;
        }

        public BigDecimal getEvent_new_user_pay_ratio() {
            return this.event_new_user_pay_ratio;
        }

        public Long getEvent_valid_clues() {
            return this.event_valid_clues;
        }

        public BigDecimal getEvent_valid_clues_cost() {
            return this.event_valid_clues_cost;
        }

        public Long getConversion_num_by_impression_7d() {
            return this.conversion_num_by_impression_7d;
        }

        public void setUnit_id(String unit_id) {
            this.unit_id = unit_id;
        }

        public void setStat_date(String stat_date) {
            this.stat_date = stat_date;
        }

        public void setStat_hour(Integer stat_hour) {
            this.stat_hour = stat_hour;
        }

        public void setForm_count(Long form_count) {
            this.form_count = form_count;
        }

        public void setCharge(BigDecimal charge) {
            this.charge = charge;
        }

        public void setForm_cost(BigDecimal form_cost) {
            this.form_cost = form_cost;
        }

        public void setForm_action_ratio(BigDecimal form_action_ratio) {
            this.form_action_ratio = form_action_ratio;
        }

        public void setEvent_new_user_pay(Long event_new_user_pay) {
            this.event_new_user_pay = event_new_user_pay;
        }

        public void setEvent_new_user_pay_cost(BigDecimal event_new_user_pay_cost) {
            this.event_new_user_pay_cost = event_new_user_pay_cost;
        }

        public void setEvent_new_user_pay_ratio(BigDecimal event_new_user_pay_ratio) {
            this.event_new_user_pay_ratio = event_new_user_pay_ratio;
        }

        public void setEvent_valid_clues(Long event_valid_clues) {
            this.event_valid_clues = event_valid_clues;
        }

        public void setEvent_valid_clues_cost(BigDecimal event_valid_clues_cost) {
            this.event_valid_clues_cost = event_valid_clues_cost;
        }

        public void setConversion_num_by_impression_7d(Long conversion_num_by_impression_7d) {
            this.conversion_num_by_impression_7d = conversion_num_by_impression_7d;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KsUnitReport)) {
                return false;
            }
            KsUnitReport other = (KsUnitReport)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$stat_hour = this.getStat_hour();
            Integer other$stat_hour = other.getStat_hour();
            if (this$stat_hour == null ? other$stat_hour != null : !((Object)this$stat_hour).equals(other$stat_hour)) {
                return false;
            }
            Long this$form_count = this.getForm_count();
            Long other$form_count = other.getForm_count();
            if (this$form_count == null ? other$form_count != null : !((Object)this$form_count).equals(other$form_count)) {
                return false;
            }
            Long this$event_new_user_pay = this.getEvent_new_user_pay();
            Long other$event_new_user_pay = other.getEvent_new_user_pay();
            if (this$event_new_user_pay == null ? other$event_new_user_pay != null : !((Object)this$event_new_user_pay).equals(other$event_new_user_pay)) {
                return false;
            }
            Long this$event_valid_clues = this.getEvent_valid_clues();
            Long other$event_valid_clues = other.getEvent_valid_clues();
            if (this$event_valid_clues == null ? other$event_valid_clues != null : !((Object)this$event_valid_clues).equals(other$event_valid_clues)) {
                return false;
            }
            Long this$conversion_num_by_impression_7d = this.getConversion_num_by_impression_7d();
            Long other$conversion_num_by_impression_7d = other.getConversion_num_by_impression_7d();
            if (this$conversion_num_by_impression_7d == null ? other$conversion_num_by_impression_7d != null : !((Object)this$conversion_num_by_impression_7d).equals(other$conversion_num_by_impression_7d)) {
                return false;
            }
            String this$unit_id = this.getUnit_id();
            String other$unit_id = other.getUnit_id();
            if (this$unit_id == null ? other$unit_id != null : !this$unit_id.equals(other$unit_id)) {
                return false;
            }
            String this$stat_date = this.getStat_date();
            String other$stat_date = other.getStat_date();
            if (this$stat_date == null ? other$stat_date != null : !this$stat_date.equals(other$stat_date)) {
                return false;
            }
            BigDecimal this$charge = this.getCharge();
            BigDecimal other$charge = other.getCharge();
            if (this$charge == null ? other$charge != null : !((Object)this$charge).equals(other$charge)) {
                return false;
            }
            BigDecimal this$form_cost = this.getForm_cost();
            BigDecimal other$form_cost = other.getForm_cost();
            if (this$form_cost == null ? other$form_cost != null : !((Object)this$form_cost).equals(other$form_cost)) {
                return false;
            }
            BigDecimal this$form_action_ratio = this.getForm_action_ratio();
            BigDecimal other$form_action_ratio = other.getForm_action_ratio();
            if (this$form_action_ratio == null ? other$form_action_ratio != null : !((Object)this$form_action_ratio).equals(other$form_action_ratio)) {
                return false;
            }
            BigDecimal this$event_new_user_pay_cost = this.getEvent_new_user_pay_cost();
            BigDecimal other$event_new_user_pay_cost = other.getEvent_new_user_pay_cost();
            if (this$event_new_user_pay_cost == null ? other$event_new_user_pay_cost != null : !((Object)this$event_new_user_pay_cost).equals(other$event_new_user_pay_cost)) {
                return false;
            }
            BigDecimal this$event_new_user_pay_ratio = this.getEvent_new_user_pay_ratio();
            BigDecimal other$event_new_user_pay_ratio = other.getEvent_new_user_pay_ratio();
            if (this$event_new_user_pay_ratio == null ? other$event_new_user_pay_ratio != null : !((Object)this$event_new_user_pay_ratio).equals(other$event_new_user_pay_ratio)) {
                return false;
            }
            BigDecimal this$event_valid_clues_cost = this.getEvent_valid_clues_cost();
            BigDecimal other$event_valid_clues_cost = other.getEvent_valid_clues_cost();
            return !(this$event_valid_clues_cost == null ? other$event_valid_clues_cost != null : !((Object)this$event_valid_clues_cost).equals(other$event_valid_clues_cost));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KsUnitReport;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $stat_hour = this.getStat_hour();
            result = result * 59 + ($stat_hour == null ? 43 : ((Object)$stat_hour).hashCode());
            Long $form_count = this.getForm_count();
            result = result * 59 + ($form_count == null ? 43 : ((Object)$form_count).hashCode());
            Long $event_new_user_pay = this.getEvent_new_user_pay();
            result = result * 59 + ($event_new_user_pay == null ? 43 : ((Object)$event_new_user_pay).hashCode());
            Long $event_valid_clues = this.getEvent_valid_clues();
            result = result * 59 + ($event_valid_clues == null ? 43 : ((Object)$event_valid_clues).hashCode());
            Long $conversion_num_by_impression_7d = this.getConversion_num_by_impression_7d();
            result = result * 59 + ($conversion_num_by_impression_7d == null ? 43 : ((Object)$conversion_num_by_impression_7d).hashCode());
            String $unit_id = this.getUnit_id();
            result = result * 59 + ($unit_id == null ? 43 : $unit_id.hashCode());
            String $stat_date = this.getStat_date();
            result = result * 59 + ($stat_date == null ? 43 : $stat_date.hashCode());
            BigDecimal $charge = this.getCharge();
            result = result * 59 + ($charge == null ? 43 : ((Object)$charge).hashCode());
            BigDecimal $form_cost = this.getForm_cost();
            result = result * 59 + ($form_cost == null ? 43 : ((Object)$form_cost).hashCode());
            BigDecimal $form_action_ratio = this.getForm_action_ratio();
            result = result * 59 + ($form_action_ratio == null ? 43 : ((Object)$form_action_ratio).hashCode());
            BigDecimal $event_new_user_pay_cost = this.getEvent_new_user_pay_cost();
            result = result * 59 + ($event_new_user_pay_cost == null ? 43 : ((Object)$event_new_user_pay_cost).hashCode());
            BigDecimal $event_new_user_pay_ratio = this.getEvent_new_user_pay_ratio();
            result = result * 59 + ($event_new_user_pay_ratio == null ? 43 : ((Object)$event_new_user_pay_ratio).hashCode());
            BigDecimal $event_valid_clues_cost = this.getEvent_valid_clues_cost();
            result = result * 59 + ($event_valid_clues_cost == null ? 43 : ((Object)$event_valid_clues_cost).hashCode());
            return result;
        }

        public String toString() {
            return "KuaishouDataFetcher.KsUnitReport(unit_id=" + this.getUnit_id() + ", stat_date=" + this.getStat_date() + ", stat_hour=" + this.getStat_hour() + ", form_count=" + this.getForm_count() + ", charge=" + this.getCharge() + ", form_cost=" + this.getForm_cost() + ", form_action_ratio=" + this.getForm_action_ratio() + ", event_new_user_pay=" + this.getEvent_new_user_pay() + ", event_new_user_pay_cost=" + this.getEvent_new_user_pay_cost() + ", event_new_user_pay_ratio=" + this.getEvent_new_user_pay_ratio() + ", event_valid_clues=" + this.getEvent_valid_clues() + ", event_valid_clues_cost=" + this.getEvent_valid_clues_cost() + ", conversion_num_by_impression_7d=" + this.getConversion_num_by_impression_7d() + ")";
        }
    }

    public static class KsData<T> {
        private int total_count;
        private List<T> details;

        public int getTotal_count() {
            return this.total_count;
        }

        public List<T> getDetails() {
            return this.details;
        }

        public void setTotal_count(int total_count) {
            this.total_count = total_count;
        }

        public void setDetails(List<T> details) {
            this.details = details;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KsData)) {
                return false;
            }
            KsData other = (KsData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotal_count() != other.getTotal_count()) {
                return false;
            }
            List<T> this$details = this.getDetails();
            List<T> other$details = other.getDetails();
            return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KsData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTotal_count();
            List<T> $details = this.getDetails();
            result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
            return result;
        }

        public String toString() {
            return "KuaishouDataFetcher.KsData(total_count=" + this.getTotal_count() + ", details=" + this.getDetails() + ")";
        }
    }

    public static class Ks<T> {
        private int code = -1;
        private String message;
        private KsData<T> data;

        public boolean isSuccess() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public KsData<T> getData() {
            return this.data;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setData(KsData<T> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ks)) {
                return false;
            }
            Ks other = (Ks)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            KsData<T> this$data = this.getData();
            KsData<T> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ks;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            KsData<T> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "KuaishouDataFetcher.Ks(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
        }
    }

    public static class KsUnitListRes
    extends Ks<KsUnitList> {
    }

    public static class KsUnitReportRes
    extends Ks<KsUnitReport> {
    }
}

