/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.liuliangguo;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.liuliangguo.LiuLiangGuoConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiuLiangGuoRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(LiuLiangGuoRtbIntegration.class);
    public static final String CLICK_ID = "state_json";

    public LiuLiangGuoRtbIntegration(LiuLiangGuoConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        return (String)keyValueMap.getFirst((Object)"tagid");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String eventType = request.getEventType();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String clickId = UrlHelper.getFirstValueOfParamName((String)request.getReferrer(), (String)CLICK_ID);
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found state_json. keyValueMap: %s", JSONObject.toJSONString((Object)keyValueMap)));
        }
        Request request1 = new Request();
        request1.setOrder_id(String.valueOf(System.currentTimeMillis()));
        request1.setStatus(eventType);
        request1.setState_json(clickId);
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)request1), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    public Rtb rtb() {
        return Rtb.LIULIANGGUO;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Request {
        private String state_json;
        private String order_id;
        private String status;

        public String getState_json() {
            return this.state_json;
        }

        public String getOrder_id() {
            return this.order_id;
        }

        public String getStatus() {
            return this.status;
        }

        public Request setState_json(String state_json) {
            this.state_json = state_json;
            return this;
        }

        public Request setOrder_id(String order_id) {
            this.order_id = order_id;
            return this;
        }

        public Request setStatus(String status) {
            this.status = status;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$state_json = this.getState_json();
            String other$state_json = other.getState_json();
            if (this$state_json == null ? other$state_json != null : !this$state_json.equals(other$state_json)) {
                return false;
            }
            String this$order_id = this.getOrder_id();
            String other$order_id = other.getOrder_id();
            if (this$order_id == null ? other$order_id != null : !this$order_id.equals(other$order_id)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $state_json = this.getState_json();
            result = result * 59 + ($state_json == null ? 43 : $state_json.hashCode());
            String $order_id = this.getOrder_id();
            result = result * 59 + ($order_id == null ? 43 : $order_id.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public String toString() {
            return "LiuLiangGuoRtbIntegration.Request(state_json=" + this.getState_json() + ", order_id=" + this.getOrder_id() + ", status=" + this.getStatus() + ")";
        }
    }

    private static class Response
    extends FeedbackResponse {
        private String status;
        private String message;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase((String)"200", (String)this.status);
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

