/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.mangguo;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbRedisKeys;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.mangguo.MangGuoConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MangGuoRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(MangGuoRtbIntegration.class);
    public static final String CLICK_ID = "callback";
    private final Fetcher fetcher;

    public MangGuoRtbIntegration(MangGuoConfig config, Fetcher fetcher) {
        super(config);
        this.fetcher = fetcher;
    }

    @Override
    public Rtb rtb() {
        return Rtb.MANGGUO;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        String key = clickEventLog.getIp();
        log.info("manguo ip : {}", (Object)key);
        if (StringUtils.isNotBlank((String)key)) {
            return (String)this.fetcher.fetch(RtbRedisKeys.strMangguoIpClickId(key), String.class);
        }
        return "";
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        return (String)keyValueMap.getFirst((Object)"tagid");
    }

    @Override
    public boolean forceSaveClickTracker() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String eventType = request.getEventType();
        String callback = this.getClickIdOnInadsAdClickLog(keyValueMap);
        if (StringUtils.isBlank((String)callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback' by clickTracker.");
        }
        if (StringUtils.isBlank((String)eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'eventType' by config.");
        }
        callback = StringUtils.replace((String)callback, (String)"__EVENT_TYPE__", (String)eventType);
        callback = StringUtils.replace((String)callback, (String)"__CONV_TIME__", (String)Objects.toString(System.currentTimeMillis() / 1000L));
        return new HttpGet(callback);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

