/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.mengran;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.mengran.MengranConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class MengranRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(MengranRtbIntegration.class);
    public static final String CLICK_ID = "ccbid";

    public MengranRtbIntegration(MengranConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        return (String)keyValueMap.getFirst((Object)"tagid");
    }

    @Override
    public Rtb rtb() {
        return Rtb.MENGRAN;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String clickId = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'ccbid' by referrer.");
        }
        HashMap params = Maps.newHashMap();
        params.put("bid", clickId);
        params.put("act", eventType);
        params.put("url", referrer);
        params.put("firstUrl", referrer);
        params.put("ip", keyValueMap.getFirst((Object)"ip"));
        params.put("ua", keyValueMap.getFirst((Object)"ua"));
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Response
    extends FeedbackResponse {
        private String code;
        private String msg;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"0", (String)this.code);
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

