/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.mintegral;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.mintegral.MintegralConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class MintegralRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(MintegralRtbIntegration.class);
    public static final String CLICK_ID = "campuuid";

    public MintegralRtbIntegration(MintegralConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        return (String)queryParams.getFirst((Object)CLICK_ID);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        PositionRtb positionRtb = request.getConfig();
        String campuuid = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)campuuid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, positionRtb.getPositionId() + "Cannot found 'campuuid' by referrer.");
        }
        String clickid = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)"clickid");
        if (StringUtils.isBlank((String)clickid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, positionRtb.getPositionId() + "Cannot found 'clickid' by referrer.");
        }
        HashMap params = Maps.newHashMap();
        params.put("clickid", clickid);
        params.put(CLICK_ID, campuuid);
        params.put("install_time", String.valueOf(System.currentTimeMillis()));
        params.put("event_name", eventType);
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Mintegral;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Response
    extends FeedbackResponse {
        private String ret;
        private String msg;

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"0", (String)this.ret);
        }

        public String getRet() {
            return this.ret;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setRet(String ret) {
            this.ret = ret;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ret = this.getRet();
            String other$ret = other.getRet();
            if (this$ret == null ? other$ret != null : !this$ret.equals(other$ret)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ret = this.getRet();
            result = result * 59 + ($ret == null ? 43 : $ret.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MintegralRtbIntegration.Response(ret=" + this.getRet() + ", msg=" + this.getMsg() + ")";
        }
    }
}

