/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.mkit;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.mkit.MkitConfig;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class MkitRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    public MkitRtbIntegration(MkitConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.MKIT;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String clickId = request.getClickId();
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickId'.");
        }
        HashMap params = Maps.newHashMap();
        params.put("click_id", clickId);
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        MkitResponse mkitResponse = (MkitResponse)JsonHelper.convert((String)body, MkitResponse.class);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(mkitResponse != null && mkitResponse.isSuccess());
        return feedbackResponse;
    }

    public static class MkitResponse {
        private Integer code;
        private String msg;
        private Integer status;
        private boolean succ;

        public boolean isSuccess() {
            return this.status == 200;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public Integer getStatus() {
            return this.status;
        }

        public boolean isSucc() {
            return this.succ;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public void setSucc(boolean succ) {
            this.succ = succ;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MkitResponse)) {
                return false;
            }
            MkitResponse other = (MkitResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSucc() != other.isSucc()) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MkitResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSucc() ? 79 : 97);
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        public String toString() {
            return "MkitRtbIntegration.MkitResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", status=" + this.getStatus() + ", succ=" + this.isSucc() + ")";
        }
    }
}

