/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.oppo;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.oppo.OppoConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class OppoRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(OppoRtbIntegration.class);
    public static final String CLICK_ID = "tid";
    private final OppoConfig config;

    public OppoRtbIntegration(OppoConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        return this.getAdGroupIdForTransparent((String)queryParams.getFirst((Object)"transparent"));
    }

    public String getAdGroupIdForTransparent(String transparent) {
        if (StringUtils.isBlank((String)transparent)) {
            return null;
        }
        String[] arr = StringUtils.split((String)transparent, (String)"_");
        return arr[arr.length - 1];
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        PositionRtb positionRtb = request.getConfig();
        String pageId = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)"pageId");
        if (StringUtils.isBlank((String)pageId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'pageId' by referrer.");
        }
        String tid = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)tid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'tid' by referrer.");
        }
        String lbid = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)"lbid");
        if (StringUtils.isBlank((String)lbid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'lbid' by referrer.");
        }
        String ip = (String)request.getKeyValueMap().getFirst((Object)"ip");
        OPPORequest oppoRequest = new OPPORequest().setPageId(pageId).setOwnerId(positionRtb.getCustomerId()).setIp(ip).setTid(UrlHelper.urlEncode((String)tid)).setLbid(lbid).setTransformType(eventType);
        String entity = JsonHelper.convert((Object)oppoRequest);
        log.info("oppo req: {}", (Object)entity);
        HttpPost post = new HttpPost(url);
        post.addHeader("Authorization", "Bearer " + OppoRtbIntegration.getToken(positionRtb.getSourceId(), positionRtb.getToken(), positionRtb.getCustomerId()));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        request.setRequestBody(entity);
        return post;
    }

    private static String getToken(String apiId, String apiKey, String ownerId) {
        try {
            long timestamp = System.currentTimeMillis() / 1000L;
            String sign = DigestUtils.sha1Hex((String)(apiId + apiKey + timestamp));
            String str = ownerId + "," + apiId + "," + timestamp + "," + sign;
            return Base64.encodeBase64String((byte[])str.getBytes());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Rtb rtb() {
        return Rtb.OPPO;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    @Override
    public String[] getMissingAdGroupIdList() {
        return new String[]{"NULL"};
    }

    private static class OPPORequest {
        private String pageId;
        private String ownerId;
        private String ip;
        private String tid;
        private String lbid;
        private String transformType;

        public String getPageId() {
            return this.pageId;
        }

        public String getOwnerId() {
            return this.ownerId;
        }

        public String getIp() {
            return this.ip;
        }

        public String getTid() {
            return this.tid;
        }

        public String getLbid() {
            return this.lbid;
        }

        public String getTransformType() {
            return this.transformType;
        }

        public OPPORequest setPageId(String pageId) {
            this.pageId = pageId;
            return this;
        }

        public OPPORequest setOwnerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public OPPORequest setIp(String ip) {
            this.ip = ip;
            return this;
        }

        public OPPORequest setTid(String tid) {
            this.tid = tid;
            return this;
        }

        public OPPORequest setLbid(String lbid) {
            this.lbid = lbid;
            return this;
        }

        public OPPORequest setTransformType(String transformType) {
            this.transformType = transformType;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OPPORequest)) {
                return false;
            }
            OPPORequest other = (OPPORequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$pageId = this.getPageId();
            String other$pageId = other.getPageId();
            if (this$pageId == null ? other$pageId != null : !this$pageId.equals(other$pageId)) {
                return false;
            }
            String this$ownerId = this.getOwnerId();
            String other$ownerId = other.getOwnerId();
            if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$tid = this.getTid();
            String other$tid = other.getTid();
            if (this$tid == null ? other$tid != null : !this$tid.equals(other$tid)) {
                return false;
            }
            String this$lbid = this.getLbid();
            String other$lbid = other.getLbid();
            if (this$lbid == null ? other$lbid != null : !this$lbid.equals(other$lbid)) {
                return false;
            }
            String this$transformType = this.getTransformType();
            String other$transformType = other.getTransformType();
            return !(this$transformType == null ? other$transformType != null : !this$transformType.equals(other$transformType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OPPORequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $pageId = this.getPageId();
            result = result * 59 + ($pageId == null ? 43 : $pageId.hashCode());
            String $ownerId = this.getOwnerId();
            result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $tid = this.getTid();
            result = result * 59 + ($tid == null ? 43 : $tid.hashCode());
            String $lbid = this.getLbid();
            result = result * 59 + ($lbid == null ? 43 : $lbid.hashCode());
            String $transformType = this.getTransformType();
            result = result * 59 + ($transformType == null ? 43 : $transformType.hashCode());
            return result;
        }

        public String toString() {
            return "OppoRtbIntegration.OPPORequest(pageId=" + this.getPageId() + ", ownerId=" + this.getOwnerId() + ", ip=" + this.getIp() + ", tid=" + this.getTid() + ", lbid=" + this.getLbid() + ", transformType=" + this.getTransformType() + ")";
        }
    }

    private static class Response
    extends FeedbackResponse {
        private String code;
        private String message;
        private String data;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"0", (String)this.code);
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

