/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.oppoOcpx;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.oppoOcpx.OppoOcpxConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OppoOcpxRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(OppoOcpxRtbIntegration.class);
    public static final String ADID = "ad_id";
    public static final String PKG = "package";
    public static final String CUSTOM_TYPE = "customType";
    private final OppoOcpxConfig config;

    public OppoOcpxRtbIntegration(OppoOcpxConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public Rtb rtb() {
        return Rtb.OPPOOCPX;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String imei = (String)keyValueMap.getFirst((Object)"imei_md5");
        String oaid = (String)keyValueMap.getFirst((Object)"oaid");
        if (this.checkNullImei(imei) && this.checkNullOaid(oaid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "IMEI and OAID are both empty");
        }
        String adid = (String)keyValueMap.getFirst((Object)ADID);
        if (StringUtils.isBlank((CharSequence)adid) || "$ad$".equals(adid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "adid is empty");
        }
        String pkg = (String)keyValueMap.getFirst((Object)PKG);
        if (StringUtils.isBlank((CharSequence)pkg)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "pkg is empty");
        }
        String customType = (String)keyValueMap.getFirst((Object)CUSTOM_TYPE);
        if (StringUtils.isBlank((CharSequence)customType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "customType is empty");
        }
        long timeMillis = System.currentTimeMillis();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!this.checkNullImei(imei)) {
            params.put("imei", this.encode(imei));
        } else if (!this.checkNullOaid(oaid)) {
            params.put("ouid", this.encode(oaid));
        }
        params.put("timestamp", timeMillis);
        params.put(ADID, adid);
        String eventType = request.getEventType();
        params.put("dataType", eventType);
        if ("8".equals(eventType)) {
            params.put(CUSTOM_TYPE, customType);
        }
        params.put("pkg", pkg);
        params.put("channel", 1);
        params.put("ascribeType", 1);
        String body = JsonHelper.convert(params);
        HttpPost post = new HttpPost(this.config.getUrl());
        post.addHeader("signature", this.sign(body, timeMillis));
        post.addHeader("timestamp", String.valueOf(timeMillis));
        post.addHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8));
        return post;
    }

    private boolean checkNullImei(String imei) {
        return StringUtils.isBlank((CharSequence)imei) || "$im$".equals(imei);
    }

    private boolean checkNullOaid(String oaid) {
        return StringUtils.isBlank((CharSequence)oaid) || "__OAID__".equals(oaid);
    }

    private String sign(String body, long timeMillis) {
        return DigestUtils.md5Hex((String)(body + timeMillis + this.config.getSalt())).toLowerCase();
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(jsonObject.getInteger("ret") == 0);
        feedbackResponse.setBody(body);
        return feedbackResponse;
    }

    private String encode(String device) {
        byte[] encryptData = new byte[]{};
        try {
            SecretKeySpec dataKey = new SecretKeySpec(Base64.decodeBase64((String)this.config.getBase64Key()), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, dataKey);
            encryptData = cipher.doFinal(device.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("OPPOOCPX encode error:", (Throwable)e);
        }
        return Base64.encodeBase64String((byte[])encryptData).replaceAll("\r", "").replaceAll("\n", "");
    }
}

