/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.pc360;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.pc360.IndustryEnum;
import com.bxm.adscounter.rtb.common.impl.pc360.Pc360Config;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class Pc360RtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(Pc360RtbIntegration.class);

    public Pc360RtbIntegration(Pc360Config config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.pc360;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        PositionRtb positionRtb = request.getConfig();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String qhclickid = (String)queryParams.getFirst((Object)"qhclickid");
        String impression_id = (String)queryParams.getFirst((Object)"impression_id");
        String sourceid = (String)queryParams.getFirst((Object)"sourceid");
        String industry = positionRtb.getCustomerId();
        if (StringUtils.equalsIgnoreCase((String)IndustryEnum.WEB.getIndex(), (String)industry)) {
            if (StringUtils.isBlank((String)impression_id)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'impression_id' by referrer.");
            }
        } else if (StringUtils.equalsIgnoreCase((String)IndustryEnum.ZS.getIndex(), (String)industry)) {
            qhclickid = sourceid;
            if (StringUtils.isBlank((String)sourceid)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sourceid' by referrer.");
            }
        } else if (StringUtils.isBlank((String)qhclickid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, " Cannot found 'qhclickid' by referrer.");
        }
        Request360 request360 = new Request360();
        Data data = new Data();
        Data_detail data_detail = new Data_detail();
        data_detail.setEvent(eventType);
        data_detail.setJzqs(positionRtb.getExtend());
        data_detail.setImpression_id(impression_id);
        data_detail.setQhclickid(qhclickid);
        data_detail.setTrans_id(String.valueOf(System.currentTimeMillis()));
        data.setData_industry(industry);
        data.setData_detail(data_detail);
        request360.setData(data);
        String value = JsonHelper.convert((Object)request360);
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.addHeader("App-Key", positionRtb.getToken());
        post.addHeader("App-Sign", DigestUtils.md5Hex((String)(positionRtb.getSourceId() + value)));
        post.setEntity((HttpEntity)new StringEntity(value, StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Data_detail {
        private String impression_id;
        private String qhclickid;
        private String jzqs;
        private String event;
        private String trans_id;

        private Data_detail() {
        }

        public String getImpression_id() {
            return this.impression_id;
        }

        public void setImpression_id(String impression_id) {
            this.impression_id = impression_id;
        }

        public String getQhclickid() {
            return this.qhclickid;
        }

        public void setQhclickid(String qhclickid) {
            this.qhclickid = qhclickid;
        }

        public String getJzqs() {
            return this.jzqs;
        }

        public void setJzqs(String jzqs) {
            this.jzqs = jzqs;
        }

        public String getEvent() {
            return this.event;
        }

        public String getTrans_id() {
            return this.trans_id;
        }

        public void setTrans_id(String trans_id) {
            this.trans_id = trans_id;
        }

        public void setEvent(String event) {
            this.event = event;
        }
    }

    private static class Data {
        private String data_industry;
        private Data_detail data_detail;

        private Data() {
        }

        public String getData_industry() {
            return this.data_industry;
        }

        public void setData_industry(String data_industry) {
            this.data_industry = data_industry;
        }

        public Data_detail getData_detail() {
            return this.data_detail;
        }

        public void setData_detail(Data_detail data_detail) {
            this.data_detail = data_detail;
        }
    }

    private static class Request360 {
        private Data data;

        private Request360() {
        }

        public Data getData() {
            return this.data;
        }

        public void setData(Data data) {
            this.data = data;
        }
    }

    private static class Response
    extends FeedbackResponse {
        private String errno;
        private String error;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase((String)"0", (String)this.errno);
        }

        public String getErrno() {
            return this.errno;
        }

        public void setErrno(String errno) {
            this.errno = errno;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}

