/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.qimao;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.integration.utils.HttpClientUtils;
import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.adscounter.rtb.common.impl.qimao.QiMaoConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.util.UriComponentsBuilder;

public class QiMaoRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(QiMaoRtbIntegration.class);
    private final Fetcher fetcher;
    private static final String[] clickTrackerDeviceIdTypes = new String[]{"imeiMd5", "idfa", "idfaMd5", "anid", "anidMd5", "oaid", "oaidMd5"};
    private static final String[] inadsDeviceIdTypes = new String[]{"imei_md5", "idfa", "idfa_md5", "androidid", "androidid_md5", "oaid", "oaid_md5"};
    private static final Set<String> deviceIdMacroSet = Sets.newHashSet((Object[])new String[]{"__IMEI_MD5__", "__IDFA__", "__IDFA_MD5__", "__ANDROIDID__", "__ANDROIDID__MD5__", "__OAID__", "__OAID__MD5__"});

    public QiMaoRtbIntegration(QiMaoConfig config, @Qualifier(value="rtbJedisFetcher") Fetcher fetcher) {
        super(config, QiMaoRtbIntegration.createHttpClient(config));
        this.fetcher = fetcher;
    }

    public static HttpClient createHttpClient(RtbConfig config) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().setProtocol("TLSv1.2").build();
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        return HttpClientUtils.createHttpClient((int)config.getMaxTotal(), (int)config.getDefaultMaxPerRoute(), (int)config.getConnectionRequestTimeout(), (int)config.getConnectTimeout(), (int)config.getSocketTimeout(), (SSLContext)sslContext);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        String deviceId = QiMaoRtbIntegration.findDeviceIdInMap(clickEventLog, false);
        if (StringUtils.isNotBlank((String)deviceId)) {
            return (String)this.fetcher.fetch(RedisKeyGenerator.strQiMaoDeviceClickId((String)deviceId), String.class);
        }
        return "";
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String clickId = this.getClickIdOnInadsAdClickLog(request.getKeyValueMap());
        if (StringUtils.isNotBlank((String)clickId)) {
            KeyValueMap clickTracker = this.getClickTracker(clickId);
            return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
        }
        return "";
    }

    @Override
    public boolean forceSaveClickTracker() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String eventType = request.getEventType();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String clickId = this.getClickIdOnInadsAdClickLog(keyValueMap);
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found clickId. keyValueMap: %s", JSONObject.toJSONString((Object)keyValueMap)));
        }
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        if (null == clickTracker) {
            throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found clickTracker by clickId. clickId: %s", clickId));
        }
        String callback = (String)clickTracker.getFirst((Object)"click_id");
        if (StringUtils.isBlank((String)callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found click_id from clickTracker. clickTracker: %s", JSONObject.toJSONString((Object)clickTracker)));
        }
        String callbackUrl = UriComponentsBuilder.fromUriString((String)UrlHelper.urlDecode((String)callback)).replaceQueryParam("event_type", new Object[]{eventType}).replaceQueryParam("timestamp", new Object[]{System.currentTimeMillis()}).build().toString();
        return new HttpGet(callbackUrl);
    }

    public static String findDeviceIdInMap(KeyValueMap keyValueMap, boolean isClickTracker) {
        String[] deviceIdTypes;
        for (String deviceIdType : deviceIdTypes = isClickTracker ? clickTrackerDeviceIdTypes : inadsDeviceIdTypes) {
            String deviceId = (String)keyValueMap.getFirst((Object)deviceIdType);
            if (!StringUtils.isNotBlank((String)deviceId) || deviceIdMacroSet.contains(deviceId)) continue;
            return deviceId;
        }
        return "";
    }

    @Override
    public Rtb rtb() {
        return Rtb.QiMao;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, QiMaoResponse.class);
    }

    private static class QiMaoResponse
    extends FeedbackResponse {
        private int code = -1;
        private String message;

        private QiMaoResponse() {
        }

        @Override
        public boolean isSuccess() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

