/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.sigmobinads;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.sigmobinads.SigmobInadsConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class SigmobInadsRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(SigmobInadsRtbIntegration.class);
    public static final String CLICK_ID = "callback";
    public static final String AD_GROUP_ID = "ad_group_id";

    public SigmobInadsRtbIntegration(SigmobInadsConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.SigmobInads;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        String clickId = (String)queryParams.getFirst((Object)CLICK_ID);
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)AD_GROUP_ID)).orElse("");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String referrer = request.getReferrer();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String callback = (String)queryParams.getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback' by referrer.");
        }
        String url = UrlHelper.urlDecode((String)callback);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

