/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.sina;

import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.sina.SinaConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinaRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(SinaRtbIntegration.class);
    public static final String CLICK_ID = "SET_D";
    private final Fetcher fetcher;

    public SinaRtbIntegration(SinaConfig config, Fetcher fetcher) {
        super(config);
        this.fetcher = fetcher;
    }

    @Override
    public Rtb rtb() {
        return Rtb.SINA;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        String clickId = UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
        if (StringUtils.isNotBlank((String)clickId)) {
            return clickId;
        }
        String key = clickEventLog.getIp() + clickEventLog.getUa();
        log.info("sina ipua : {}", (Object)key);
        if (StringUtils.isNotBlank((String)key)) {
            return (String)this.fetcher.fetch(RedisKeyGenerator.strSinaIpUaClickId((String)key), String.class);
        }
        return "";
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        return (String)keyValueMap.getFirst((Object)"tagid");
    }

    @Override
    public boolean forceSaveClickTracker() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String clickId = this.getClickIdOnInadsAdClickLog(keyValueMap);
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'click_id' by clickTracker.");
        }
        String token = request.getConfig().getToken();
        if (StringUtils.isBlank((String)token)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'token' by config.");
        }
        String cnvId = this.getCnvId(request);
        if (StringUtils.isBlank((String)cnvId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'cnvId' by config.");
        }
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("cnv_id", cnvId);
        params.put("click_id", clickId);
        params.put("bhv_time", System.currentTimeMillis() / 1000L);
        String feedbackUrl = this.getFeedbackUrl();
        feedbackUrl = OkHttpUtils.appendParams((String)feedbackUrl, (Map)params);
        feedbackUrl = feedbackUrl + "&sign=" + SinaRtbIntegration.getSign(feedbackUrl, token);
        return new HttpGet(feedbackUrl);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private String getCnvId(FeedbackRequest request) {
        PositionRtb positionRtb = request.getConfig();
        String extend = positionRtb.getExtend();
        if (StringUtils.isNotBlank((String)extend)) {
            CnvIdExtend cnvIdExtend = (CnvIdExtend)JsonHelper.convert((String)extend, CnvIdExtend.class);
            extend = request.isDeepConversion() ? cnvIdExtend.getDeepConvId() : cnvIdExtend.getShallowConvId();
        }
        return extend;
    }

    private static String getSign(String feedbackUrl, String token) {
        try {
            Mac sha1Hmac = Mac.getInstance("HmacSHA1");
            SecretKeySpec secretKey = new SecretKeySpec(token.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
            sha1Hmac.init(secretKey);
            byte[] hash = sha1Hmac.doFinal(feedbackUrl.getBytes(StandardCharsets.UTF_8));
            log.info("Signature: " + Base64.getUrlEncoder().encodeToString(hash));
            return Base64.getUrlEncoder().encodeToString(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static class CnvIdExtend {
        private String shallowConvId;
        private String deepConvId;

        public String getShallowConvId() {
            return this.shallowConvId;
        }

        public String getDeepConvId() {
            return this.deepConvId;
        }

        public void setShallowConvId(String shallowConvId) {
            this.shallowConvId = shallowConvId;
        }

        public void setDeepConvId(String deepConvId) {
            this.deepConvId = deepConvId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CnvIdExtend)) {
                return false;
            }
            CnvIdExtend other = (CnvIdExtend)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$shallowConvId = this.getShallowConvId();
            String other$shallowConvId = other.getShallowConvId();
            if (this$shallowConvId == null ? other$shallowConvId != null : !this$shallowConvId.equals(other$shallowConvId)) {
                return false;
            }
            String this$deepConvId = this.getDeepConvId();
            String other$deepConvId = other.getDeepConvId();
            return !(this$deepConvId == null ? other$deepConvId != null : !this$deepConvId.equals(other$deepConvId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CnvIdExtend;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $shallowConvId = this.getShallowConvId();
            result = result * 59 + ($shallowConvId == null ? 43 : $shallowConvId.hashCode());
            String $deepConvId = this.getDeepConvId();
            result = result * 59 + ($deepConvId == null ? 43 : $deepConvId.hashCode());
            return result;
        }

        public String toString() {
            return "SinaRtbIntegration.CnvIdExtend(shallowConvId=" + this.getShallowConvId() + ", deepConvId=" + this.getDeepConvId() + ")";
        }
    }

    private static class Response
    extends FeedbackResponse {
        private String code;
        private String info;

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"600100", (String)this.code);
        }

        public String getCode() {
            return this.code;
        }

        public String getInfo() {
            return this.info;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$info = this.getInfo();
            String other$info = other.getInfo();
            return !(this$info == null ? other$info != null : !this$info.equals(other$info));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $info = this.getInfo();
            result = result * 59 + ($info == null ? 43 : $info.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "SinaRtbIntegration.Response(code=" + this.getCode() + ", info=" + this.getInfo() + ")";
        }
    }
}

