/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.smallstep;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.smallstep.SmallStepConfig;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class SmallStepRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(SmallStepRtbIntegration.class);

    public SmallStepRtbIntegration(SmallStepConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.SmallStep;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String sub1 = (String)queryParams.getFirst((Object)"sub1");
        String sub2 = (String)queryParams.getFirst((Object)"sub2");
        String sub3 = (String)queryParams.getFirst((Object)"sub3");
        String sub4 = (String)queryParams.getFirst((Object)"sub4");
        if (StringUtils.isBlank((String)sub1)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sub1' by referrer.");
        }
        if (StringUtils.isBlank((String)sub2)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sub2' by referrer.");
        }
        if (StringUtils.isBlank((String)sub3)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sub3' by referrer.");
        }
        if (StringUtils.isBlank((String)sub4)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sub4' by referrer.");
        }
        HashMap params = Maps.newHashMap();
        params.put("s_param1", sub1);
        params.put("s_param2", sub2);
        params.put("s_param3", sub3);
        params.put("s_param4", sub4);
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

