/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.smsmedia;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.smsmedia.SmsMediaConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class SmsMediaRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(SmsMediaRtbIntegration.class);
    public static final String CLICK_ID = "bxmid";

    public SmsMediaRtbIntegration(SmsMediaConfig config) {
        super(config, SmsMediaRtbIntegration.createHttpClient());
    }

    @Override
    public Rtb rtb() {
        return Rtb.SMS_MEDIA;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return (String)clickEventLog.getFirst((Object)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        return (String)keyValueMap.getFirst((Object)"tagid");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String bxmId = (String)keyValueMap.getFirst((Object)CLICK_ID);
        String callbackUrl = (String)keyValueMap.getFirst((Object)"callback");
        if (StringUtils.isBlank((String)callbackUrl)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback' by KeyValueMap.");
        }
        if (StringUtils.isBlank((String)bxmId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'bxmId' by KeyValueMap.");
        }
        String url = UriComponentsBuilder.fromUriString((String)callbackUrl).queryParam("orderId", new Object[]{bxmId}).build().toString();
        log.info("sms media url: {}", (Object)url);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

    private static HttpClient createHttpClient() {
        return SmsMediaRtbIntegration.createHttpClient(20, 20, 1500, 1500, 2000);
    }

    private static HttpClient createHttpClient(int maxTotal, int defaultMaxPerRoute, int connectionRequestTimeout, int connectTimeout, int socketTimeout) {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        connManager.setMaxTotal(maxTotal);
        connManager.setDefaultMaxPerRoute(defaultMaxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(false).setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).setExpectContinueEnabled(false).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig).build();
    }
}

