/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.uc;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.uc.UcConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class UcRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(UcRtbIntegration.class);
    public static final String CLICK_ID = "uctrackid";
    public static final String AD_GROUP_ID = "campaignid";
    private final UcConfig config;

    public UcRtbIntegration(UcConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String clickId = this.getClickIdOnInadsAdClickLog(request.getKeyValueMap());
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        String positionId = (String)request.getKeyValueMap().getFirst((Object)"tagid");
        if (StringUtils.isBlank((String)positionId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'tagid'.");
        }
        String uctrackid = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)uctrackid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'uctrackid' by referrer.");
        }
        String[] arr = StringUtils.split((String)positionId, (String)"-");
        if (arr.length < 2) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Illegal value of 'tagid'.");
        }
        String appKey = arr[0];
        String entrance = arr[1];
        String linkConfig = request.getConfig().getCustomerId();
        String link = StringUtils.isNotBlank((String)linkConfig) ? this.config.getReturnLinkUrl().replace("i.bianxianmao.com", linkConfig).replace("__APPKEY__", appKey).replace("__APPENNTRANCE__", entrance) + "&uctrackid=" + uctrackid : this.config.getReturnLinkUrl().replace("__APPKEY__", appKey).replace("__APPENNTRANCE__", entrance) + "&uctrackid=" + uctrackid;
        HashMap params = Maps.newHashMap();
        params.put("link", link);
        params.put("event_type", eventType);
        params.put("event_time", String.valueOf(System.currentTimeMillis()));
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Uc;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Response
    extends FeedbackResponse {
        private String status;
        private String message;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"0", (String)this.status);
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

