/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.weibo;

import com.alibaba.fastjson.JSON;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.weibo.WeiBoAppConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiBoAppRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(WeiBoAppRtbIntegration.class);
    public static final String COMPANY = "company";

    public WeiBoAppRtbIntegration(WeiBoAppConfig config) {
        super(config);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String imp = request.getClickId();
        if (StringUtils.isBlank((String)imp)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "IMP is empty");
        }
        KeyValueMap map = request.getKeyValueMap();
        String company = (String)map.getFirst((Object)COMPANY);
        if (StringUtils.isBlank((String)company)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "company is empty");
        }
        HashMap params = Maps.newHashMap();
        params.put(COMPANY, company);
        params.put("IMP", imp);
        params.put("action_type", request.getEventType());
        params.put("active_time", System.currentTimeMillis() / 1000L);
        String idfaMd5 = (String)map.getFirst((Object)"idfa_md5");
        String oaidMd5 = (String)map.getFirst((Object)"oaid_md5");
        String imeiMd5 = (String)map.getFirst((Object)"imei_md5");
        if (StringUtils.isNotBlank((String)idfaMd5)) {
            params.put("idfa", idfaMd5);
        } else if (StringUtils.isNotBlank((String)oaidMd5)) {
            params.put("oaid", oaidMd5);
        } else if (StringUtils.isNotBlank((String)imeiMd5)) {
            params.put("imei", imeiMd5);
        } else {
            throw new RtbIntegrationException(FailType.IllegalParameter, "device is empty");
        }
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        Response response = (Response)JSON.parseObject((String)body, Response.class);
        if (Objects.isNull(response) || !response.isSuccess()) {
            throw new RtbIntegrationException(FailType.OtherException, response.getResult());
        }
        return FeedbackResponse.ofSuccess();
    }

    @Override
    public Rtb rtb() {
        return Rtb.WeiBoApp;
    }

    public static class Response {
        private String result;
        private String Code;

        public boolean isSuccess() {
            return Objects.equals("OK", this.result) && Objects.equals("0", this.Code);
        }

        public String getResult() {
            return this.result;
        }

        public String getCode() {
            return this.Code;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public void setCode(String Code) {
            this.Code = Code;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            String this$Code = this.getCode();
            String other$Code = other.getCode();
            return !(this$Code == null ? other$Code != null : !this$Code.equals(other$Code));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            String $Code = this.getCode();
            result = result * 59 + ($Code == null ? 43 : $Code.hashCode());
            return result;
        }

        public String toString() {
            return "WeiBoAppRtbIntegration.Response(result=" + this.getResult() + ", Code=" + this.getCode() + ")";
        }
    }
}

