/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.weibo;

import com.alibaba.fastjson.JSON;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.weibo.WeiBoConfig;
import com.bxm.adsmanager.facade.model.adTag.TblAdTagVo;
import com.bxm.adsmanager.facade.service.AdTagFacadeService;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.UriComponentsBuilder;

public class WeiBoRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(WeiBoRtbIntegration.class);
    public static final String CLICK_ID = "mark_id";
    private final WeiBoConfig config;
    private Fetcher fetcher;
    @Autowired(required=false)
    private AdTagFacadeService tagFacadeService;

    public WeiBoRtbIntegration(WeiBoConfig config) {
        super(config);
        this.config = config;
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(4000).setConnectionRequestTimeout(1000).setConnectTimeout(1000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    @Autowired
    public void setFetcher(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        ActionType actionType = request.getActionType();
        if (Objects.isNull((Object)actionType)) {
            return (String)keyValueMap.getFirst((Object)"tagid");
        }
        PositionRtb positionRtb = request.getConfig();
        if (positionRtb.isFeedbackModeSummaryCpa()) {
            return (String)keyValueMap.getFirst((Object)"tagid");
        }
        switch (actionType) {
            case TICKET_CLICK: 
            case TICKET_CONVERSION: {
                return (String)keyValueMap.getFirst((Object)"adid");
            }
        }
        return (String)keyValueMap.getFirst((Object)"tagid");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        PositionRtb positionRtb = request.getConfig();
        String markId = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)markId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, positionRtb.getPositionId() + "\uff1aCannot found 'mark_id' by referrer.");
        }
        String appId = request.getConfig().getCustomerId();
        if (StringUtils.isBlank((String)appId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, positionRtb.getPositionId() + "\uff1aCannot found 'appId' by weibo.");
        }
        WBToken wbToken = this.fetchWeiboTokenByAppId(appId);
        if (Objects.isNull(wbToken) || StringUtils.isEmpty((String)wbToken.getAccess_token())) {
            throw new RtbIntegrationException(FailType.IllegalParameter, appId + "Cannot found 'wbToken' by weibo.");
        }
        HashMap params = Maps.newHashMap();
        params.put("time", System.currentTimeMillis());
        params.put(CLICK_ID, UrlHelper.urlDecode((String)markId));
        params.put("behavior", eventType);
        if (Objects.equals(BehaviorEnum.ORDER.code, eventType)) {
            params.put("item_order_pay", UrlHelper.urlEncode((String)this.buildOrderInfo(request)));
        }
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Authorization", "Bearer " + wbToken.getAccess_token());
        httpGet.addHeader("Accept", "application/json,application/text+gw2.0");
        return httpGet;
    }

    private String buildOrderInfo(FeedbackRequest request) {
        String time = String.valueOf(System.currentTimeMillis());
        PositionRtb positionRtb = request.getConfig();
        KeyValueMap map = request.getKeyValueMap();
        Ticket ticket = (Ticket)this.fetcher.hfetch(new TargetFactory().keyGenerator(TicketKeyGenerator.getAllTickets()).field((String)map.getFirst((Object)"adid")).skipNativeCache(true).cls(Ticket.class).build());
        String goodsName = (String)map.getFirst((Object)"goods_name");
        if (StringUtils.isEmpty((String)goodsName) && CollectionUtils.isNotEmpty((Collection)ticket.getTags())) {
            List tags = ticket.getTags();
            TblAdTagVo tag = (TblAdTagVo)this.tagFacadeService.findAppointLevelTag(Integer.valueOf(Integer.parseInt(((Tag)tags.get(tags.size() - 1)).getCode())), Integer.valueOf(2), Integer.valueOf(2)).getReturnValue();
            goodsName = tag != null ? tag.getName() : goodsName;
        }
        Integer cpaPrice = request.getConversionLevel() == 2 ? ticket.getDeepCpaPrice() : ticket.getCpaPrice();
        OrderInfo orderInfo = OrderInfo.builder().click_time(Optional.ofNullable(map.getFirst((Object)"time")).filter(StringUtils::isNotEmpty).orElse(time)).order_create_time(Optional.ofNullable(map.getFirst((Object)"order_create_time")).filter(StringUtils::isNotEmpty).orElse(time)).order_pay_time(Optional.ofNullable(map.getFirst((Object)"order_pay_time")).filter(StringUtils::isNotEmpty).orElse(time)).order_pay_click_time(Optional.ofNullable(map.getFirst((Object)"order_pay_time")).filter(StringUtils::isNotEmpty).orElse(time)).item_name(goodsName).item_price(Optional.ofNullable(map.getFirst((Object)"goods_price")).filter(StringUtils::isNotEmpty).map(Float::parseFloat).orElse(Float.valueOf((float)cpaPrice.intValue() / 1000.0f))).payment_amount(Optional.ofNullable(map.getFirst((Object)"pay_amount")).filter(StringUtils::isNotEmpty).map(Float::parseFloat).orElse(Float.valueOf((float)cpaPrice.intValue() / 1000.0f))).quantity_of_item(Optional.ofNullable(map.getFirst((Object)"goods_quantity")).filter(StringUtils::isNotEmpty).map(Integer::parseInt).orElse(1)).category(request.getConversionLevel() == 1 ? positionRtb.getCidCategoryOne() : positionRtb.getCidCategoryTwo()).order_status("\u5df2\u4ed8\u6b3e").order_id(Optional.ofNullable(map.getFirst((Object)"order_id")).filter(StringUtils::isNotEmpty).orElse((String)map.getFirst((Object)"bxmid"))).service_provider("\u53d8\u73b0\u732b").build();
        return JSON.toJSONString((Object)orderInfo);
    }

    private WBToken fetchWeiboTokenByAppId(String appId) {
        return (WBToken)this.fetcher.hfetch(new TargetFactory().keyGenerator(() -> KeyBuilder.build((Object[])new Object[]{"wb", "token"})).field(appId).skipNativeCache(true).cls(WBToken.class).build());
    }

    @Override
    public Rtb rtb() {
        return Rtb.WeiBo;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    static class OrderInfo {
        private String click_time;
        private String order_create_time;
        private String order_pay_time;
        private String order_pay_click_time;
        private String item_name;
        private Float item_price;
        private Float payment_amount;
        private Integer quantity_of_item;
        private String category;
        private String order_status;
        private String order_id;
        private String service_provider;
        private Integer order_type;
        private Integer is_same_item;

        public static OrderInfoBuilder builder() {
            return new OrderInfoBuilder();
        }

        public String getClick_time() {
            return this.click_time;
        }

        public String getOrder_create_time() {
            return this.order_create_time;
        }

        public String getOrder_pay_time() {
            return this.order_pay_time;
        }

        public String getOrder_pay_click_time() {
            return this.order_pay_click_time;
        }

        public String getItem_name() {
            return this.item_name;
        }

        public Float getItem_price() {
            return this.item_price;
        }

        public Float getPayment_amount() {
            return this.payment_amount;
        }

        public Integer getQuantity_of_item() {
            return this.quantity_of_item;
        }

        public String getCategory() {
            return this.category;
        }

        public String getOrder_status() {
            return this.order_status;
        }

        public String getOrder_id() {
            return this.order_id;
        }

        public String getService_provider() {
            return this.service_provider;
        }

        public Integer getOrder_type() {
            return this.order_type;
        }

        public Integer getIs_same_item() {
            return this.is_same_item;
        }

        public void setClick_time(String click_time) {
            this.click_time = click_time;
        }

        public void setOrder_create_time(String order_create_time) {
            this.order_create_time = order_create_time;
        }

        public void setOrder_pay_time(String order_pay_time) {
            this.order_pay_time = order_pay_time;
        }

        public void setOrder_pay_click_time(String order_pay_click_time) {
            this.order_pay_click_time = order_pay_click_time;
        }

        public void setItem_name(String item_name) {
            this.item_name = item_name;
        }

        public void setItem_price(Float item_price) {
            this.item_price = item_price;
        }

        public void setPayment_amount(Float payment_amount) {
            this.payment_amount = payment_amount;
        }

        public void setQuantity_of_item(Integer quantity_of_item) {
            this.quantity_of_item = quantity_of_item;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public void setOrder_status(String order_status) {
            this.order_status = order_status;
        }

        public void setOrder_id(String order_id) {
            this.order_id = order_id;
        }

        public void setService_provider(String service_provider) {
            this.service_provider = service_provider;
        }

        public void setOrder_type(Integer order_type) {
            this.order_type = order_type;
        }

        public void setIs_same_item(Integer is_same_item) {
            this.is_same_item = is_same_item;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderInfo)) {
                return false;
            }
            OrderInfo other = (OrderInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Float this$item_price = this.getItem_price();
            Float other$item_price = other.getItem_price();
            if (this$item_price == null ? other$item_price != null : !((Object)this$item_price).equals(other$item_price)) {
                return false;
            }
            Float this$payment_amount = this.getPayment_amount();
            Float other$payment_amount = other.getPayment_amount();
            if (this$payment_amount == null ? other$payment_amount != null : !((Object)this$payment_amount).equals(other$payment_amount)) {
                return false;
            }
            Integer this$quantity_of_item = this.getQuantity_of_item();
            Integer other$quantity_of_item = other.getQuantity_of_item();
            if (this$quantity_of_item == null ? other$quantity_of_item != null : !((Object)this$quantity_of_item).equals(other$quantity_of_item)) {
                return false;
            }
            Integer this$order_type = this.getOrder_type();
            Integer other$order_type = other.getOrder_type();
            if (this$order_type == null ? other$order_type != null : !((Object)this$order_type).equals(other$order_type)) {
                return false;
            }
            Integer this$is_same_item = this.getIs_same_item();
            Integer other$is_same_item = other.getIs_same_item();
            if (this$is_same_item == null ? other$is_same_item != null : !((Object)this$is_same_item).equals(other$is_same_item)) {
                return false;
            }
            String this$click_time = this.getClick_time();
            String other$click_time = other.getClick_time();
            if (this$click_time == null ? other$click_time != null : !this$click_time.equals(other$click_time)) {
                return false;
            }
            String this$order_create_time = this.getOrder_create_time();
            String other$order_create_time = other.getOrder_create_time();
            if (this$order_create_time == null ? other$order_create_time != null : !this$order_create_time.equals(other$order_create_time)) {
                return false;
            }
            String this$order_pay_time = this.getOrder_pay_time();
            String other$order_pay_time = other.getOrder_pay_time();
            if (this$order_pay_time == null ? other$order_pay_time != null : !this$order_pay_time.equals(other$order_pay_time)) {
                return false;
            }
            String this$order_pay_click_time = this.getOrder_pay_click_time();
            String other$order_pay_click_time = other.getOrder_pay_click_time();
            if (this$order_pay_click_time == null ? other$order_pay_click_time != null : !this$order_pay_click_time.equals(other$order_pay_click_time)) {
                return false;
            }
            String this$item_name = this.getItem_name();
            String other$item_name = other.getItem_name();
            if (this$item_name == null ? other$item_name != null : !this$item_name.equals(other$item_name)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$order_status = this.getOrder_status();
            String other$order_status = other.getOrder_status();
            if (this$order_status == null ? other$order_status != null : !this$order_status.equals(other$order_status)) {
                return false;
            }
            String this$order_id = this.getOrder_id();
            String other$order_id = other.getOrder_id();
            if (this$order_id == null ? other$order_id != null : !this$order_id.equals(other$order_id)) {
                return false;
            }
            String this$service_provider = this.getService_provider();
            String other$service_provider = other.getService_provider();
            return !(this$service_provider == null ? other$service_provider != null : !this$service_provider.equals(other$service_provider));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Float $item_price = this.getItem_price();
            result = result * 59 + ($item_price == null ? 43 : ((Object)$item_price).hashCode());
            Float $payment_amount = this.getPayment_amount();
            result = result * 59 + ($payment_amount == null ? 43 : ((Object)$payment_amount).hashCode());
            Integer $quantity_of_item = this.getQuantity_of_item();
            result = result * 59 + ($quantity_of_item == null ? 43 : ((Object)$quantity_of_item).hashCode());
            Integer $order_type = this.getOrder_type();
            result = result * 59 + ($order_type == null ? 43 : ((Object)$order_type).hashCode());
            Integer $is_same_item = this.getIs_same_item();
            result = result * 59 + ($is_same_item == null ? 43 : ((Object)$is_same_item).hashCode());
            String $click_time = this.getClick_time();
            result = result * 59 + ($click_time == null ? 43 : $click_time.hashCode());
            String $order_create_time = this.getOrder_create_time();
            result = result * 59 + ($order_create_time == null ? 43 : $order_create_time.hashCode());
            String $order_pay_time = this.getOrder_pay_time();
            result = result * 59 + ($order_pay_time == null ? 43 : $order_pay_time.hashCode());
            String $order_pay_click_time = this.getOrder_pay_click_time();
            result = result * 59 + ($order_pay_click_time == null ? 43 : $order_pay_click_time.hashCode());
            String $item_name = this.getItem_name();
            result = result * 59 + ($item_name == null ? 43 : $item_name.hashCode());
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $order_status = this.getOrder_status();
            result = result * 59 + ($order_status == null ? 43 : $order_status.hashCode());
            String $order_id = this.getOrder_id();
            result = result * 59 + ($order_id == null ? 43 : $order_id.hashCode());
            String $service_provider = this.getService_provider();
            result = result * 59 + ($service_provider == null ? 43 : $service_provider.hashCode());
            return result;
        }

        public String toString() {
            return "WeiBoRtbIntegration.OrderInfo(click_time=" + this.getClick_time() + ", order_create_time=" + this.getOrder_create_time() + ", order_pay_time=" + this.getOrder_pay_time() + ", order_pay_click_time=" + this.getOrder_pay_click_time() + ", item_name=" + this.getItem_name() + ", item_price=" + this.getItem_price() + ", payment_amount=" + this.getPayment_amount() + ", quantity_of_item=" + this.getQuantity_of_item() + ", category=" + this.getCategory() + ", order_status=" + this.getOrder_status() + ", order_id=" + this.getOrder_id() + ", service_provider=" + this.getService_provider() + ", order_type=" + this.getOrder_type() + ", is_same_item=" + this.getIs_same_item() + ")";
        }

        public OrderInfo(String click_time, String order_create_time, String order_pay_time, String order_pay_click_time, String item_name, Float item_price, Float payment_amount, Integer quantity_of_item, String category, String order_status, String order_id, String service_provider, Integer order_type, Integer is_same_item) {
            this.click_time = click_time;
            this.order_create_time = order_create_time;
            this.order_pay_time = order_pay_time;
            this.order_pay_click_time = order_pay_click_time;
            this.item_name = item_name;
            this.item_price = item_price;
            this.payment_amount = payment_amount;
            this.quantity_of_item = quantity_of_item;
            this.category = category;
            this.order_status = order_status;
            this.order_id = order_id;
            this.service_provider = service_provider;
            this.order_type = order_type;
            this.is_same_item = is_same_item;
        }

        public OrderInfo() {
        }

        public static class OrderInfoBuilder {
            private String click_time;
            private String order_create_time;
            private String order_pay_time;
            private String order_pay_click_time;
            private String item_name;
            private Float item_price;
            private Float payment_amount;
            private Integer quantity_of_item;
            private String category;
            private String order_status;
            private String order_id;
            private String service_provider;
            private Integer order_type;
            private Integer is_same_item;

            OrderInfoBuilder() {
            }

            public OrderInfoBuilder click_time(String click_time) {
                this.click_time = click_time;
                return this;
            }

            public OrderInfoBuilder order_create_time(String order_create_time) {
                this.order_create_time = order_create_time;
                return this;
            }

            public OrderInfoBuilder order_pay_time(String order_pay_time) {
                this.order_pay_time = order_pay_time;
                return this;
            }

            public OrderInfoBuilder order_pay_click_time(String order_pay_click_time) {
                this.order_pay_click_time = order_pay_click_time;
                return this;
            }

            public OrderInfoBuilder item_name(String item_name) {
                this.item_name = item_name;
                return this;
            }

            public OrderInfoBuilder item_price(Float item_price) {
                this.item_price = item_price;
                return this;
            }

            public OrderInfoBuilder payment_amount(Float payment_amount) {
                this.payment_amount = payment_amount;
                return this;
            }

            public OrderInfoBuilder quantity_of_item(Integer quantity_of_item) {
                this.quantity_of_item = quantity_of_item;
                return this;
            }

            public OrderInfoBuilder category(String category) {
                this.category = category;
                return this;
            }

            public OrderInfoBuilder order_status(String order_status) {
                this.order_status = order_status;
                return this;
            }

            public OrderInfoBuilder order_id(String order_id) {
                this.order_id = order_id;
                return this;
            }

            public OrderInfoBuilder service_provider(String service_provider) {
                this.service_provider = service_provider;
                return this;
            }

            public OrderInfoBuilder order_type(Integer order_type) {
                this.order_type = order_type;
                return this;
            }

            public OrderInfoBuilder is_same_item(Integer is_same_item) {
                this.is_same_item = is_same_item;
                return this;
            }

            public OrderInfo build() {
                return new OrderInfo(this.click_time, this.order_create_time, this.order_pay_time, this.order_pay_click_time, this.item_name, this.item_price, this.payment_amount, this.quantity_of_item, this.category, this.order_status, this.order_id, this.service_provider, this.order_type, this.is_same_item);
            }

            public String toString() {
                return "WeiBoRtbIntegration.OrderInfo.OrderInfoBuilder(click_time=" + this.click_time + ", order_create_time=" + this.order_create_time + ", order_pay_time=" + this.order_pay_time + ", order_pay_click_time=" + this.order_pay_click_time + ", item_name=" + this.item_name + ", item_price=" + this.item_price + ", payment_amount=" + this.payment_amount + ", quantity_of_item=" + this.quantity_of_item + ", category=" + this.category + ", order_status=" + this.order_status + ", order_id=" + this.order_id + ", service_provider=" + this.service_provider + ", order_type=" + this.order_type + ", is_same_item=" + this.is_same_item + ")";
            }
        }
    }

    static enum BehaviorEnum {
        ORDER("2001"),
        PROGRAM("3003");

        private final String code;

        private BehaviorEnum(String code) {
            this.code = code;
        }
    }

    static class WBToken {
        private String access_token;
        private String expires_in;
        private String exDate;

        public String getAccess_token() {
            return this.access_token;
        }

        public String getExpires_in() {
            return this.expires_in;
        }

        public String getExDate() {
            return this.exDate;
        }

        public void setAccess_token(String access_token) {
            this.access_token = access_token;
        }

        public void setExpires_in(String expires_in) {
            this.expires_in = expires_in;
        }

        public void setExDate(String exDate) {
            this.exDate = exDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WBToken)) {
                return false;
            }
            WBToken other = (WBToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$access_token = this.getAccess_token();
            String other$access_token = other.getAccess_token();
            if (this$access_token == null ? other$access_token != null : !this$access_token.equals(other$access_token)) {
                return false;
            }
            String this$expires_in = this.getExpires_in();
            String other$expires_in = other.getExpires_in();
            if (this$expires_in == null ? other$expires_in != null : !this$expires_in.equals(other$expires_in)) {
                return false;
            }
            String this$exDate = this.getExDate();
            String other$exDate = other.getExDate();
            return !(this$exDate == null ? other$exDate != null : !this$exDate.equals(other$exDate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WBToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $access_token = this.getAccess_token();
            result = result * 59 + ($access_token == null ? 43 : $access_token.hashCode());
            String $expires_in = this.getExpires_in();
            result = result * 59 + ($expires_in == null ? 43 : $expires_in.hashCode());
            String $exDate = this.getExDate();
            result = result * 59 + ($exDate == null ? 43 : $exDate.hashCode());
            return result;
        }

        public String toString() {
            return "WeiBoRtbIntegration.WBToken(access_token=" + this.getAccess_token() + ", expires_in=" + this.getExpires_in() + ", exDate=" + this.getExDate() + ")";
        }
    }

    private static class Response
    extends FeedbackResponse {
        private static final String CODE_UNIQ_REPEAT = "40001";
        private static final String CODE_AK_EXPIRED = "40113";
        private String code;
        private String message;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"0", (String)this.code) || StringUtils.equals((String)CODE_UNIQ_REPEAT, (String)this.code);
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

