/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.wifi;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.wifi.WifiConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class WifiRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(WifiRtbIntegration.class);
    private final WifiConfig config;

    public WifiRtbIntegration(WifiConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "sid";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        String clickIdParameterNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        String sid = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank((String)sid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        PositionRtb config = request.getConfig();
        HashMap params = Maps.newHashMap();
        params.put("clientid", config.getCustomerId());
        params.put("sid", sid);
        params.put("event_type", eventType);
        params.put("sign", WifiRtbIntegration.getSign(params, config.getToken()));
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    private static String getSign(Map<String, Object> params, String token) {
        TreeMap<String, Object> sortParams = new TreeMap<String, Object>(params);
        Set entrys = sortParams.entrySet();
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry entry : entrys) {
            valueSb.append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        String value = valueSb.toString().substring(0, valueSb.toString().length() - 1) + token;
        return DigestUtils.md5Hex((String)value).toUpperCase();
    }

    @Override
    public Rtb rtb() {
        return Rtb.WIFI;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return false;
    }
}

