/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.xmly;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.xmly.HimalayanConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class HimalayanRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(HimalayanRtbIntegration.class);
    public static final String CLICK_ID = "callback";
    public static final String AD_GROUP_ID = "materialid";

    public HimalayanRtbIntegration(HimalayanConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        String ref = clickEventLog.getRef();
        String clickId = UrlHelper.getFirstValueOfParamName((String)ref, (String)CLICK_ID);
        if (StringUtils.isBlank((String)clickId)) {
            log.warn("Not found: {}", (Object)ref);
            return null;
        }
        return DigestUtils.md5Hex((String)UrlHelper.urlDecode((String)clickId));
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        String clickId = (String)queryParams.getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)clickId)) {
            log.warn("Not found: {}", (Object)referrer);
            return null;
        }
        KeyValueMap clickTracker = this.getClickTracker(DigestUtils.md5Hex((String)UrlHelper.urlDecode((String)clickId)));
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        String callback = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback' by referrer.");
        }
        callback = UrlHelper.urlDecode((String)callback);
        return new HttpGet(callback.trim() + "&event_type=" + eventType);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Ximalaya;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Response
    extends FeedbackResponse {
        private String type;
        private String text;
        private String data;
        private String errors;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase((String)"SUCCESS", (String)this.type);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getErrors() {
            return this.errors;
        }

        public void setErrors(String errors) {
            this.errors = errors;
        }
    }
}

