/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.youku;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.youku.MapStrUtil;
import com.bxm.adscounter.rtb.common.impl.youku.SignUtil;
import com.bxm.adscounter.rtb.common.impl.youku.YoukuConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class YoukuRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(YoukuRtbIntegration.class);

    public YoukuRtbIntegration(YoukuConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.YOUKU;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "track_id";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        String ip = (String)request.getKeyValueMap().getFirst((Object)"ip");
        PositionRtb positionRtb = request.getConfig();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String clickIdParameterNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        String track_id = (String)queryParams.getFirst((Object)clickIdParameterNameOnReferrer);
        String creative_id = (String)queryParams.getFirst((Object)"creative_id");
        if (StringUtils.isBlank((String)track_id)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        if (StringUtils.isBlank((String)creative_id)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'creative_id' by referrer.");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("event_type", eventType);
        param.put("event_time", System.currentTimeMillis());
        param.put("track_id", track_id);
        param.put("deep_conv", 0);
        param.put("client_ip", ip);
        param.put("creative_id", creative_id);
        String sign = SignUtil.sign(positionRtb.getCustomerId(), positionRtb.getToken(), MapStrUtil.toStr(param));
        RequestYouku requestYouku = new RequestYouku();
        requestYouku.setAppKey(positionRtb.getCustomerId());
        requestYouku.setContent(param);
        requestYouku.setSignature(sign);
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)requestYouku), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class RequestYouku {
        private String appKey;
        private String signature;
        private Map<String, Object> content;

        public String getAppKey() {
            return this.appKey;
        }

        public String getSignature() {
            return this.signature;
        }

        public Map<String, Object> getContent() {
            return this.content;
        }

        public void setAppKey(String appKey) {
            this.appKey = appKey;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public void setContent(Map<String, Object> content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestYouku)) {
                return false;
            }
            RequestYouku other = (RequestYouku)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appKey = this.getAppKey();
            String other$appKey = other.getAppKey();
            if (this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            Map<String, Object> this$content = this.getContent();
            Map<String, Object> other$content = other.getContent();
            return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestYouku;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appKey = this.getAppKey();
            result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            Map<String, Object> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            return result;
        }

        public String toString() {
            return "YoukuRtbIntegration.RequestYouku(appKey=" + this.getAppKey() + ", signature=" + this.getSignature() + ", content=" + this.getContent() + ")";
        }
    }

    private static class Response
    extends FeedbackResponse {
        private String msg;
        private String msgCode;
        private String data;

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase((String)"success", (String)this.msg);
        }

        public String getMsg() {
            return this.msg;
        }

        public String getMsgCode() {
            return this.msgCode;
        }

        public String getData() {
            return this.data;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setMsgCode(String msgCode) {
            this.msgCode = msgCode;
        }

        public void setData(String data) {
            this.data = data;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            String this$msgCode = this.getMsgCode();
            String other$msgCode = other.getMsgCode();
            if (this$msgCode == null ? other$msgCode != null : !this$msgCode.equals(other$msgCode)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            String $msgCode = this.getMsgCode();
            result = result * 59 + ($msgCode == null ? 43 : $msgCode.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "YoukuRtbIntegration.Response(msg=" + this.getMsg() + ", msgCode=" + this.getMsgCode() + ", data=" + this.getData() + ")";
        }
    }
}

