/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.extension.client;

import com.bxm.openlog.extension.client.Fallback;
import com.bxm.openlog.extension.client.HttpClientUtils;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.utils.NamedThreadFactory;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class HttpClientOpenLogClient
implements OpenLogClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClientOpenLogClient.class);
    private final ThreadPoolExecutor executor;
    private final HttpClient httpClient;
    private Timer timer;

    private HttpClientOpenLogClient(ThreadPoolExecutor executor, int maxTotal, int defaultMaxPerRoute, int connectionRequestTimeout, int connectTimeout, int socketTimeout) {
        this.executor = executor;
        this.httpClient = HttpClientUtils.createHttpClient(maxTotal, defaultMaxPerRoute, connectionRequestTimeout, connectTimeout, socketTimeout);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void bindTo(MeterRegistry registry) {
        Class clazz = ClassUtils.getUserClass((Object)this);
        this.registerGauge(registry, this, clazz);
        this.registerTimer(registry, this, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean request(String url) throws IOException {
        long start = System.nanoTime();
        HttpGet get = null;
        try {
            get = new HttpGet(url);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
        finally {
            if (Objects.nonNull(get)) {
                get.releaseConnection();
            }
            if (Objects.nonNull(this.timer)) {
                this.timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }

    @Override
    public void asyncRequest(String url, Consumer<Fallback> fallback) {
        this.executor.execute(() -> {
            block3: {
                try {
                    if (!this.request(url) && Objects.nonNull(fallback)) {
                        fallback.accept(Fallback.builder().url(url).build());
                    }
                }
                catch (IOException e) {
                    if (!Objects.nonNull(fallback)) break block3;
                    fallback.accept(Fallback.builder().url(url).exception(e).build());
                }
            }
        });
    }

    @Override
    public void asyncRequest(String url) {
        this.asyncRequest(url, null);
    }

    @Override
    public int queueSize() {
        return this.executor.getQueue().size();
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.warn("This executor was forced terminated!");
            }
        }
        catch (InterruptedException e) {
            log.error("awaitTermination: ", (Throwable)e);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    private void registerGauge(MeterRegistry registry, OpenLogClient client, Class<?> clazz) {
        Gauge.builder((String)"OpenLogClient.queue", (Object)0, value -> client.queueSize()).tags(new String[]{"name", clazz.getName()}).register(registry);
    }

    private void registerTimer(MeterRegistry registry, OpenLogClient client, Class<?> clazz) {
        this.timer = Timer.builder((String)"OpenLogClient.timer").tag("name", clazz.getName()).register(registry);
        log.info("Registering OpenLogClient {} timer meter successful.", (Object)client);
    }

    public static class Builder {
        private int maxTotal = 200;
        private int defaultMaxPerRoute = 20;
        private int connectionRequestTimeout = 100;
        private int connectTimeout = 200;
        private int socketTimeout = 500;
        private ThreadPoolExecutor executor;

        private Builder() {
            int processors = Runtime.getRuntime().availableProcessors();
            int max = 10000;
            this.executor = new ThreadPoolExecutor(processors, processors, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(max), (ThreadFactory)new NamedThreadFactory("openlog-client"));
        }

        public HttpClientOpenLogClient build() {
            return new HttpClientOpenLogClient(this.executor, this.maxTotal, this.defaultMaxPerRoute, this.connectionRequestTimeout, this.connectTimeout, this.socketTimeout);
        }

        public Builder setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public Builder setDefaultMaxPerRoute(int defaultMaxPerRoute) {
            this.defaultMaxPerRoute = defaultMaxPerRoute;
            return this;
        }

        public Builder setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setExecutor(ThreadPoolExecutor executor) {
            this.executor = executor;
            return this;
        }
    }
}

